/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.File;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.internal.adaptor.ContextFinder;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceReferenceImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;

public class BundleContextImpl
implements BundleContext,
EventDispatcher {
    private volatile boolean valid;
    final BundleHost bundle;
    final Framework framework;
    private HashMap servicesInUse;
    protected Map bundleEvent;
    protected Map bundleEventSync;
    protected Map frameworkEvent;
    protected BundleActivator activator;
    private final Object contextLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BundleContextImpl(BundleHost bundleHost) {
        this.bundle = bundleHost;
        this.valid = true;
        this.framework = bundleHost.framework;
        this.bundleEvent = null;
        this.bundleEventSync = null;
        this.frameworkEvent = null;
        Object object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
        this.activator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        this.valid = false;
        ServiceRegistry serviceRegistry = this.framework.getServiceRegistry();
        serviceRegistry.removeAllServiceListeners(this);
        Object object = this.framework.frameworkEvent;
        synchronized (object) {
            if (this.frameworkEvent != null) {
                this.framework.frameworkEvent.remove(this);
                this.frameworkEvent = null;
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            if (this.bundleEvent != null) {
                this.framework.bundleEvent.remove(this);
                this.bundleEvent = null;
            }
        }
        object = this.framework.bundleEventSync;
        synchronized (object) {
            if (this.bundleEventSync != null) {
                this.framework.bundleEventSync.remove(this);
                this.bundleEventSync = null;
            }
        }
        serviceRegistry.unregisterServices(this);
        serviceRegistry.releaseServicesInUse(this);
        object = this.contextLock;
        synchronized (object) {
            this.servicesInUse = null;
        }
    }

    public String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
        return this.framework.getProperty(string);
    }

    public Bundle getBundle() {
        this.checkValid();
        return this.getBundleImpl();
    }

    public AbstractBundle getBundleImpl() {
        return this.bundle;
    }

    public Bundle installBundle(String string) throws BundleException {
        return this.installBundle(string, null);
    }

    public Bundle installBundle(String string, InputStream inputStream) throws BundleException {
        this.checkValid();
        return this.framework.installBundle(string, inputStream);
    }

    public Bundle getBundle(long l) {
        return this.framework.getBundle(l);
    }

    public AbstractBundle getBundleByLocation(String string) {
        return this.framework.getBundleByLocation(string);
    }

    public Bundle[] getBundles() {
        return this.framework.getAllBundles();
    }

    public void addServiceListener(ServiceListener serviceListener, String string) throws InvalidSyntaxException {
        this.checkValid();
        if (serviceListener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().addServiceListener(this, serviceListener, string);
    }

    public void addServiceListener(ServiceListener serviceListener) {
        block2: {
            try {
                this.addServiceListener(serviceListener, null);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {
                if (!Debug.DEBUG_GENERAL) break block2;
                Debug.println("InvalidSyntaxException w/ null filter" + invalidSyntaxException.getMessage());
                Debug.printStackTrace(invalidSyntaxException);
            }
        }
    }

    public void removeServiceListener(ServiceListener serviceListener) {
        this.checkValid();
        if (serviceListener == null) {
            throw new IllegalArgumentException();
        }
        this.framework.getServiceRegistry().removeServiceListener(this, serviceListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBundleListener(BundleListener bundleListener) {
        Object object;
        this.checkValid();
        if (bundleListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(bundleListener));
            Debug.println("addBundleListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (bundleListener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            object = this.framework.bundleEventSync;
            synchronized (object) {
                this.checkValid();
                if (this.bundleEventSync == null) {
                    this.bundleEventSync = new CopyOnWriteIdentityMap();
                    this.framework.bundleEventSync.put(this, this);
                }
                this.bundleEventSync.put(bundleListener, bundleListener);
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            this.checkValid();
            if (this.bundleEvent == null) {
                this.bundleEvent = new CopyOnWriteIdentityMap();
                this.framework.bundleEvent.put(this, this);
            }
            this.bundleEvent.put(bundleListener, bundleListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBundleListener(BundleListener bundleListener) {
        Object object;
        this.checkValid();
        if (bundleListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(bundleListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(bundleListener));
            Debug.println("removeBundleListener[" + this.bundle + "](" + (String)object + ")");
        }
        if (bundleListener instanceof SynchronousBundleListener) {
            this.framework.checkAdminPermission(this.getBundle(), "listener");
            object = this.framework.bundleEventSync;
            synchronized (object) {
                if (this.bundleEventSync != null) {
                    this.bundleEventSync.remove(bundleListener);
                }
            }
        }
        object = this.framework.bundleEvent;
        synchronized (object) {
            if (this.bundleEvent != null) {
                this.bundleEvent.remove(bundleListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrameworkListener(FrameworkListener frameworkListener) {
        Object object;
        this.checkValid();
        if (frameworkListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(frameworkListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(frameworkListener));
            Debug.println("addFrameworkListener[" + this.bundle + "](" + (String)object + ")");
        }
        object = this.framework.frameworkEvent;
        synchronized (object) {
            this.checkValid();
            if (this.frameworkEvent == null) {
                this.frameworkEvent = new CopyOnWriteIdentityMap();
                this.framework.frameworkEvent.put(this, this);
            }
            this.frameworkEvent.put(frameworkListener, frameworkListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrameworkListener(FrameworkListener frameworkListener) {
        Object object;
        this.checkValid();
        if (frameworkListener == null) {
            throw new IllegalArgumentException();
        }
        if (Debug.DEBUG_EVENTS) {
            object = String.valueOf(frameworkListener.getClass().getName()) + "@" + Integer.toHexString(System.identityHashCode(frameworkListener));
            Debug.println("removeFrameworkListener[" + this.bundle + "](" + (String)object + ")");
        }
        object = this.framework.frameworkEvent;
        synchronized (object) {
            if (this.frameworkEvent != null) {
                this.frameworkEvent.remove(frameworkListener);
            }
        }
    }

    public ServiceRegistration registerService(String[] stringArray, Object object, Dictionary dictionary) {
        this.checkValid();
        return this.framework.getServiceRegistry().registerService(this, stringArray, object, dictionary);
    }

    public ServiceRegistration registerService(String string, Object object, Dictionary dictionary) {
        String[] stringArray = new String[]{string};
        return this.registerService(stringArray, object, dictionary);
    }

    public ServiceReference[] getServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, string, string2, false);
    }

    public ServiceReference[] getAllServiceReferences(String string, String string2) throws InvalidSyntaxException {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReferences(this, string, string2, true);
    }

    public ServiceReference getServiceReference(String string) {
        this.checkValid();
        return this.framework.getServiceRegistry().getServiceReference(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(ServiceReference serviceReference) {
        this.checkValid();
        if (serviceReference == null) {
            throw new NullPointerException("A null service reference is not allowed.");
        }
        Object object = this.contextLock;
        synchronized (object) {
            if (this.servicesInUse == null) {
                this.servicesInUse = new HashMap(10);
            }
        }
        return this.framework.getServiceRegistry().getService(this, (ServiceReferenceImpl)serviceReference);
    }

    public boolean ungetService(ServiceReference serviceReference) {
        this.checkValid();
        return this.framework.getServiceRegistry().ungetService(this, (ServiceReferenceImpl)serviceReference);
    }

    public File getDataFile(String string) {
        this.checkValid();
        return this.framework.getDataFile(this.bundle, string);
    }

    protected void start() throws BundleException {
        this.activator = this.bundle.loadBundleActivator();
        if (this.activator != null) {
            try {
                this.startActivator(this.activator);
            }
            catch (BundleException bundleException) {
                this.activator = null;
                throw bundleException;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void startActivator(BundleActivator var1_1) throws BundleException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 162->166)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    Object setContextFinder() {
        ContextFinder contextFinder;
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader != (contextFinder = this.framework.getContextFinder())) {
            thread.setContextClassLoader(this.framework.getContextFinder());
            return classLoader;
        }
        return Boolean.FALSE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stop() throws BundleException {
        try {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    /*
                     * Exception decompiling
                     */
                    public Object run() throws Exception {
                        /*
                         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                         * 
                         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 63->66)] java.lang.Throwable
                         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                         *     at org.benf.cfr.reader.Main.main(Main.java:54)
                         */
                        throw new IllegalStateException("Decompilation failed");
                    }
                });
            }
            catch (Throwable throwable) {
                Exception exception;
                if (throwable instanceof PrivilegedActionException) {
                    exception = ((PrivilegedActionException)throwable).getException();
                }
                if (Debug.DEBUG_GENERAL) {
                    Debug.printStackTrace(exception);
                }
                String string = this.activator == null ? "" : this.activator.getClass().getName();
                throw new BundleException(NLS.bind(Msg.BUNDLE_ACTIVATOR_EXCEPTION, new Object[]{string, "stop", this.bundle.getSymbolicName() == null ? "" + this.bundle.getBundleId() : this.bundle.getSymbolicName()}), 5, exception);
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.activator = null;
            throw throwable;
        }
        {
            Object var3_6 = null;
            this.activator = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getServicesInUseMap() {
        Object object = this.contextLock;
        synchronized (object) {
            return this.servicesInUse;
        }
    }

    /*
     * Exception decompiling
     */
    public void dispatchEvent(Object var1_1, Object var2_2, int var3_3, Object var4_4) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 566->570)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Filter createFilter(String string) throws InvalidSyntaxException {
        this.checkValid();
        return FilterImpl.newInstance(string);
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new IllegalStateException(Msg.BUNDLE_CONTEXT_INVALID_EXCEPTION);
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    public Framework getFramework() {
        return this.framework;
    }
}

