/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.framework.internal.core.ConsoleManager;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

public class EquinoxLauncher
implements org.osgi.framework.launch.Framework {
    private volatile Framework framework;
    private volatile Bundle systemBundle;
    private final Map configuration;
    private volatile ConsoleManager consoleMgr = null;

    public EquinoxLauncher(Map map) {
        this.configuration = map;
    }

    public void init() {
        this.checkAdminPermission("execute");
        if (System.getSecurityManager() == null) {
            this.internalInit();
        } else {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    EquinoxLauncher.this.internalInit();
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized Framework internalInit() {
        if ((this.getState() & 0x38) != 0) {
            return this.framework;
        }
        if (System.getSecurityManager() != null && this.configuration.get("org.osgi.framework.security") != null) {
            throw new SecurityException("Cannot specify the \"org.osgi.framework.security\" configuration property when a security manager is already installed.");
        }
        Framework framework = this.framework;
        if (framework != null) {
            framework.close();
            this.framework = null;
            this.systemBundle = null;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            FrameworkProperties.setProperties(this.configuration);
            FrameworkProperties.initializeProperties();
            this.setEquinoxProperties(this.configuration);
            framework = new Framework(new BaseAdaptor(new String[0]));
            this.consoleMgr = ConsoleManager.startConsole(framework);
            framework.launch();
            this.framework = framework;
            this.systemBundle = framework.systemBundle;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 == classLoader) throw throwable;
            Thread.currentThread().setContextClassLoader(classLoader);
            throw throwable;
        }
        {
            Object var3_5 = null;
            ClassLoader classLoader3 = Thread.currentThread().getContextClassLoader();
            if (classLoader3 == classLoader) return framework;
            Thread.currentThread().setContextClassLoader(classLoader);
            return framework;
        }
    }

    private void setEquinoxProperties(Map map) {
        Object object;
        Object v;
        Object v2;
        String string;
        Object var2_2;
        Object v0 = var2_2 = map == null ? null : map.get("osgi.framework.activeThreadType");
        if (var2_2 == null) {
            if (FrameworkProperties.getProperty("osgi.framework.activeThreadType") == null) {
                FrameworkProperties.setProperty("osgi.framework.activeThreadType", "normal");
            }
        } else {
            FrameworkProperties.setProperty("osgi.framework.activeThreadType", var2_2);
        }
        String string2 = string = map == null ? null : (String)map.get("org.osgi.framework.windowsystem");
        if (string == null && (string = FrameworkProperties.getProperty("osgi.ws")) != null) {
            FrameworkProperties.setProperty("org.osgi.framework.windowsystem", string);
        }
        if (map == null) {
            return;
        }
        Object v3 = map.get("org.osgi.framework.security");
        if (v3 != null) {
            if ("osgi".equals(v3)) {
                FrameworkProperties.setProperty("eclipse.security", "osgi");
            } else if (v3 instanceof String) {
                FrameworkProperties.setProperty("eclipse.security", (String)v3);
            }
        }
        if ((v2 = map.get("org.osgi.framework.storage")) != null && v2 instanceof String) {
            FrameworkProperties.setProperty("osgi.configuration.area", (String)v2);
        }
        if ("onFirstInit".equals(v = map.get("org.osgi.framework.storage.clean"))) {
            map.remove("org.osgi.framework.storage.clean");
            FrameworkProperties.setProperty("osgi.clean", Boolean.TRUE.toString());
        }
        if ("framework".equals(object = map.get("org.osgi.framework.bundle.parent"))) {
            object = "fwk";
        }
        if (object instanceof String) {
            FrameworkProperties.setProperty("osgi.parentClassloader", (String)object);
        }
    }

    public FrameworkEvent waitForStop(long l) throws InterruptedException {
        Framework framework = this.framework;
        if (framework == null) {
            return new FrameworkEvent(64, this, null);
        }
        return framework.waitForStop(l);
    }

    public Enumeration findEntries(String string, String string2, boolean bl) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.findEntries(string, string2, bl);
    }

    public BundleContext getBundleContext() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getBundleContext();
    }

    public long getBundleId() {
        return 0L;
    }

    public URL getEntry(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getEntry(string);
    }

    public Enumeration getEntryPaths(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getEntryPaths(string);
    }

    public Dictionary getHeaders() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getHeaders();
    }

    public Dictionary getHeaders(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getHeaders(string);
    }

    public long getLastModified() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return System.currentTimeMillis();
        }
        return bundle.getLastModified();
    }

    public String getLocation() {
        return "System Bundle";
    }

    public ServiceReference[] getRegisteredServices() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getRegisteredServices();
    }

    public URL getResource(String string) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getResource(string);
    }

    public Enumeration getResources(String string) throws IOException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getResources(string);
    }

    public ServiceReference[] getServicesInUse() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.getServicesInUse();
    }

    public int getState() {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return 2;
        }
        return bundle.getState();
    }

    public String getSymbolicName() {
        return "org.eclipse.osgi";
    }

    public boolean hasPermission(Object object) {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return false;
        }
        return bundle.hasPermission(object);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return null;
        }
        return bundle.loadClass(string);
    }

    public void start(int n) throws BundleException {
        this.start();
    }

    public void start() throws BundleException {
        this.checkAdminPermission("execute");
        if (System.getSecurityManager() == null) {
            this.internalStart();
        } else {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws BundleException {
                        EquinoxLauncher.this.internalStart();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (BundleException)privilegedActionException.getException();
            }
        }
    }

    private void checkAdminPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AdminPermission(this, string));
        }
    }

    void internalStart() throws BundleException {
        if (this.getState() == 32) {
            return;
        }
        Framework framework = this.internalInit();
        int n = 1;
        try {
            n = Integer.parseInt((String)this.configuration.get("org.osgi.framework.startlevel.beginning"));
        }
        catch (Throwable throwable) {}
        framework.startLevelManager.doSetStartLevel(n);
    }

    public void stop(int n) throws BundleException {
        this.stop();
    }

    public void stop() throws BundleException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return;
        }
        ConsoleManager consoleManager = this.consoleMgr;
        if (consoleManager != null) {
            consoleManager.stopConsole();
            this.consoleMgr = null;
        }
        bundle.stop();
    }

    public void uninstall() throws BundleException {
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
    }

    public void update() throws BundleException {
        Bundle bundle = this.systemBundle;
        if (bundle == null) {
            return;
        }
        bundle.update();
    }

    public void update(InputStream inputStream) throws BundleException {
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        this.update();
    }

    public Map getSignerCertificates(int n) {
        Bundle bundle = this.systemBundle;
        if (bundle != null) {
            return bundle.getSignerCertificates(n);
        }
        return Collections.EMPTY_MAP;
    }

    public Version getVersion() {
        Bundle bundle = this.systemBundle;
        if (bundle != null) {
            bundle.getVersion();
        }
        return Version.emptyVersion;
    }
}

