/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.ExportedPackageImpl;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.InternalSystemBundle;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.profile.Profile;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.NativeCodeDescription;
import org.eclipse.osgi.service.resolver.NativeCodeSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundlePermission;
import org.osgi.framework.Version;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.packageadmin.RequiredBundle;

public class PackageAdminImpl
implements PackageAdmin {
    protected Framework framework;
    private Map removalPendings = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.PackageAdminImpl$GetBundleAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        clazz2.getName();
    }

    protected PackageAdminImpl(Framework framework) {
        this.framework = framework;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportedPackage[] getExportedPackages(Bundle bundle) {
        ArrayList<ExportedPackageImpl> arrayList = new ArrayList<ExportedPackageImpl>();
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            FrameworkAdaptor frameworkAdaptor;
            block6: {
                frameworkAdaptor = this.framework.adaptor;
                if (frameworkAdaptor != null) break block6;
                return null;
            }
            ExportPackageDescription[] exportPackageDescriptionArray = frameworkAdaptor.getState().getExportedPackages();
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                ExportedPackageImpl exportedPackageImpl = this.createExportedPackage(exportPackageDescriptionArray[n]);
                if (exportedPackageImpl != null && (bundle == null || exportedPackageImpl.getBundle() == bundle)) {
                    arrayList.add(exportedPackageImpl);
                }
                ++n;
            }
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    private ExportedPackageImpl createExportedPackage(ExportPackageDescription exportPackageDescription) {
        BundleDescription bundleDescription = exportPackageDescription.getExporter();
        if (bundleDescription == null || bundleDescription.getHost() != null) {
            return null;
        }
        BundleLoaderProxy bundleLoaderProxy = (BundleLoaderProxy)bundleDescription.getUserObject();
        if (bundleLoaderProxy == null) {
            BundleHost bundleHost = (BundleHost)this.framework.getBundle(bundleDescription.getBundleId());
            if (bundleHost == null) {
                return null;
            }
            bundleLoaderProxy = bundleHost.getLoaderProxy();
        }
        return new ExportedPackageImpl(exportPackageDescription, bundleLoaderProxy);
    }

    public ExportedPackage getExportedPackage(String string) {
        ExportedPackage[] exportedPackageArray = this.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ExportedPackage exportedPackage = null;
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                if (exportedPackage == null) {
                    exportedPackage = exportedPackageArray[n];
                } else {
                    Version version = Version.parseVersion(exportedPackage.getSpecificationVersion());
                    Version version2 = Version.parseVersion(exportedPackageArray[n].getSpecificationVersion());
                    if (version2.compareTo(version) >= 0) {
                        exportedPackage = exportedPackageArray[n];
                    }
                }
            }
            ++n;
        }
        return exportedPackage;
    }

    public ExportedPackage[] getExportedPackages(String string) {
        ExportedPackage[] exportedPackageArray = this.getExportedPackages((Bundle)null);
        if (exportedPackageArray == null) {
            return null;
        }
        ArrayList<ExportedPackage> arrayList = new ArrayList<ExportedPackage>(1);
        int n = 0;
        while (n < exportedPackageArray.length) {
            if (string.equals(exportedPackageArray[n].getName())) {
                arrayList.add(exportedPackageArray[n]);
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new ExportedPackage[arrayList.size()]);
    }

    public void refreshPackages(Bundle[] bundleArray) {
        this.refreshPackages(bundleArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshPackages(Bundle[] bundleArray, boolean bl) {
        AbstractBundle[] abstractBundleArray;
        Object object;
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        if (bundleArray != null) {
            object = bundleArray;
            synchronized (bundleArray) {
                abstractBundleArray = new AbstractBundle[bundleArray.length];
                System.arraycopy(bundleArray, 0, abstractBundleArray, 0, bundleArray.length);
                // ** MonitorExit[var4_3] (shouldn't be in output)
            }
        } else {
            abstractBundleArray = null;
        }
        {
            if (bl) {
                this.doResolveBundles(abstractBundleArray, true);
                if (this.framework.isForcedRestart()) {
                    this.framework.systemBundle.stop();
                }
            } else {
                object = this.framework.secureAction.createThread(new Runnable(){

                    public void run() {
                        PackageAdminImpl.this.doResolveBundles(abstractBundleArray, true);
                        if (PackageAdminImpl.this.framework.isForcedRestart()) {
                            PackageAdminImpl.this.framework.shutdown(256);
                        }
                    }
                }, "Refresh Packages", this.framework.getContextFinder());
                ((Thread)object).start();
            }
            return;
        }
    }

    public boolean resolveBundles(Bundle[] bundleArray) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "resolve");
        this.doResolveBundles(null, false);
        if (bundleArray == null) {
            bundleArray = this.framework.getAllBundles();
        }
        int n = 0;
        while (n < bundleArray.length) {
            if (!((AbstractBundle)bundleArray[n]).isResolved()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void doResolveBundles(AbstractBundle[] var1_1, boolean var2_2) {
        try {
            try {
                if (Profile.STARTUP) {
                    Profile.logEnter("resolve bundles");
                }
                this.framework.publishBundleEvent(-2147483647, this.framework.systemBundle);
                var3_3 = this.framework.adaptor.getState();
                var4_5 = null;
                var5_6 = this.framework.bundles;
                synchronized (this.framework.bundles) {
                    block20: {
                        v0 = var6_7 = var1_1 == null ? 0 : var1_1.length;
                        if (var2_2) break block20;
                        var4_5 = new BundleDescription[]{};
                        ** GOTO lbl34
                    }
                    if (var6_7 <= 0) ** GOTO lbl34
                    this.populateLoaders(this.framework.bundles.getBundles());
                    var7_8 = new ArrayList<BundleDescription>(var6_7);
                    var8_9 = null;
                    var9_10 = 0;
lbl21:
                    // 2 sources

                    while (true) {
                        block21: {
                            if (var9_10 < var6_7) break block21;
                        }
                        var10_11 = var1_1[var9_10].getBundleDescription();
                        if (var10_11 != null && var10_11.getBundleId() != 0L && !var7_8.contains(var10_11)) {
                            var7_8.add(var10_11);
                        }
                        if ((var11_12 = this.framework.bundles.getBundles(var1_1[var9_10].getSymbolicName())) == null || var11_12.length <= 1) break block17;
                        if (var8_9 == null) {
                            var8_9 = var3_3.getChanges().getChanges(1, false);
                        }
                        var12_13 = 0;
                        if (true) ** GOTO lbl77
                        var4_5 = var7_8.size() == 0 ? null : var7_8.toArray(new BundleDescription[var7_8.size()]);
lbl34:
                        // 3 sources

                        // ** MonitorExit[var5_6] (shouldn't be in output)
                        break;
                    }
                    var5_6 = var3_3.resolve(var4_5).getChanges();
                    this.processDelta(var5_6, var2_2, var3_3);
                }
            }
            catch (Throwable var3_4) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("PackageAdminImpl.doResolveBundles: Error occured :");
                    Debug.printStackTrace(var3_4);
                }
                if (var3_4 instanceof RuntimeException) {
                    throw (RuntimeException)var3_4;
                }
                if (!(var3_4 instanceof Error)) ** break block18
                throw (Error)var3_4;
            }
            {
                var14_17 = null;
                if (!Profile.STARTUP) break block19;
            }
        }
        catch (Throwable var15_15) {
            var14_16 = null;
            if (Profile.STARTUP) {
                Profile.logExit("resolve bundles");
            }
            if (this.framework.isActive() == false) throw var15_15;
            this.framework.publishBundleEvent(-2147483648, this.framework.systemBundle);
            if (var2_2 == false) throw var15_15;
            this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
            throw var15_15;
        }
        {
            block17: {
                block19: {
                    Profile.logExit("resolve bundles");
                }
                if (this.framework.isActive() == false) return;
                this.framework.publishBundleEvent(-2147483648, this.framework.systemBundle);
                if (var2_2 == false) return;
                this.framework.publishFrameworkEvent(4, this.framework.systemBundle, null);
                return;
                do {
                    if (var11_12[var12_13] != var1_1[var9_10] && (var13_14 = var11_12[var12_13].getBundleDescription()) != null && var13_14.getBundleId() != 0L && !var7_8.contains(var13_14) && this.checkExtensionBundle(var13_14, var8_9)) {
                        var7_8.add(var13_14);
                    }
                    ++var12_13;
lbl77:
                    // 2 sources

                } while (var12_13 < var11_12.length);
            }
            ++var9_10;
            ** continue;
        }
    }

    private void populateLoaders(List list) {
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            BundleLoader bundleLoader;
            AbstractBundle abstractBundle = (AbstractBundle)listIterator.next();
            if (!(abstractBundle instanceof BundleHost) || !abstractBundle.isResolved() || (bundleLoader = ((BundleHost)abstractBundle).getBundleLoader()) == null) continue;
            bundleLoader.getImportedSources(null);
        }
    }

    private boolean checkExtensionBundle(BundleDescription bundleDescription, BundleDelta[] bundleDeltaArray) {
        if (bundleDescription.getHost() == null || !bundleDescription.isResolved()) {
            return true;
        }
        return ((BundleDescription)bundleDescription.getHost().getSupplier()).getBundleId() != 0L || bundleDeltaArray.length > 0;
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray, boolean bl, int[] nArray) {
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("PackageAdminImpl: restart the bundles");
        }
        if (abstractBundleArray == null) {
            return;
        }
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (abstractBundleArray[n].isResolved() && (bl || (abstractBundleArray[n].getBundleData().getStatus() & 2) != 0 && !abstractBundleArray[n].testStateChanging(Thread.currentThread()))) {
                if (nArray[n] == 32) {
                    try {
                        abstractBundleArray[n].start(1);
                    }
                    catch (BundleException bundleException) {
                        this.framework.publishFrameworkEvent(2, abstractBundleArray[n], bundleException);
                    }
                } else {
                    this.framework.resumeBundle(abstractBundleArray[n]);
                }
            }
            ++n;
        }
    }

    private void suspendBundle(AbstractBundle abstractBundle) {
        if (abstractBundle.isActive() && !abstractBundle.isFragment()) {
            this.framework.suspendBundle(abstractBundle, true);
        } else if (abstractBundle.getStateChanging() != Thread.currentThread()) {
            try {
                abstractBundle.beginStateChange();
            }
            catch (BundleException bundleException) {
                this.framework.publishFrameworkEvent(2, abstractBundle, bundleException);
            }
        }
        if (Debug.DEBUG_PACKAGEADMIN && abstractBundle.stateChanging == null) {
            Debug.println("Bundle state change lock is clear! " + abstractBundle);
            Debug.printStackTrace(new Exception("Stack trace"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyRemovalPending(BundleDelta bundleDelta) throws BundleException {
        if ((bundleDelta.getType() & 0x100) != 0) {
            BundleDescription bundleDescription = bundleDelta.getBundle();
            if (bundleDescription.getDependents() != null && bundleDescription.getDependents().length > 0) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("Bundles still depend on removed bundle! " + bundleDescription);
                    Debug.printStackTrace(new Exception("Stack trace"));
                }
                throw new BundleException(Msg.OSGI_INTERNAL_ERROR);
            }
            Object object = this.removalPendings;
            synchronized (object) {
                List list = (List)this.removalPendings.remove(new Long(bundleDescription.getBundleId()));
                if (list != null) {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        try {
                            ((BundleData)iterator.next()).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            object = (BundleLoaderProxy)bundleDescription.getUserObject();
            if (object != null) {
                BundleLoader.closeBundleLoader((BundleLoaderProxy)object);
                try {
                    ((BundleLoaderProxy)object).getBundleHost().getBundleData().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private AbstractBundle setResolved(BundleDescription bundleDescription) {
        if (!bundleDescription.isResolved()) {
            return null;
        }
        AbstractBundle abstractBundle = this.framework.getBundle(bundleDescription.getBundleId());
        if (abstractBundle == null) {
            BundleException bundleException = new BundleException(NLS.bind(Msg.BUNDLE_NOT_IN_FRAMEWORK, bundleDescription));
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
            return null;
        }
        boolean bl = true;
        if (abstractBundle.isFragment()) {
            BundleDescription[] bundleDescriptionArray = bundleDescription.getHost().getHosts();
            int n = 0;
            while (n < bundleDescriptionArray.length) {
                BundleHost bundleHost = (BundleHost)this.framework.getBundle(bundleDescriptionArray[n].getBundleId());
                bl = ((BundleFragment)abstractBundle).addHost(bundleHost);
                ++n;
            }
        }
        if (bl) {
            abstractBundle.resolve();
        }
        return abstractBundle;
    }

    private void applyDeltas(BundleDelta[] bundleDeltaArray) throws BundleException {
        Arrays.sort(bundleDeltaArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return (int)(((BundleDelta)object).getBundle().getBundleId() - ((BundleDelta)object2).getBundle().getBundleId());
            }
        });
        int n = 0;
        while (n < bundleDeltaArray.length) {
            NativeCodeSpecification nativeCodeSpecification;
            AbstractBundle abstractBundle;
            int n2 = bundleDeltaArray[n].getType();
            if ((n2 & 0x180) != 0) {
                this.applyRemovalPending(bundleDeltaArray[n]);
            }
            if ((n2 & 8) != 0 && (abstractBundle = this.setResolved(bundleDeltaArray[n].getBundle())) != null && abstractBundle.isResolved() && (nativeCodeSpecification = bundleDeltaArray[n].getBundle().getNativeCodeSpecification()) != null && nativeCodeSpecification.getSupplier() != null) {
                try {
                    BundleData bundleData = abstractBundle.getBundleData();
                    bundleData.installNativeCode(((NativeCodeDescription)nativeCodeSpecification.getSupplier()).getNativePaths());
                }
                catch (BundleException bundleException) {
                    this.framework.publishFrameworkEvent(2, abstractBundle, bundleException);
                }
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractBundle[] processDelta(BundleDelta[] var1_1, boolean var2_2, State var3_3) {
        var4_4 = new ArrayList<Object>(var1_1.length);
        var5_5 = 0;
        while (true) {
            if (var5_5 >= var1_1.length) {
                var5_6 = var4_4.toArray(new AbstractBundle[var4_4.size()]);
                Util.sort(var5_6);
                this.framework.startLevelManager.sortByDependency((AbstractBundle[])var5_6);
                var6_7 = new boolean[var5_6.length];
                var7_8 = new int[var5_6.length];
                ** try [egrp 0[TRYBLOCK] [8 : 155->675)] { 
lbl11:
                // 1 sources

                break;
            }
            if (!((var1_1[var5_5].getType() & 256) != 0 && (var1_1[var5_5].getType() & 2) == 0 || (var6_7 = this.framework.getBundle(var1_1[var5_5].getBundle().getBundleId())) == null || var4_4.contains(var6_7))) {
                var4_4.add(var6_7);
            }
            ++var5_5;
        }
        {
            block55: {
                block53: {
                    block54: {
                        block50: {
                            block51: {
                                try {
                                    if (Debug.DEBUG_PACKAGEADMIN) {
                                        Debug.println("refreshPackages: Suspend each bundle and acquire its state change lock");
                                    }
                                    var8_9 = false;
                                    var9_13 = var5_6.length - 1;
                                    while (true) {
                                        if (var9_13 < 0) {
                                            if (!var8_9) break;
                                            FrameworkProperties.setProperty("osgi.forcedRestart", "true");
                                            this.framework.setForcedRestart(true);
                                            var11_17 = null;
                                            if (!Debug.DEBUG_PACKAGEADMIN) break block50;
                                            break block51;
                                        }
                                        var6_7[var9_13] = var5_6[var9_13].isResolved();
                                        if (var5_6[var9_13] == this.framework.systemBundle) {
                                            var8_9 = true;
                                        } else if ((var5_6[var9_13].bundledata.getType() & 2) != 0 && var6_7[var9_13] != false) {
                                            var8_9 = true;
                                        } else if ((var5_6[var9_13].bundledata.getType() & 4) != 0) {
                                            var8_9 = true;
                                        } else if ((var5_6[var9_13].bundledata.getType() & 16) != 0 && var6_7[var9_13] != false) {
                                            var8_9 = true;
                                        }
                                        --var9_13;
                                    }
                                    if (var2_2) {
                                        var9_13 = var5_6.length - 1;
                                        while (var9_13 >= 0) {
                                            var7_8[var9_13] = var5_6[var9_13].getState();
                                            this.suspendBundle((AbstractBundle)var5_6[var9_13]);
                                            --var9_13;
                                        }
                                    }
                                    if (Debug.DEBUG_PACKAGEADMIN) {
                                        Debug.println("refreshPackages: refresh the bundles");
                                    }
                                    var9_14 = this.framework.bundles;
                                    synchronized (var9_14) {
                                        var10_26 = var5_6.length - 1;
                                        while (true) {
                                            if (var10_26 < 0) {
                                                break;
                                            }
                                            var5_6[var10_26].refresh();
                                            --var10_26;
                                        }
                                    }
                                    var9_15 = var5_6.length - 1;
                                    while (true) {
                                        block56: {
                                            if (var9_15 >= 0) break block56;
                                            if (Debug.DEBUG_PACKAGEADMIN) {
                                                Debug.println("refreshPackages: applying deltas to bundles");
                                            }
                                            var9_16 = this.framework.bundles;
                                            synchronized (var9_16) {
                                                this.applyDeltas(var1_1);
                                                ** GOTO lbl-1000
                                            }
                                        }
                                        if (var6_7[var9_15] != false) {
                                            this.framework.publishBundleEvent(64, (Bundle)var5_6[var9_15]);
                                        }
                                        --var9_15;
                                    }
                                }
                                catch (Throwable var12_27) {
                                    var11_18 = null;
                                    if (Debug.DEBUG_PACKAGEADMIN) {
                                        Debug.println("refreshPackages: release the state change locks");
                                    }
                                    if (!var2_2) break block53;
                                    var13_21 = 0;
                                    break block54;
                                }
                            }
                            Debug.println("refreshPackages: release the state change locks");
                        }
                        if (var2_2) {
                            var13_20 = 0;
                            while (var13_20 < var5_6.length) {
                                var14_23 = var5_6[var13_20];
                                var14_23.completeStateChange();
                                ++var13_20;
                            }
                        }
                        return null;
                    }
                    while (var13_21 < var5_6.length) {
                        var14_24 = var5_6[var13_21];
                        var14_24.completeStateChange();
                        ++var13_21;
                    }
                }
                throw var12_27;
lbl-1000:
                // 1 sources

                {
                    var11_19 = null;
                    if (!Debug.DEBUG_PACKAGEADMIN) break block55;
                }
                Debug.println("refreshPackages: release the state change locks");
            }
            if (var2_2) {
                var13_22 = 0;
                while (var13_22 < var5_6.length) {
                    var14_25 = var5_6[var13_22];
                    var14_25.completeStateChange();
                    ++var13_22;
                }
            }
            if (var2_2) {
                if (Debug.DEBUG_PACKAGEADMIN) {
                    Debug.println("refreshPackages: clean up adaptor storage");
                }
                try {
                    this.framework.adaptor.compactStorage();
                }
                catch (IOException var8_10) {
                    if (Debug.DEBUG_PACKAGEADMIN) {
                        Debug.println("refreshPackages exception: " + var8_10.getMessage());
                        Debug.printStackTrace(var8_10);
                    }
                    this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var8_10));
                }
            }
        }
lbl135:
        // 1 sources

        catch (BundleException var8_11) {
            if (Debug.DEBUG_PACKAGEADMIN) {
                Debug.println("refreshPackages exception: " + var8_11.getMessage());
                Debug.printStackTrace(var8_11.getNestedException() == null ? var8_11 : var8_11.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, new BundleException(Msg.BUNDLE_REFRESH_FAILURE, var8_11));
        }
        if (Debug.DEBUG_PACKAGEADMIN) {
            Debug.println("refreshPackages: send out RESOLVED events");
        }
        var8_12 = 0;
        while (true) {
            if (var8_12 >= var5_6.length) {
                if (this.framework.isActive()) break;
                return var5_6;
            }
            if (var5_6[var8_12].isResolved()) {
                this.framework.publishBundleEvent(32, (Bundle)var5_6[var8_12]);
            }
            ++var8_12;
        }
        if (var2_2) {
            this.framework.securityAdmin.clearCaches();
            if (var1_1.length > 0) {
                var3_3.setTimeStamp(var3_3.getTimeStamp() == 0x7FFFFFFFFFFFFFFFL ? 0L : var3_3.getTimeStamp() + 1L);
            }
        }
        this.resumeBundles((AbstractBundle[])var5_6, var2_2, var7_8);
        return var5_6;
    }

    public RequiredBundle[] getRequiredBundles(String string) {
        AbstractBundle[] abstractBundleArray = string == null ? this.framework.getAllBundles() : this.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null || abstractBundleArray.length == 0) {
            return null;
        }
        ArrayList<BundleLoaderProxy> arrayList = new ArrayList<BundleLoaderProxy>(abstractBundleArray.length);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (!abstractBundleArray[n].isFragment() && abstractBundleArray[n].isResolved() && abstractBundleArray[n].getSymbolicName() != null && abstractBundleArray[n].hasPermission(new BundlePermission(abstractBundleArray[n].getSymbolicName(), "provide"))) {
                arrayList.add(((BundleHost)abstractBundleArray[n]).getLoaderProxy());
            }
            ++n;
        }
        return arrayList.size() == 0 ? null : arrayList.toArray(new RequiredBundle[arrayList.size()]);
    }

    public Bundle[] getBundles(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        AbstractBundle[] abstractBundleArray = this.framework.getBundleBySymbolicName(string);
        if (abstractBundleArray == null) {
            return null;
        }
        if (string2 == null) {
            Bundle[] bundleArray = new AbstractBundle[abstractBundleArray.length];
            System.arraycopy(abstractBundleArray, 0, bundleArray, 0, bundleArray.length);
            return bundleArray;
        }
        ArrayList<AbstractBundle> arrayList = new ArrayList<AbstractBundle>(abstractBundleArray.length);
        VersionRange versionRange = new VersionRange(string2);
        int n = 0;
        while (n < abstractBundleArray.length) {
            if (versionRange.isIncluded(abstractBundleArray[n].getVersion())) {
                arrayList.add(abstractBundleArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new AbstractBundle[arrayList.size()]);
    }

    public Bundle[] getFragments(Bundle bundle) {
        return ((AbstractBundle)bundle).getFragments();
    }

    public Bundle[] getHosts(Bundle bundle) {
        BundleHost[] bundleHostArray = ((AbstractBundle)bundle).getHosts();
        if (bundleHostArray == null) {
            return null;
        }
        Bundle[] bundleArray = new Bundle[bundleHostArray.length];
        int n = 0;
        while (n < bundleHostArray.length) {
            bundleArray[n] = bundleHostArray[n];
            ++n;
        }
        return bundleArray;
    }

    Bundle getBundlePriv(Class clazz) {
        ClassLoaderDelegate classLoaderDelegate;
        ClassLoader classLoader = clazz.getClassLoader();
        if (classLoader instanceof BundleClassLoader && (classLoaderDelegate = ((BundleClassLoader)((Object)classLoader)).getDelegate()) instanceof BundleLoader) {
            return ((BundleLoader)classLoaderDelegate).getBundle();
        }
        if (classLoader == this.getClass().getClassLoader()) {
            return this.framework.systemBundle;
        }
        return null;
    }

    public Bundle getBundle(Class clazz) {
        if (System.getSecurityManager() == null) {
            return this.getBundlePriv(clazz);
        }
        return (Bundle)AccessController.doPrivileged(new GetBundleAction(this, clazz));
    }

    public int getBundleType(Bundle bundle) {
        return ((AbstractBundle)bundle).isFragment() ? 1 : 0;
    }

    protected void cleanup() {
    }

    protected void setResolvedBundles(InternalSystemBundle internalSystemBundle) {
        this.checkSystemBundle(internalSystemBundle);
        State state = this.framework.adaptor.getState();
        BundleDescription[] bundleDescriptionArray = state.getBundles();
        int n = 0;
        while (n < bundleDescriptionArray.length) {
            if (bundleDescriptionArray[n].getBundleId() == 0L) {
                this.setFrameworkVersion(bundleDescriptionArray[n]);
            } else {
                this.setResolved(bundleDescriptionArray[n]);
            }
            ++n;
        }
    }

    private void checkSystemBundle(InternalSystemBundle internalSystemBundle) {
        try {
            State state = this.framework.adaptor.getState();
            BundleDescription bundleDescription = state.getBundle(0L);
            boolean bl = false;
            if (bundleDescription == null || !internalSystemBundle.getBundleData().getVersion().equals(bundleDescription.getVersion())) {
                bl = true;
            }
            if (!bl && FrameworkProperties.getProperty("osgi.dev") == null) {
                return;
            }
            BundleDescription bundleDescription2 = state.getFactory().createBundleDescription(state, internalSystemBundle.getHeaders(""), internalSystemBundle.getLocation(), 0L);
            if (bundleDescription2 == null) {
                throw new BundleException(Msg.OSGI_SYSTEMBUNDLE_DESCRIPTION_ERROR);
            }
            if (!bl) {
                ExportPackageDescription[] exportPackageDescriptionArray;
                ExportPackageDescription[] exportPackageDescriptionArray2 = bundleDescription.getExportPackages();
                if (exportPackageDescriptionArray2.length >= (exportPackageDescriptionArray = bundleDescription2.getExportPackages()).length) {
                    int n = 0;
                    while (n < exportPackageDescriptionArray.length && !bl) {
                        if (exportPackageDescriptionArray2[n].getName().equals(exportPackageDescriptionArray[n].getName())) {
                            Version version = exportPackageDescriptionArray2[n].getVersion();
                            Version version2 = exportPackageDescriptionArray[n].getVersion();
                            bl = version == null ? version2 != null : !((Object)version).equals(version2);
                        } else {
                            bl = true;
                        }
                        ++n;
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                state.removeBundle(0L);
                state.addBundle(bundleDescription2);
                state.resolve(false);
            }
        }
        catch (BundleException bundleException) {
            bundleException.printStackTrace();
            throw new RuntimeException(NLS.bind(Msg.OSGI_SYSTEMBUNDLE_CREATE_EXCEPTION, bundleException.getMessage()));
        }
    }

    private void setFrameworkVersion(BundleDescription bundleDescription) {
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getExportPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (exportPackageDescriptionArray[n].getName().equals("org.osgi.framework")) {
                FrameworkProperties.setProperty("org.osgi.framework.version", exportPackageDescriptionArray[n].getVersion().toString());
                break;
            }
            ++n;
        }
        FrameworkProperties.setProperty("osgi.framework.version", bundleDescription.getVersion().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRemovalPending(BundleData bundleData) {
        Map map = this.removalPendings;
        synchronized (map) {
            Long l = new Long(bundleData.getBundleID());
            ArrayList<BundleData> arrayList = (ArrayList<BundleData>)this.removalPendings.get(l);
            if (arrayList == null) {
                arrayList = new ArrayList<BundleData>(1);
                this.removalPendings.put(l, arrayList);
            }
            arrayList.add(bundleData);
        }
    }

    static class GetBundleAction
    implements PrivilegedAction {
        private Class clazz;
        private PackageAdminImpl impl;

        public GetBundleAction(PackageAdminImpl packageAdminImpl, Class clazz) {
            this.impl = packageAdminImpl;
            this.clazz = clazz;
        }

        public Object run() {
            return this.impl.getBundlePriv(this.clazz);
        }
    }
}

