/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleRepository;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.StartLevelEvent;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelManager
implements EventDispatcher,
EventListener,
StartLevel {
    protected static EventManager eventManager;
    protected static Map startLevelListeners;
    protected int initialBundleStartLevel = 1;
    private int activeSL = 0;
    private final Object lock = new Object();
    private final Framework framework;
    private volatile boolean settingStartLevel = false;

    protected StartLevelManager(Framework framework) {
        this.framework = framework;
    }

    protected void initialize() {
        this.initialBundleStartLevel = this.framework.adaptor.getInitialBundleStartLevel();
        eventManager = new EventManager("Start Level Event Dispatcher");
        startLevelListeners = new CopyOnWriteIdentityMap();
        startLevelListeners.put(this, this);
    }

    protected void cleanup() {
        eventManager.close();
        eventManager = null;
        startLevelListeners.clear();
        startLevelListeners = null;
    }

    public int getInitialBundleStartLevel() {
        return this.initialBundleStartLevel;
    }

    public void setInitialBundleStartLevel(int n) {
        this.framework.checkAdminPermission(this.framework.systemBundle, "startlevel");
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.initialBundleStartLevel = n;
        this.framework.adaptor.setInitialBundleStartLevel(n);
    }

    public int getStartLevel() {
        return this.activeSL;
    }

    public void setStartLevel(int n, Bundle bundle) {
        if (n <= 0) {
            throw new IllegalArgumentException(NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + n));
        }
        this.framework.checkAdminPermission(this.framework.systemBundle, "startlevel");
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("StartLevelImpl: setStartLevel: " + n + "; callerBundle = " + bundle.getBundleId());
        }
        this.issueEvent(new StartLevelEvent(1, n, (AbstractBundle)bundle));
    }

    public void setStartLevel(int n) {
        this.setStartLevel(n, this.framework.systemBundle);
    }

    protected void shutdown() {
        this.doSetStartLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void doSetStartLevel(int var1_1) {
        var2_2 = this.lock;
        synchronized (var2_2) {
            this.settingStartLevel = true;
            var3_3 = Thread.currentThread().getContextClassLoader();
            var4_4 = this.framework.getContextFinder();
            if (var4_4 == var3_3) {
                var4_4 = null;
            } else {
                Thread.currentThread().setContextClassLoader(var4_4);
            }
            try {
                block19: {
                    block18: {
                        var5_5 = this.activeSL;
                        if (var1_1 <= var5_5) break block18;
                        v0 = var6_6 = var5_5 == 0;
                        if (var6_6) {
                            this.framework.systemBundle.state = 32;
                        }
                        var7_8 = var5_5;
                        if (true) ** GOTO lbl29
                    }
                    var6_7 = this.getInstalledBundles(this.framework.bundles, true);
                    var7_9 = var5_5;
                    if (true) ** GOTO lbl40
                    do {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("sync - incrementing Startlevel from " + var5_5);
                        }
                        ++var5_5;
                        this.incFWSL(var7_8 + 1, this.getInstalledBundles(this.framework.bundles, false));
                        ++var7_8;
lbl29:
                        // 2 sources

                    } while (var7_8 < var1_1);
                    if (var6_6) {
                        this.framework.publishBundleEvent(2, this.framework.systemBundle);
                        this.framework.publishFrameworkEvent(1, this.framework.systemBundle, null);
                    }
                    break block19;
                    do {
                        if (Debug.DEBUG_STARTLEVEL) {
                            Debug.println("sync - decrementing Startlevel from " + var5_5);
                        }
                        --var5_5;
                        this.decFWSL(var7_9 - 1, var6_7);
                        --var7_9;
lbl40:
                        // 2 sources

                    } while (var7_9 > var1_1);
                    if (var1_1 == 0) {
                        this.suspendAllBundles(this.framework.bundles);
                        this.unloadAllBundles(this.framework.bundles);
                    }
                }
                this.framework.publishFrameworkEvent(8, this.framework.systemBundle, null);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("StartLevelImpl: doSetStartLevel: STARTLEVEL_CHANGED event published");
                }
                var8_12 = null;
                if (var4_4 != null) {
                    Thread.currentThread().setContextClassLoader(var3_3);
                }
                this.settingStartLevel = false;
                return;
            }
            catch (Throwable var9_10) {
                var8_11 = null;
                if (var4_4 != null) {
                    Thread.currentThread().setContextClassLoader(var3_3);
                }
                this.settingStartLevel = false;
                throw var9_10;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveActiveStartLevel(int n) {
        Object object = this.lock;
        synchronized (object) {
            this.activeSL = n;
        }
    }

    public boolean isBundlePersistentlyStarted(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation()));
        }
        return (((AbstractBundle)bundle).getBundleData().getStatus() & 1) != 0;
    }

    public boolean isBundleActivationPolicyUsed(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation()));
        }
        return (((AbstractBundle)bundle).getBundleData().getStatus() & 4) != 0;
    }

    public int getBundleStartLevel(Bundle bundle) {
        if (bundle.getState() == 1) {
            throw new IllegalArgumentException(NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation()));
        }
        return ((AbstractBundle)bundle).getStartLevel();
    }

    public void setBundleStartLevel(Bundle bundle, int n) {
        block11: {
            String string = null;
            if (bundle.getBundleId() == 0L) {
                string = Msg.STARTLEVEL_CANT_CHANGE_SYSTEMBUNDLE_STARTLEVEL;
            } else if (bundle.getState() == 1) {
                string = NLS.bind(Msg.BUNDLE_UNINSTALLED_EXCEPTION, ((AbstractBundle)bundle).getBundleData().getLocation());
            } else if (n <= 0) {
                string = NLS.bind(Msg.STARTLEVEL_EXCEPTION_INVALID_REQUESTED_STARTLEVEL, "" + n);
            }
            if (string != null) {
                throw new IllegalArgumentException(string);
            }
            this.framework.checkAdminPermission(bundle, "execute");
            try {
                if (n == ((AbstractBundle)bundle).getStartLevel()) break block11;
                final AbstractBundle abstractBundle = (AbstractBundle)bundle;
                abstractBundle.getBundleData().setStartLevel(n);
                try {
                    AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            abstractBundle.getBundleData().save();
                            return null;
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    if (privilegedActionException.getException() instanceof IOException) {
                        throw (IOException)privilegedActionException.getException();
                    }
                    throw (RuntimeException)privilegedActionException.getException();
                }
                this.issueEvent(new StartLevelEvent(0, n, (AbstractBundle)bundle));
            }
            catch (IOException iOException) {
                this.framework.publishFrameworkEvent(2, bundle, iOException);
            }
        }
    }

    private void issueEvent(StartLevelEvent startLevelEvent) {
        ListenerQueue listenerQueue = new ListenerQueue(eventManager);
        listenerQueue.queueListeners(startLevelListeners.entrySet(), (EventDispatcher)this);
        listenerQueue.dispatchEventAsynchronous(startLevelEvent.getType(), startLevelEvent);
    }

    public void dispatchEvent(Object object, Object object2, int n, Object object3) {
        try {
            switch (n) {
                case 0: {
                    this.setBundleSL((StartLevelEvent)object3);
                    break;
                }
                case 1: {
                    this.doSetStartLevel(((StartLevelEvent)object3).getNewSL());
                }
            }
        }
        catch (Throwable throwable) {
            this.framework.adaptor.handleRuntimeError(throwable);
        }
    }

    protected void incFWSL(int n, AbstractBundle[] abstractBundleArray) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: incFWSL: saving activeSL of " + n);
        }
        this.saveActiveStartLevel(n);
        this.resumeBundles(abstractBundleArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AbstractBundle[] getInstalledBundles(BundleRepository bundleRepository, boolean bl) {
        Object[] objectArray;
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List list = bundleRepository.getBundles();
            objectArray = new AbstractBundle[list.size()];
            list.toArray(objectArray);
            Util.sort(objectArray, 0, objectArray.length);
            if (bl) {
                this.sortByDependency((AbstractBundle[])objectArray);
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sortByDependency(AbstractBundle[] abstractBundleArray) {
        BundleRepository bundleRepository = this.framework.bundles;
        synchronized (bundleRepository) {
            if (abstractBundleArray.length <= 1) {
                return;
            }
            int n = abstractBundleArray[0].getStartLevel();
            int n2 = 0;
            boolean bl = false;
            int n3 = 0;
            while (n3 < abstractBundleArray.length) {
                if (n != abstractBundleArray[n3].getStartLevel()) {
                    if (bl) {
                        this.sortByDependencies(abstractBundleArray, n2, n3);
                    }
                    n = abstractBundleArray[n3].getStartLevel();
                    n2 = n3;
                    bl = false;
                }
                bl |= (abstractBundleArray[n3].getBundleData().getStatus() & 2) != 0;
                ++n3;
            }
            if (bl) {
                this.sortByDependencies(abstractBundleArray, n2, abstractBundleArray.length);
            }
        }
    }

    private void sortByDependencies(AbstractBundle[] abstractBundleArray, int n, int n2) {
        if (n2 - n <= 1) {
            return;
        }
        ArrayList<BundleDescription> arrayList = new ArrayList<BundleDescription>(n2 - n);
        ArrayList<AbstractBundle> arrayList2 = new ArrayList<AbstractBundle>(0);
        int n3 = n;
        while (n3 < n2) {
            BundleDescription bundleDescription = abstractBundleArray[n3].getBundleDescription();
            if (bundleDescription != null) {
                arrayList.add(bundleDescription);
            } else {
                arrayList2.add(abstractBundleArray[n3]);
            }
            ++n3;
        }
        if (arrayList.size() <= 1) {
            return;
        }
        BundleDescription[] bundleDescriptionArray = arrayList.toArray(new BundleDescription[arrayList.size()]);
        this.framework.adaptor.getPlatformAdmin().getStateHelper().sortBundles(bundleDescriptionArray);
        int n4 = n;
        while (n4 < bundleDescriptionArray.length + n) {
            abstractBundleArray[n4] = this.framework.bundles.getBundle(bundleDescriptionArray[n4 - n].getBundleId());
            ++n4;
        }
        if (arrayList2.size() > 0) {
            Iterator iterator = arrayList2.iterator();
            int n5 = n + bundleDescriptionArray.length;
            while (n5 < n2 && iterator.hasNext()) {
                abstractBundleArray[n5] = (AbstractBundle)iterator.next();
                ++n5;
            }
        }
    }

    private void resumeBundles(AbstractBundle[] abstractBundleArray) {
        int n = this.getStartLevel();
        int n2 = 0;
        while (n2 < abstractBundleArray.length && !this.framework.isForcedRestart()) {
            int n3 = abstractBundleArray[n2].getStartLevel();
            if (n3 >= n) {
                if (n3 != n) break;
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Active sl = " + n + "; Bundle " + abstractBundleArray[n2].getBundleId() + " sl = " + n3);
                }
                this.framework.resumeBundle(abstractBundleArray[n2]);
            }
            ++n2;
        }
    }

    protected void decFWSL(int n, AbstractBundle[] abstractBundleArray) {
        if (Debug.DEBUG_STARTLEVEL) {
            Debug.println("SLL: decFWSL: saving activeSL of " + n);
        }
        this.saveActiveStartLevel(n);
        if (n == 0) {
            return;
        }
        int n2 = abstractBundleArray.length - 1;
        while (n2 >= 0) {
            int n3 = abstractBundleArray[n2].getStartLevel();
            if (n3 <= n + 1) {
                if (n3 <= n) break;
                if (abstractBundleArray[n2].isActive()) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("SLL: stopping bundle " + abstractBundleArray[n2].getBundleId());
                    }
                    this.framework.suspendBundle(abstractBundleArray[n2], false);
                }
            }
            --n2;
        }
    }

    private void suspendAllBundles(BundleRepository bundleRepository) {
        boolean bl;
        do {
            bl = false;
            AbstractBundle[] abstractBundleArray = this.getInstalledBundles(bundleRepository, false);
            int n = abstractBundleArray.length - 1;
            while (n >= 0) {
                AbstractBundle abstractBundle = abstractBundleArray[n];
                if (this.framework.suspendBundle(abstractBundle, false)) {
                    if (Debug.DEBUG_STARTLEVEL) {
                        Debug.println("SLL: stopped bundle " + abstractBundle.getBundleId());
                    }
                    bl = true;
                }
                --n;
            }
        } while (bl);
        try {
            this.framework.systemBundle.context.stop();
        }
        catch (BundleException bundleException) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle suspend exception: " + bundleException.getMessage());
                Debug.printStackTrace(bundleException.getNestedException() == null ? bundleException : bundleException.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, bundleException);
        }
        this.framework.systemBundle.state = 4;
        this.framework.publishBundleEvent(4, this.framework.systemBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unloadAllBundles(BundleRepository bundleRepository) {
        BundleRepository bundleRepository2 = bundleRepository;
        synchronized (bundleRepository2) {
            List list = bundleRepository.getBundles();
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                AbstractBundle abstractBundle = (AbstractBundle)list.get(n2);
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: Trying to unload bundle " + abstractBundle);
                }
                abstractBundle.refresh();
                try {
                    abstractBundle.getBundleData().close();
                }
                catch (IOException iOException) {}
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSL(StartLevelEvent startLevelEvent) {
        Object object = this.lock;
        synchronized (object) {
            int n = this.getStartLevel();
            int n2 = startLevelEvent.getNewSL();
            AbstractBundle abstractBundle = startLevelEvent.getBundle();
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.print("SLL: bundle active=" + abstractBundle.isActive());
                Debug.print("; newSL = " + n2);
                Debug.println("; activeSL = " + n);
            }
            if (abstractBundle.isActive() && n2 > n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: stopping bundle " + abstractBundle.getBundleId());
                }
                this.framework.suspendBundle(abstractBundle, false);
            } else if (!abstractBundle.isActive() && n2 <= n) {
                if (Debug.DEBUG_STARTLEVEL) {
                    Debug.println("SLL: starting bundle " + abstractBundle.getBundleId());
                }
                this.framework.resumeBundle(abstractBundle);
            }
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle Startlevel set to " + n2);
            }
        }
    }

    public boolean isSettingStartLevel() {
        return this.settingStartLevel;
    }
}

