/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.composite;

import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.osgi.framework.Bundle;

public class CompositeClassLoader
extends ClassLoader
implements BaseClassLoader {
    private final ClassLoaderDelegate delegate;
    private final ClasspathManager manager;
    private final ClassLoaderDelegate companionDelegate;
    private final ThreadLocal beingLoaded = new ThreadLocal();

    public CompositeClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, ClassLoaderDelegate classLoaderDelegate2, BaseData baseData) {
        super(classLoader);
        this.delegate = classLoaderDelegate;
        this.manager = new ClasspathManager(baseData, new String[0], this);
        this.companionDelegate = classLoaderDelegate2;
    }

    public ClasspathEntry createClassPathEntry(BundleFile bundleFile, ProtectionDomain protectionDomain) {
        return null;
    }

    public Class defineClass(String string, byte[] byArray, ClasspathEntry classpathEntry, BundleEntry bundleEntry) {
        return null;
    }

    public ClasspathManager getClasspathManager() {
        return this.manager;
    }

    public ProtectionDomain getDomain() {
        return null;
    }

    public Object publicDefinePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) {
        return this.definePackage(string, string2, string3, string4, string5, string6, string7, uRL);
    }

    public Class publicFindLoaded(String string) {
        return this.findLoadedClass(string);
    }

    public Object publicGetPackage(String string) {
        return this.getPackage(string);
    }

    public void attachFragment(BundleData bundleData, ProtectionDomain protectionDomain, String[] stringArray) {
    }

    public void close() {
    }

    public Class findLocalClass(String string) throws ClassNotFoundException {
        if (!this.startLoading(string)) {
            throw new ClassNotFoundException(string);
        }
        try {
            Class clazz = this.companionDelegate.findClass(string);
            Object var2_3 = null;
            this.stopLoading(string);
            return clazz;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.stopLoading(string);
            throw throwable;
        }
    }

    public URL findLocalResource(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        try {
            URL uRL = this.companionDelegate.findResource(string);
            Object var2_3 = null;
            this.stopLoading(string);
            return uRL;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.stopLoading(string);
            throw throwable;
        }
    }

    public Enumeration findLocalResources(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        try {
            Enumeration enumeration = this.companionDelegate.findResources(string);
            Object var2_3 = null;
            this.stopLoading(string);
            return enumeration;
        }
        catch (IOException iOException) {
            try {
                Object var2_4 = null;
                this.stopLoading(string);
                return null;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                this.stopLoading(string);
                throw throwable;
            }
        }
    }

    public ClassLoaderDelegate getDelegate() {
        return this.delegate;
    }

    public URL getResource(String string) {
        return this.delegate.findResource(string);
    }

    public void initialize() {
        this.manager.initialize();
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.delegate.findClass(string);
    }

    private boolean startLoading(String string) {
        HashSet<String> hashSet = (HashSet<String>)this.beingLoaded.get();
        if (hashSet != null && hashSet.contains(string)) {
            return false;
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>(3);
            this.beingLoaded.set(hashSet);
        }
        hashSet.add(string);
        return true;
    }

    private void stopLoading(String string) {
        ((Set)this.beingLoaded.get()).remove(string);
    }

    public Bundle getBundle() {
        return this.manager.getBaseData().getBundle();
    }
}

