/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import org.eclipse.osgi.framework.adaptor.BundleClassLoader;
import org.eclipse.osgi.framework.adaptor.BundleData;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegateHook;
import org.eclipse.osgi.framework.adaptor.StatusException;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.util.KeyedHashSet;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.internal.loader.MultiSourcePackage;
import org.eclipse.osgi.internal.loader.NullPackageSource;
import org.eclipse.osgi.internal.loader.PackageSource;
import org.eclipse.osgi.internal.loader.SingleSourcePackage;
import org.eclipse.osgi.internal.loader.SystemBundleLoader;
import org.eclipse.osgi.internal.loader.buddy.PolicyHandler;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

public class BundleLoader
implements ClassLoaderDelegate {
    public static final String DEFAULT_PACKAGE = ".";
    public static final String JAVA_PACKAGE = "java.";
    public static final byte FLAG_IMPORTSINIT = 1;
    public static final byte FLAG_HASDYNAMICIMPORTS = 2;
    public static final byte FLAG_HASDYNAMICEIMPORTALL = 4;
    public static final byte FLAG_CLOSED = 8;
    public static final ClassContext CLASS_CONTEXT = (ClassContext)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return new ClassContext();
        }
    });
    public static final ClassLoader FW_CLASSLOADER;
    private static final int PRE_CLASS = 1;
    private static final int POST_CLASS = 2;
    private static final int PRE_RESOURCE = 3;
    private static final int POST_RESOURCE = 4;
    private static final int PRE_RESOURCES = 5;
    private static final int POST_RESOURCES = 6;
    private static final int PRE_LIBRARY = 7;
    private static final int POST_LIBRARY = 8;
    private static final boolean USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK;
    private static final List waitingList;
    private static Object lockThread;
    private static int lockCount;
    private final BundleLoaderProxy proxy;
    final BundleHost bundle;
    private final PolicyHandler policy;
    private final Collection exportedPackages;
    private final Collection substitutedPackages;
    final BundleLoaderProxy[] requiredBundles;
    final int[] reexportTable;
    private final KeyedHashSet requiredSources;
    private KeyedHashSet importedSources;
    private String[] dynamicImportPackageStems;
    private String[] dynamicImportPackages;
    private byte loaderFlags = 0;
    private BundleClassLoader classloader;
    private ClassLoader parent;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.internal.core.Framework");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FW_CLASSLOADER = BundleLoader.getClassLoader(clazz);
        USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK = "true".equals(BundleLoaderProxy.secureAction.getProperty("osgi.classloader.singleThreadLoads"));
        waitingList = USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK ? new ArrayList(0) : null;
        lockCount = 0;
    }

    public static final String getPackageName(String string) {
        int n;
        if (string != null && (n = string.lastIndexOf(46)) > 0) {
            return string.substring(0, n);
        }
        return DEFAULT_PACKAGE;
    }

    public static final String getResourcePackageName(String string) {
        if (string != null) {
            int n = string.length() > 1 && string.charAt(0) == '/' ? 1 : 0;
            int n2 = string.lastIndexOf(47);
            if (n2 > n) {
                return string.substring(n, n2).replace('/', '.');
            }
        }
        return DEFAULT_PACKAGE;
    }

    protected BundleLoader(BundleHost bundleHost, BundleLoaderProxy bundleLoaderProxy) throws BundleException {
        int n;
        Object[] objectArray;
        ExportPackageDescription[] exportPackageDescriptionArray;
        this.bundle = bundleHost;
        this.proxy = bundleLoaderProxy;
        try {
            bundleHost.getBundleData().open();
        }
        catch (IOException iOException) {
            throw new BundleException(Msg.BUNDLE_READ_EXCEPTION, iOException);
        }
        BundleDescription bundleDescription = bundleLoaderProxy.getBundleDescription();
        BundleDescription[] bundleDescriptionArray = bundleDescription.getResolvedRequires();
        if (bundleDescriptionArray.length > 0) {
            exportPackageDescriptionArray = new HashSet(bundleDescriptionArray.length);
            objectArray = bundleDescription.getRequiredBundles();
            if (objectArray != null && objectArray.length > 0) {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2].isExported()) {
                        exportPackageDescriptionArray.add(objectArray[n2].getName());
                    }
                    ++n2;
                }
            }
            this.requiredBundles = new BundleLoaderProxy[bundleDescriptionArray.length];
            int[] nArray = new int[bundleDescriptionArray.length];
            int n3 = 0;
            n = 0;
            while (n < bundleDescriptionArray.length) {
                this.requiredBundles[n] = this.getLoaderProxy(bundleDescriptionArray[n]);
                if (exportPackageDescriptionArray.contains(bundleDescriptionArray[n].getSymbolicName())) {
                    nArray[n3++] = n;
                }
                ++n;
            }
            if (n3 > 0) {
                this.reexportTable = new int[n3];
                System.arraycopy(nArray, 0, this.reexportTable, 0, n3);
            } else {
                this.reexportTable = null;
            }
            this.requiredSources = new KeyedHashSet(10, false);
        } else {
            this.requiredBundles = null;
            this.reexportTable = null;
            this.requiredSources = null;
        }
        exportPackageDescriptionArray = bundleDescription.getSelectedExports();
        if (exportPackageDescriptionArray != null && exportPackageDescriptionArray.length > 0) {
            this.exportedPackages = Collections.synchronizedCollection(exportPackageDescriptionArray.length > 10 ? new HashSet(exportPackageDescriptionArray.length) : new ArrayList(exportPackageDescriptionArray.length));
            this.initializeExports(exportPackageDescriptionArray, this.exportedPackages);
        } else {
            this.exportedPackages = Collections.synchronizedCollection(new ArrayList(0));
        }
        objectArray = bundleDescription.getSubstitutedExports();
        if (objectArray.length > 0) {
            this.substitutedPackages = objectArray.length > 10 ? new HashSet(objectArray.length) : new ArrayList(objectArray.length);
            int n4 = 0;
            while (n4 < objectArray.length) {
                this.substitutedPackages.add(objectArray[n4].getName());
                ++n4;
            }
        } else {
            this.substitutedPackages = null;
        }
        BundleFragment[] bundleFragmentArray = bundleHost.getFragments();
        BundleDescription[] bundleDescriptionArray2 = new BundleDescription[bundleFragmentArray == null ? 0 : bundleFragmentArray.length];
        n = 0;
        while (n < bundleDescriptionArray2.length) {
            bundleDescriptionArray2[n] = bundleFragmentArray[n].getBundleDescription();
            ++n;
        }
        if (bundleDescription.hasDynamicImports()) {
            this.addDynamicImportPackage(bundleDescription.getImportPackages());
        }
        n = 0;
        while (n < bundleDescriptionArray2.length) {
            if (bundleDescriptionArray2[n].isResolved() && bundleDescriptionArray2[n].hasDynamicImports()) {
                this.addDynamicImportPackage(bundleDescriptionArray2[n].getImportPackages());
            }
            ++n;
        }
        String string = null;
        try {
            string = (String)bundleHost.getBundleData().getManifest().get("Eclipse-BuddyPolicy");
        }
        catch (BundleException bundleException) {}
        PolicyHandler policyHandler = this.policy = string != null ? new PolicyHandler(this, string, bundleHost.getFramework().getPackageAdmin()) : null;
        if (this.policy != null) {
            this.policy.open(bundleHost.getFramework().getSystemBundleContext());
        }
    }

    private void initializeExports(ExportPackageDescription[] exportPackageDescriptionArray, Collection collection) {
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            if (this.proxy.forceSourceCreation(exportPackageDescriptionArray[n]) && !collection.contains(exportPackageDescriptionArray[n].getName())) {
                this.proxy.createPackageSource(exportPackageDescriptionArray[n], true);
            }
            collection.add(exportPackageDescriptionArray[n].getName());
            ++n;
        }
    }

    public synchronized KeyedHashSet getImportedSources(KeyedHashSet keyedHashSet) {
        if ((this.loaderFlags & 1) != 0) {
            return this.importedSources;
        }
        BundleDescription bundleDescription = this.proxy.getBundleDescription();
        ExportPackageDescription[] exportPackageDescriptionArray = bundleDescription.getResolvedImports();
        if (exportPackageDescriptionArray != null && exportPackageDescriptionArray.length > 0) {
            if (this.importedSources == null) {
                this.importedSources = new KeyedHashSet(exportPackageDescriptionArray.length, false);
            }
            int n = 0;
            while (n < exportPackageDescriptionArray.length) {
                PackageSource packageSource;
                if (exportPackageDescriptionArray[n].getExporter() != bundleDescription && (packageSource = this.createExportPackageSource(exportPackageDescriptionArray[n], keyedHashSet)) != null) {
                    this.importedSources.add(packageSource);
                }
                ++n;
            }
        }
        this.loaderFlags = (byte)(this.loaderFlags | 1);
        return this.importedSources;
    }

    final PackageSource createExportPackageSource(ExportPackageDescription exportPackageDescription, KeyedHashSet keyedHashSet) {
        BundleLoaderProxy bundleLoaderProxy = this.getLoaderProxy(exportPackageDescription.getExporter());
        if (bundleLoaderProxy == null) {
            return null;
        }
        PackageSource packageSource = bundleLoaderProxy.getBundleLoader().findRequiredSource(exportPackageDescription.getName(), keyedHashSet);
        PackageSource packageSource2 = bundleLoaderProxy.createPackageSource(exportPackageDescription, false);
        if (packageSource == null) {
            return packageSource2;
        }
        return BundleLoader.createMultiSource(exportPackageDescription.getName(), new PackageSource[]{packageSource, packageSource2});
    }

    private static PackageSource createMultiSource(String string, PackageSource[] packageSourceArray) {
        if (packageSourceArray.length == 1) {
            return packageSourceArray[0];
        }
        ArrayList<SingleSourcePackage> arrayList = new ArrayList<SingleSourcePackage>(packageSourceArray.length);
        int n = 0;
        while (n < packageSourceArray.length) {
            SingleSourcePackage[] singleSourcePackageArray = packageSourceArray[n].getSuppliers();
            int n2 = 0;
            while (n2 < singleSourcePackageArray.length) {
                if (!arrayList.contains(singleSourcePackageArray[n2])) {
                    arrayList.add(singleSourcePackageArray[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return new MultiSourcePackage(string, arrayList.toArray(new SingleSourcePackage[arrayList.size()]));
    }

    public final BundleLoaderProxy getLoaderProxy(BundleDescription bundleDescription) {
        BundleLoaderProxy bundleLoaderProxy = (BundleLoaderProxy)bundleDescription.getUserObject();
        if (bundleLoaderProxy == null) {
            long l = bundleDescription.getBundleId();
            BundleHost bundleHost = (BundleHost)this.bundle.getFramework().getBundle(l);
            if (bundleHost == null) {
                return null;
            }
            bundleLoaderProxy = bundleHost.getLoaderProxy();
        }
        return bundleLoaderProxy;
    }

    synchronized void close() {
        if ((this.loaderFlags & 8) != 0) {
            return;
        }
        if (this.classloader != null) {
            this.classloader.close();
        }
        if (this.policy != null) {
            this.policy.close(this.bundle.getFramework().getSystemBundleContext());
        }
        this.loaderFlags = (byte)(this.loaderFlags | 8);
    }

    public final Class loadClass(String string) throws ClassNotFoundException {
        return this.createClassLoader().loadClass(string);
    }

    final URL getResource(String string) {
        return this.createClassLoader().getResource(string);
    }

    public final synchronized ClassLoader getParentClassLoader() {
        if (this.parent != null) {
            return this.parent;
        }
        this.createClassLoader();
        return this.parent;
    }

    public final synchronized BundleClassLoader createClassLoader() {
        String[] stringArray;
        if (this.classloader != null) {
            return this.classloader;
        }
        try {
            stringArray = this.bundle.getBundleData().getClassPath();
        }
        catch (BundleException bundleException) {
            stringArray = new String[]{};
            this.bundle.getFramework().publishFrameworkEvent(2, this.bundle, bundleException);
        }
        if (stringArray == null) {
            stringArray = new String[]{};
            this.bundle.getFramework().publishFrameworkEvent(2, this.bundle, new BundleException(Msg.BUNDLE_NO_CLASSPATH_MATCH, 3));
        }
        BundleClassLoader bundleClassLoader = this.createBCLPrevileged(this.bundle.getProtectionDomain(), stringArray);
        this.parent = this.getParentPrivileged(bundleClassLoader);
        this.classloader = bundleClassLoader;
        return this.classloader;
    }

    Class findLocalClass(String string) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].findLocalClass(" + string + ")");
        }
        try {
            Class clazz = this.createClassLoader().findLocalClass(string);
            if (Debug.DEBUG_LOADER && clazz != null) {
                Debug.println("BundleLoader[" + this + "] found local class " + string);
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (classNotFoundException instanceof StatusException && (((StatusException)((Object)classNotFoundException)).getStatusCode() & 8) != 0) {
                throw classNotFoundException;
            }
            return null;
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        return this.findClass(string, true);
    }

    Class findClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz;
        block4: {
            ClassLoader classLoader = this.getParentClassLoader();
            if (bl && classLoader != null && string.startsWith(JAVA_PACKAGE)) {
                return classLoader.loadClass(string);
            }
            try {
                if (USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK) {
                    BundleLoader.lock(this.createClassLoader());
                }
                clazz = this.findClassInternal(string, bl, classLoader);
                Object var4_5 = null;
                if (!USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK) break block4;
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_6 = null;
                    if (!USE_GLOBAL_DEADLOCK_AVOIDANCE_LOCK) break block5;
                    BundleLoader.unlock();
                }
                throw throwable;
            }
            BundleLoader.unlock();
        }
        return clazz;
    }

    private Class findClassInternal(String string, boolean bl, ClassLoader classLoader) throws ClassNotFoundException {
        if (Debug.DEBUG_LOADER) {
            Debug.println("BundleLoader[" + this + "].loadBundleClass(" + string + ")");
        }
        String string2 = BundleLoader.getPackageName(string);
        boolean bl2 = false;
        if (bl && classLoader != null && this.bundle.getFramework().isBootDelegationPackage(string2)) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                bl2 = true;
            }
        }
        Class clazz = null;
        try {
            clazz = (Class)this.searchHooks(string, 1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (clazz != null) {
            return clazz;
        }
        PackageSource packageSource = this.findImportedSource(string2, null);
        if (packageSource != null) {
            clazz = packageSource.loadClass(string);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(string);
        }
        packageSource = this.findRequiredSource(string2, null);
        if (packageSource != null) {
            clazz = packageSource.loadClass(string);
        }
        if (clazz == null) {
            clazz = this.findLocalClass(string);
        }
        if (clazz != null) {
            return clazz;
        }
        if (packageSource == null && (packageSource = this.findDynamicSource(string2)) != null) {
            clazz = packageSource.loadClass(string);
            if (clazz != null) {
                return clazz;
            }
            throw new ClassNotFoundException(string);
        }
        if (clazz == null) {
            try {
                clazz = (Class)this.searchHooks(string, 2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (clazz == null && this.policy != null) {
            clazz = this.policy.doBuddyClassLoading(string);
        }
        if (clazz != null) {
            return clazz;
        }
        if (classLoader != null && !bl2 && (bl && this.bundle.getFramework().compatibiltyBootDelegation || this.isRequestFromVM())) {
            try {
                return classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        throw new ClassNotFoundException(string);
    }

    private Object searchHooks(String string, int n) throws ClassNotFoundException, FileNotFoundException {
        ClassLoaderDelegateHook[] classLoaderDelegateHookArray = this.bundle.getFramework().getDelegateHooks();
        if (classLoaderDelegateHookArray == null) {
            return null;
        }
        Object object = null;
        int n2 = 0;
        while (n2 < classLoaderDelegateHookArray.length && object == null) {
            switch (n) {
                case 1: {
                    object = classLoaderDelegateHookArray[n2].preFindClass(string, this.createClassLoader(), this.bundle.getBundleData());
                    break;
                }
                case 2: {
                    object = classLoaderDelegateHookArray[n2].postFindClass(string, this.createClassLoader(), this.bundle.getBundleData());
                    break;
                }
                case 3: {
                    object = classLoaderDelegateHookArray[n2].preFindResource(string, this.createClassLoader(), this.bundle.getBundleData());
                    break;
                }
                case 4: {
                    object = classLoaderDelegateHookArray[n2].postFindResource(string, this.createClassLoader(), this.bundle.getBundleData());
                    break;
                }
                case 5: {
                    object = classLoaderDelegateHookArray[n2].preFindResources(string, this.createClassLoader(), this.bundle.getBundleData());
                    break;
                }
                case 6: {
                    object = classLoaderDelegateHookArray[n2].postFindResources(string, this.createClassLoader(), this.bundle.getBundleData());
                    break;
                }
                case 7: {
                    object = classLoaderDelegateHookArray[n2].preFindLibrary(string, this.createClassLoader(), this.bundle.getBundleData());
                    break;
                }
                case 8: {
                    object = classLoaderDelegateHookArray[n2].postFindLibrary(string, this.createClassLoader(), this.bundle.getBundleData());
                }
            }
            ++n2;
        }
        return object;
    }

    private boolean isRequestFromVM() {
        if (this.bundle.getFramework().isBootDelegationPackage("*") || !this.bundle.getFramework().contextBootDelegation) {
            return false;
        }
        Class[] classArray = CLASS_CONTEXT.getClassContext();
        if (classArray == null || classArray.length < 2) {
            return false;
        }
        int n = 1;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = Class.forName("org.eclipse.osgi.internal.loader.BundleLoader");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz != clazz2) {
                ClassLoader classLoader;
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("java.lang.ClassLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz3.isAssignableFrom(classArray[n]) && (classLoader = BundleLoader.getClassLoader(classArray[n])) != FW_CLASSLOADER) {
                    Class<?> clazz4 = class$3;
                    if (clazz4 == null) {
                        try {
                            clazz4 = class$3 = Class.forName("java.lang.Class");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz4 == classArray[n] || classLoader instanceof BundleClassLoader) break;
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private static ClassLoader getClassLoader(final Class clazz) {
        if (System.getSecurityManager() == null) {
            return clazz.getClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getClassLoader();
            }
        });
    }

    public URL findResource(String string) {
        return this.findResource(string, true);
    }

    URL findResource(String string, boolean bl) {
        URL uRL;
        if (string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string2 = BundleLoader.getResourcePackageName(string);
        boolean bl2 = false;
        ClassLoader classLoader = this.getParentClassLoader();
        if (bl && classLoader != null) {
            if (string2.startsWith(JAVA_PACKAGE)) {
                return classLoader.getResource(string);
            }
            if (this.bundle.getFramework().isBootDelegationPackage(string2)) {
                uRL = classLoader.getResource(string);
                if (uRL != null) {
                    return uRL;
                }
                bl2 = true;
            }
        }
        uRL = null;
        try {
            uRL = (URL)this.searchHooks(string, 3);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (uRL != null) {
            return uRL;
        }
        PackageSource packageSource = this.findImportedSource(string2, null);
        if (packageSource != null) {
            return packageSource.getResource(string);
        }
        packageSource = this.findRequiredSource(string2, null);
        if (packageSource != null) {
            uRL = packageSource.getResource(string);
        }
        if (uRL == null) {
            uRL = this.findLocalResource(string);
        }
        if (uRL != null) {
            return uRL;
        }
        if (packageSource == null && (packageSource = this.findDynamicSource(string2)) != null) {
            return packageSource.getResource(string);
        }
        if (uRL == null) {
            try {
                uRL = (URL)this.searchHooks(string, 4);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        if (uRL == null && this.policy != null) {
            uRL = this.policy.doBuddyResourceLoading(string);
        }
        if (uRL != null) {
            return uRL;
        }
        if (classLoader != null && !bl2 && (bl && this.bundle.getFramework().compatibiltyBootDelegation || this.isRequestFromVM())) {
            return classLoader.getResource(string);
        }
        return uRL;
    }

    public Enumeration findResources(String string) throws IOException {
        Enumeration enumeration;
        if (string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string2 = BundleLoader.getResourcePackageName(string);
        Enumeration enumeration2 = null;
        try {
            enumeration2 = (Enumeration)this.searchHooks(string, 5);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        if (enumeration2 != null) {
            return enumeration2;
        }
        PackageSource packageSource = this.findImportedSource(string2, null);
        if (packageSource != null) {
            return packageSource.getResources(string);
        }
        packageSource = this.findRequiredSource(string2, null);
        if (packageSource != null) {
            enumeration2 = packageSource.getResources(string);
        }
        if ((enumeration2 = BundleLoader.compoundEnumerations(enumeration2, enumeration = this.findLocalResources(string))) == null && packageSource == null && (packageSource = this.findDynamicSource(string2)) != null) {
            return packageSource.getResources(string);
        }
        if (enumeration2 == null) {
            try {
                enumeration2 = (Enumeration)this.searchHooks(string, 6);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        if (this.policy != null) {
            Enumeration enumeration3 = this.policy.doBuddyResourcesLoading(string);
            enumeration2 = BundleLoader.compoundEnumerations(enumeration2, enumeration3);
        }
        return enumeration2;
    }

    public Enumeration getResources(String string) throws IOException {
        if (string.length() > 1 && string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string2 = BundleLoader.getResourcePackageName(string);
        Enumeration<URL> enumeration = null;
        if (string2.startsWith(JAVA_PACKAGE) || this.bundle.getFramework().isBootDelegationPackage(string2)) {
            ClassLoader classLoader = this.getParentClassLoader();
            Enumeration<URL> enumeration2 = enumeration = classLoader == null ? null : classLoader.getResources(string);
            if (string2.startsWith(JAVA_PACKAGE)) {
                return enumeration;
            }
        }
        return BundleLoader.compoundEnumerations(enumeration, this.findResources(string));
    }

    public static Enumeration compoundEnumerations(Enumeration enumeration, Enumeration enumeration2) {
        if (enumeration2 == null || !enumeration2.hasMoreElements()) {
            return enumeration;
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return enumeration2;
        }
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        while (enumeration2.hasMoreElements()) {
            Object e = enumeration2.nextElement();
            if (vector.contains(e)) continue;
            vector.add(e);
        }
        return vector.elements();
    }

    URL findLocalResource(String string) {
        return this.createClassLoader().findLocalResource(string);
    }

    Enumeration findLocalResources(String string) {
        return this.createClassLoader().findLocalResources(string);
    }

    public String findLibrary(final String string) {
        if (System.getSecurityManager() == null) {
            return this.findLocalLibrary(string);
        }
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.findLocalLibrary(string);
            }
        });
    }

    final String findLocalLibrary(String string) {
        String string2 = null;
        try {
            string2 = (String)this.searchHooks(string, 7);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        if (string2 != null) {
            return string2;
        }
        string2 = this.bundle.getBundleData().findLibrary(string);
        if (string2 != null) {
            return string2;
        }
        BundleFragment[] bundleFragmentArray = this.bundle.getFragments();
        if (bundleFragmentArray != null) {
            int n = 0;
            while (n < bundleFragmentArray.length) {
                string2 = bundleFragmentArray[n].getBundleData().findLibrary(string);
                if (string2 != null) {
                    return string2;
                }
                ++n;
            }
        }
        try {
            return (String)this.searchHooks(string, 8);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public final AbstractBundle getBundle() {
        return this.bundle;
    }

    private BundleClassLoader createBCLPrevileged(final BundleProtectionDomain bundleProtectionDomain, final String[] stringArray) {
        if (System.getSecurityManager() == null) {
            return this.createBCL(bundleProtectionDomain, stringArray);
        }
        return (BundleClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return BundleLoader.this.createBCL(bundleProtectionDomain, stringArray);
            }
        });
    }

    BundleClassLoader createBCL(BundleProtectionDomain bundleProtectionDomain, String[] stringArray) {
        BundleClassLoader bundleClassLoader = this.bundle.getBundleData().createClassLoader(this, bundleProtectionDomain, stringArray);
        BundleFragment[] bundleFragmentArray = this.bundle.getFragments();
        if (bundleFragmentArray != null) {
            int n = 0;
            while (n < bundleFragmentArray.length) {
                try {
                    bundleClassLoader.attachFragment(bundleFragmentArray[n].getBundleData(), bundleFragmentArray[n].getProtectionDomain(), bundleFragmentArray[n].getBundleData().getClassPath());
                }
                catch (BundleException bundleException) {
                    this.bundle.getFramework().publishFrameworkEvent(2, this.bundle, bundleException);
                }
                ++n;
            }
        }
        bundleClassLoader.initialize();
        return bundleClassLoader;
    }

    public final String toString() {
        BundleData bundleData = this.bundle.getBundleData();
        return bundleData == null ? "BundleLoader.bundledata == null!" : bundleData.toString();
    }

    private final synchronized boolean isDynamicallyImported(String string) {
        int n;
        if (this instanceof SystemBundleLoader) {
            return false;
        }
        if (string.startsWith(JAVA_PACKAGE)) {
            return true;
        }
        if ((this.loaderFlags & 2) == 0) {
            return false;
        }
        if ((this.loaderFlags & 4) != 0) {
            return true;
        }
        if (this.dynamicImportPackages != null) {
            n = 0;
            while (n < this.dynamicImportPackages.length) {
                if (string.equals(this.dynamicImportPackages[n])) {
                    return true;
                }
                ++n;
            }
        }
        if (this.dynamicImportPackageStems != null) {
            n = 0;
            while (n < this.dynamicImportPackageStems.length) {
                if (string.startsWith(this.dynamicImportPackageStems[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    final void addExportedProvidersFor(String string, String string2, ArrayList arrayList, KeyedHashSet keyedHashSet) {
        if (!keyedHashSet.add(this.bundle)) {
            return;
        }
        PackageSource packageSource = null;
        if (this.isExportedPackage(string2)) {
            packageSource = this.proxy.getPackageSource(string2);
        } else if (this.isSubstitutedExport(string2)) {
            arrayList.add(this.findImportedSource(string2, keyedHashSet));
            return;
        }
        if (this.requiredBundles != null) {
            int n = this.reexportTable == null ? 0 : this.reexportTable.length;
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.requiredBundles.length) {
                if (packageSource != null) {
                    this.requiredBundles[n3].getBundleLoader().addExportedProvidersFor(string, string2, arrayList, keyedHashSet);
                } else if (n2 < n && this.reexportTable[n2] == n3) {
                    ++n2;
                    this.requiredBundles[n3].getBundleLoader().addExportedProvidersFor(string, string2, arrayList, keyedHashSet);
                }
                ++n3;
            }
        }
        if (packageSource != null && packageSource.isFriend(string)) {
            arrayList.add(packageSource);
        }
    }

    final boolean isExportedPackage(String string) {
        return this.exportedPackages.contains(string);
    }

    final boolean isSubstitutedExport(String string) {
        return this.substitutedPackages == null ? false : this.substitutedPackages.contains(string);
    }

    private void addDynamicImportPackage(ImportPackageSpecification[] importPackageSpecificationArray) {
        if (importPackageSpecificationArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(importPackageSpecificationArray.length);
        int n = 0;
        while (n < importPackageSpecificationArray.length) {
            if ("dynamic".equals(importPackageSpecificationArray[n].getDirective("resolution"))) {
                arrayList.add(importPackageSpecificationArray[n].getName());
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            this.addDynamicImportPackage(arrayList.toArray(new String[arrayList.size()]));
        }
    }

    private void addDynamicImportPackage(String[] stringArray) {
        int n;
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2;
        if (stringArray == null) {
            return;
        }
        this.loaderFlags = (byte)(this.loaderFlags | 2);
        int n2 = stringArray.length;
        if (this.dynamicImportPackageStems == null) {
            arrayList2 = new ArrayList<String>(n2);
        } else {
            arrayList2 = new ArrayList(n2 + this.dynamicImportPackageStems.length);
            int n3 = 0;
            while (n3 < this.dynamicImportPackageStems.length) {
                arrayList2.add(this.dynamicImportPackageStems[n3]);
                ++n3;
            }
        }
        if (this.dynamicImportPackages == null) {
            arrayList = new ArrayList<String>(n2);
        } else {
            arrayList = new ArrayList(n2 + this.dynamicImportPackages.length);
            n = 0;
            while (n < this.dynamicImportPackages.length) {
                arrayList.add(this.dynamicImportPackages[n]);
                ++n;
            }
        }
        n = 0;
        while (n < n2) {
            String string = stringArray[n];
            if (!this.isDynamicallyImported(string)) {
                if (string.equals("*")) {
                    this.loaderFlags = (byte)(this.loaderFlags | 4);
                    return;
                }
                if (string.endsWith(".*")) {
                    arrayList2.add(string.substring(0, string.length() - 1));
                } else {
                    arrayList.add(string);
                }
            }
            ++n;
        }
        n2 = arrayList2.size();
        if (n2 > 0) {
            this.dynamicImportPackageStems = arrayList2.toArray(new String[n2]);
        }
        if ((n2 = arrayList.size()) > 0) {
            this.dynamicImportPackages = arrayList.toArray(new String[n2]);
        }
    }

    public final synchronized void addDynamicImportPackage(ManifestElement[] manifestElementArray) {
        if (manifestElementArray == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>(manifestElementArray.length);
        int n = 0;
        while (n < manifestElementArray.length) {
            arrayList.add(manifestElementArray[n].getValue());
            ++n;
        }
        if (arrayList.size() > 0) {
            this.addDynamicImportPackage(arrayList.toArray(new String[arrayList.size()]));
        }
    }

    public synchronized void attachFragment(BundleFragment bundleFragment) throws BundleException {
        ExportPackageDescription[] exportPackageDescriptionArray = this.proxy.getBundleDescription().getSelectedExports();
        if (this.classloader == null) {
            this.initializeExports(exportPackageDescriptionArray, this.exportedPackages);
            return;
        }
        String[] stringArray = bundleFragment.getBundleData().getClassPath();
        if (stringArray != null) {
            this.classloader.attachFragment(bundleFragment.getBundleData(), bundleFragment.getProtectionDomain(), stringArray);
        }
        this.initializeExports(exportPackageDescriptionArray, this.exportedPackages);
    }

    private PackageSource findSource(String string) {
        if (string == null) {
            return null;
        }
        PackageSource packageSource = this.findImportedSource(string, null);
        if (packageSource != null) {
            return packageSource;
        }
        return this.findRequiredSource(string, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findImportedSource(String string, KeyedHashSet keyedHashSet) {
        KeyedHashSet keyedHashSet2 = this.getImportedSources(keyedHashSet);
        if (keyedHashSet2 == null) {
            return null;
        }
        KeyedHashSet keyedHashSet3 = keyedHashSet2;
        synchronized (keyedHashSet3) {
            return (PackageSource)keyedHashSet2.getByKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findDynamicSource(String string) {
        ExportPackageDescription exportPackageDescription;
        if (this.isDynamicallyImported(string) && (exportPackageDescription = this.bundle.getFramework().getAdaptor().getState().linkDynamicImport(this.proxy.getBundleDescription(), string)) != null) {
            PackageSource packageSource = this.createExportPackageSource(exportPackageDescription, null);
            Object object = this;
            synchronized (object) {
                if (this.importedSources == null) {
                    this.importedSources = new KeyedHashSet(false);
                }
            }
            object = this.importedSources;
            synchronized (object) {
                this.importedSources.add(packageSource);
            }
            return packageSource;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PackageSource findRequiredSource(String string, KeyedHashSet keyedHashSet) {
        PackageSource packageSource;
        PackageSource[] packageSourceArray;
        if (this.requiredBundles == null) {
            return null;
        }
        Object object = this.requiredSources;
        synchronized (object) {
            PackageSource packageSource2 = (PackageSource)this.requiredSources.getByKey(string);
            if (packageSource2 != null) {
                return packageSource2.isNullSource() ? null : packageSource2;
            }
        }
        if (keyedHashSet == null) {
            keyedHashSet = new KeyedHashSet(false);
        }
        keyedHashSet.add(this.bundle);
        object = new ArrayList(3);
        int n = 0;
        while (n < this.requiredBundles.length) {
            packageSourceArray = this.requiredBundles[n].getBundleLoader();
            packageSourceArray.addExportedProvidersFor(this.proxy.getSymbolicName(), string, (ArrayList)object, keyedHashSet);
            ++n;
        }
        if (((ArrayList)object).size() == 0) {
            packageSource = NullPackageSource.getNullPackageSource(string);
        } else if (((ArrayList)object).size() == 1) {
            packageSource = (PackageSource)((ArrayList)object).get(0);
        } else {
            packageSourceArray = ((ArrayList)object).toArray(new PackageSource[((ArrayList)object).size()]);
            packageSource = BundleLoader.createMultiSource(string, packageSourceArray);
        }
        packageSourceArray = this.requiredSources;
        synchronized (packageSourceArray) {
            this.requiredSources.add(packageSource);
        }
        return packageSource.isNullSource() ? null : packageSource;
    }

    public final PackageSource getPackageSource(String string) {
        PackageSource packageSource = this.findSource(string);
        if (!this.isExportedPackage(string)) {
            return packageSource;
        }
        PackageSource packageSource2 = this.proxy.getPackageSource(string);
        if (packageSource == null) {
            return packageSource2;
        }
        if (packageSource2 == null) {
            return packageSource;
        }
        return BundleLoader.createMultiSource(string, new PackageSource[]{packageSource, packageSource2});
    }

    private ClassLoader getParentPrivileged(final BundleClassLoader bundleClassLoader) {
        if (System.getSecurityManager() == null) {
            return bundleClassLoader.getParent();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return bundleClassLoader.getParent();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lock(Object object) {
        Thread thread = Thread.currentThread();
        boolean bl = false;
        Object object2 = object;
        synchronized (object2) {
            if (BundleLoader.tryLock(thread, object)) {
                return;
            }
            do {
                try {
                    object.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            } while (!BundleLoader.tryLock(thread));
        }
        if (bl) {
            thread.interrupt();
        }
    }

    private static synchronized boolean tryLock(Thread thread, Object object) {
        if (lockThread == thread) {
            ++lockCount;
            return true;
        }
        if (lockThread == null) {
            ++lockCount;
            lockThread = thread;
            return true;
        }
        waitingList.add(new Object[]{thread, object});
        return false;
    }

    private static synchronized boolean tryLock(Thread thread) {
        if (lockThread == thread) {
            ++lockCount;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unlock() {
        Thread thread = null;
        Object object = null;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.internal.loader.BundleLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Object object2 = clazz;
        synchronized (clazz) {
            if (--lockCount != 0) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (waitingList.isEmpty()) {
                lockThread = null;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Object object3 = (Object[])waitingList.get(0);
            thread = (Thread)object3[0];
            object = object3[1];
            // ** MonitorExit[var2_2] (shouldn't be in output)
            object2 = object;
            synchronized (object2) {
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.osgi.internal.loader.BundleLoader");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                object3 = clazz2;
                synchronized (clazz2) {
                    lockThread = thread;
                    waitingList.remove(0);
                    object.notifyAll();
                    // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                }
            }
            return;
        }
    }

    public static void closeBundleLoader(BundleLoaderProxy bundleLoaderProxy) {
        if (bundleLoaderProxy == null) {
            return;
        }
        BundleLoader bundleLoader = bundleLoaderProxy.getBasicBundleLoader();
        if (bundleLoader != null) {
            bundleLoader.close();
        }
        bundleLoaderProxy.setStale();
        BundleDescription bundleDescription = bundleLoaderProxy.getBundleDescription();
        bundleDescription.setUserObject(null);
    }

    static final class ClassContext
    extends SecurityManager {
        ClassContext() {
        }

        public Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

