/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.osgi.framework.internal.core.BundleFragment;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.BundleLoaderProxy;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.osgi.framework.BundleException;

public class SystemBundleLoader
extends BundleLoader {
    public static final String EQUINOX_EE = "x-equinox-ee";
    private final ClassLoader classLoader;
    private final HashSet eePackages;
    private final HashSet extPackages;
    private final ClassLoader extClassLoader;

    /*
     * Unable to fully structure code
     */
    protected SystemBundleLoader(BundleHost var1_1, BundleLoaderProxy var2_2) throws BundleException {
        block9: {
            super(var1_1, var2_2);
            var3_3 = var2_2.getBundleDescription().getSelectedExports();
            if (var3_3 == null || var3_3.length == 0) {
                this.eePackages = null;
            } else {
                this.eePackages = new HashSet<E>(var3_3.length);
                var4_4 = 0;
                while (var4_4 < var3_3.length) {
                    if ((Integer)var3_3[var4_4].getDirective("x-equinox-ee") >= 0) {
                        this.eePackages.add(var3_3[var4_4].getName());
                    }
                    ++var4_4;
                }
            }
            this.classLoader = this.getClass().getClassLoader();
            this.extPackages = new HashSet<E>(0);
            var4_5 = var1_1.getFragments();
            if (var4_5 != null) {
                var5_6 = 0;
                while (var5_6 < var4_5.length) {
                    this.addExtPackages(var4_5[var5_6]);
                    ++var5_6;
                }
            }
            if ((var5_7 = ClassLoader.getSystemClassLoader()) != null) ** GOTO lbl27
            this.extClassLoader = null;
            break block9;
lbl-1000:
            // 1 sources

            {
                var5_7 = var5_7.getParent();
lbl27:
                // 2 sources

                ** while (var5_7.getParent() != null)
            }
lbl28:
            // 1 sources

            var6_8 = false;
            var7_9 = this.classLoader;
            while (var7_9.getParent() != null && !var6_8) {
                if (var7_9.getParent() == var5_7) {
                    var6_8 = true;
                    continue;
                }
                var7_9 = var7_9.getParent();
            }
            this.extClassLoader = var6_8 != false ? null : var5_7;
        }
    }

    private void addExtPackages(BundleFragment bundleFragment) {
        if ((bundleFragment.getBundleData().getType() & 0x10) == 0) {
            return;
        }
        ExportPackageDescription[] exportPackageDescriptionArray = bundleFragment.getBundleDescription().getExportPackages();
        int n = 0;
        while (n < exportPackageDescriptionArray.length) {
            this.extPackages.add(exportPackageDescriptionArray[n].getName());
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void attachFragment(BundleFragment bundleFragment) throws BundleException {
        super.attachFragment(bundleFragment);
        HashSet hashSet = this.extPackages;
        synchronized (hashSet) {
            this.addExtPackages(bundleFragment);
        }
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Class clazz = this.findLocalClass(string);
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        return clazz;
    }

    public String findLibrary(String string) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class findLocalClass(String string) {
        try {
            return this.classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.extClassLoader != null) {
                HashSet hashSet = this.extPackages;
                synchronized (hashSet) {
                    block9: {
                        if (this.extPackages.size() <= 0 || !this.extPackages.contains(BundleLoader.getPackageName(string))) break block9;
                        try {
                            return this.extClassLoader.loadClass(string);
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            return null;
                        }
                    }
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    URL findLocalResource(String string) {
        URL uRL = this.classLoader.getResource(string);
        if (uRL == null && this.extClassLoader != null) {
            HashSet hashSet = this.extPackages;
            synchronized (hashSet) {
                if (this.extPackages.size() > 0 && this.extPackages.contains(BundleLoader.getResourcePackageName(string))) {
                    uRL = this.extClassLoader.getResource(string);
                }
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Enumeration findLocalResources(String string) {
        Enumeration<URL> enumeration = null;
        try {
            enumeration = this.classLoader.getResources(string);
        }
        catch (IOException iOException) {}
        if (!(enumeration != null && enumeration.hasMoreElements() || this.extClassLoader == null)) {
            HashSet hashSet = this.extPackages;
            synchronized (hashSet) {
                if (this.extPackages.size() > 0 && this.extPackages.contains(BundleLoader.getResourcePackageName(string))) {
                    try {
                        enumeration = this.extClassLoader.getResources(string);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return enumeration;
    }

    public URL findResource(String string) {
        return this.findLocalResource(string);
    }

    public Enumeration findResources(String string) throws IOException {
        return this.findLocalResources(string);
    }

    protected void close() {
    }

    public boolean isEEPackage(String string) {
        return this.eePackages.contains(string);
    }
}

