/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.internal.permadmin.PermissionInfoCollection;
import org.eclipse.osgi.internal.permadmin.SecurityAdmin;
import org.osgi.framework.Bundle;

public final class BundlePermissions
extends PermissionCollection {
    private static final long serialVersionUID = -5443618108312606612L;
    static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private final Bundle bundle;
    private final SecurityAdmin securityAdmin;
    private final PermissionInfoCollection impliedPermissions;
    private final PermissionInfoCollection restrictedPermissions;

    public BundlePermissions(Bundle bundle, SecurityAdmin securityAdmin, PermissionInfoCollection permissionInfoCollection, PermissionInfoCollection permissionInfoCollection2) {
        this.bundle = bundle;
        this.securityAdmin = securityAdmin;
        this.impliedPermissions = permissionInfoCollection;
        this.restrictedPermissions = permissionInfoCollection2;
        this.setReadOnly();
    }

    public void add(Permission permission) {
        throw new SecurityException();
    }

    public Enumeration elements() {
        return EMPTY_ENUMERATION;
    }

    public boolean implies(Permission permission) {
        if (this.impliedPermissions != null && this.impliedPermissions.implies(permission)) {
            return true;
        }
        if (this.restrictedPermissions != null && !this.restrictedPermissions.implies(permission)) {
            return false;
        }
        return this.securityAdmin.checkPermission(permission, this);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    void clearPermissionCache() {
        if (this.impliedPermissions != null) {
            this.impliedPermissions.clearPermissionCache();
        }
        if (this.restrictedPermissions != null) {
            this.restrictedPermissions.clearPermissionCache();
        }
    }
}

