/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.permadmin;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashMap;
import org.eclipse.osgi.internal.permadmin.BundlePermissions;
import org.eclipse.osgi.internal.permadmin.PermissionsHash;
import org.osgi.service.permissionadmin.PermissionInfo;

public final class PermissionInfoCollection
extends PermissionCollection {
    private static final long serialVersionUID = 3140511562980923957L;
    private static final Class[] twoStringClassArray;
    private static final Class[] oneStringClassArray;
    private static final Class[] noArgClassArray;
    private static final Class[][] permClassArrayArgs;
    private final HashMap cachedPermissionCollections = new HashMap();
    private final boolean hasAllPermission;
    private final PermissionInfo[] permInfos;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        twoStringClassArray = classArray;
        Class[] classArray2 = new Class[1];
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz3;
        oneStringClassArray = classArray2;
        noArgClassArray = new Class[0];
        permClassArrayArgs = new Class[][]{noArgClassArray, oneStringClassArray, twoStringClassArray};
    }

    public PermissionInfoCollection(PermissionInfo[] permissionInfoArray) {
        this.permInfos = permissionInfoArray;
        boolean bl = false;
        int n = 0;
        while (n < permissionInfoArray.length && !bl) {
            String string = permissionInfoArray[n].getType();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = Class.forName("java.security.AllPermission");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (string.equals(clazz.getName())) {
                bl = true;
            }
            ++n;
        }
        this.hasAllPermission = bl;
        this.setReadOnly();
    }

    public void add(Permission permission) {
        throw new SecurityException();
    }

    public Enumeration elements() {
        return BundlePermissions.EMPTY_ENUMERATION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        PermissionCollection permissionCollection;
        if (this.hasAllPermission) {
            return true;
        }
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            Class<?> clazz = permission.getClass();
            permissionCollection = (PermissionCollection)this.cachedPermissionCollections.get(clazz);
            if (permissionCollection == null) {
                permissionCollection = permission.newPermissionCollection();
                if (permissionCollection == null) {
                    permissionCollection = new PermissionsHash();
                }
                try {
                    this.addPermissions(permissionCollection, clazz);
                }
                catch (Exception exception) {
                    throw new SecurityException("Exception creating permissions: " + exception.getClass().getName() + ": " + exception.getMessage());
                }
                this.cachedPermissionCollections.put(clazz, permissionCollection);
            }
        }
        return permissionCollection.implies(permission);
    }

    PermissionInfo[] getPermissionInfos() {
        return this.permInfos;
    }

    private void addPermissions(PermissionCollection permissionCollection, Class clazz) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        String string = clazz.getName();
        Constructor constructor = null;
        int n = -1;
        int n2 = permClassArrayArgs.length - 1;
        while (n2 >= 0) {
            try {
                constructor = clazz.getConstructor(permClassArrayArgs[n2]);
                n = n2;
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                --n2;
            }
        }
        if (constructor == null) {
            throw new NoSuchMethodException(String.valueOf(clazz.getName()) + ".<init>()");
        }
        n2 = 0;
        while (n2 < this.permInfos.length) {
            if (this.permInfos[n2].getType().equals(string)) {
                File file;
                Object[] objectArray = new String[n];
                if (n > 0) {
                    objectArray[0] = this.permInfos[n2].getName();
                }
                if (n > 1) {
                    objectArray[1] = this.permInfos[n2].getActions();
                }
                if (!this.permInfos[n2].getType().equals("java.io.FilePermission") || objectArray[0].equals("<<ALL FILES>>") || (file = new File((String)objectArray[0])).isAbsolute()) {
                    permissionCollection.add((Permission)constructor.newInstance(objectArray));
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearPermissionCache() {
        HashMap hashMap = this.cachedPermissionCollections;
        synchronized (hashMap) {
            this.cachedPermissionCollections.clear();
        }
    }
}

