/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public class GenericSpecificationImpl
extends VersionConstraintImpl
implements GenericSpecification {
    private Filter matchingFilter;
    private String type = "generic";
    private int resolution = 0;
    private GenericDescription[] suppliers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMatchingFilter() {
        Object object = this.monitor;
        synchronized (object) {
            return this.matchingFilter == null ? null : this.matchingFilter.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMatchingFilter(String string) throws InvalidSyntaxException {
        Object object = this.monitor;
        synchronized (object) {
            this.matchingFilter = string == null ? null : FilterImpl.newInstance(string);
        }
    }

    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        if (!(baseDescription instanceof GenericDescription)) {
            return false;
        }
        GenericDescription genericDescription = (GenericDescription)baseDescription;
        if (this.getName() == null || !this.getName().equals(genericDescription.getName())) {
            return false;
        }
        if (this.getType() == null || !this.getType().equals(genericDescription.getType())) {
            return false;
        }
        return this.matchingFilter == null || this.matchingFilter.match(genericDescription.getAttributes());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eclipse-GenericRequire").append(": ").append(this.getName());
        if (this.getType() != "generic") {
            stringBuffer.append(':').append(this.getType());
        }
        if (this.matchingFilter != null) {
            stringBuffer.append("; ").append(this.getMatchingFilter());
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getType() {
        Object object = this.monitor;
        synchronized (object) {
            return this.type;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setType(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.type = string == null || string.equals("generic") ? "generic" : string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getResolution() {
        Object object = this.monitor;
        synchronized (object) {
            return this.resolution;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResolved() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers != null && this.suppliers.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setResolution(int n) {
        Object object = this.monitor;
        synchronized (object) {
            this.resolution = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDescription getSupplier() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers == null || this.suppliers.length == 0 ? null : this.suppliers[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSupplier(BaseDescription baseDescription) {
        Object object = this.monitor;
        synchronized (object) {
            if (baseDescription == null) {
                this.suppliers = null;
                return;
            }
            int n = this.suppliers == null ? 0 : this.suppliers.length;
            GenericDescription[] genericDescriptionArray = new GenericDescription[n + 1];
            if (this.suppliers != null) {
                System.arraycopy(this.suppliers, 0, genericDescriptionArray, 0, n);
            }
            genericDescriptionArray[n] = (GenericDescription)baseDescription;
            this.suppliers = genericDescriptionArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericDescription[] getSuppliers() {
        Object object = this.monitor;
        synchronized (object) {
            return this.suppliers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSupplers(GenericDescription[] genericDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.suppliers = genericDescriptionArray;
        }
    }
}

