/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;

public class HostSpecificationImpl
extends VersionConstraintImpl
implements HostSpecification {
    private BundleDescription[] hosts;
    private boolean multihost = false;

    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        if (!(baseDescription instanceof BundleDescription)) {
            return false;
        }
        BundleDescription bundleDescription = (BundleDescription)baseDescription;
        if (bundleDescription.getHost() != null) {
            return false;
        }
        return this.getName() != null && this.getName().equals(bundleDescription.getSymbolicName()) && (this.getVersionRange() == null || this.getVersionRange().isIncluded(bundleDescription.getVersion()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleDescription[] getHosts() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hosts == null ? BundleDescriptionImpl.EMPTY_BUNDLEDESCS : this.hosts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResolved() {
        Object object = this.monitor;
        synchronized (object) {
            return this.hosts != null && this.hosts.length > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setHosts(BundleDescription[] bundleDescriptionArray) {
        Object object = this.monitor;
        synchronized (object) {
            this.hosts = bundleDescriptionArray;
        }
    }

    public String toString() {
        return "Fragment-Host: " + this.getName() + "; bundle-version=\"" + this.getVersionRange() + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDescription getSupplier() {
        Object object = this.monitor;
        synchronized (object) {
            block4: {
                if (this.hosts != null && this.hosts.length != 0) break block4;
                return null;
            }
            return this.hosts[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMultiHost() {
        Object object = this.monitor;
        synchronized (object) {
            return this.multihost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsMultiHost(boolean bl) {
        Object object = this.monitor;
        synchronized (object) {
            this.multihost = bl;
        }
    }
}

