/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.ExportPackageDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.osgi.service.resolver.VersionRange;

public class ImportPackageSpecificationImpl
extends VersionConstraintImpl
implements ImportPackageSpecification {
    private String resolution = "static";
    private String symbolicName;
    private VersionRange bundleVersionRange;
    private Map attributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getDirectives() {
        Object object = this.monitor;
        synchronized (object) {
            HashMap<String, String> hashMap = new HashMap<String, String>(5);
            if (this.resolution != null) {
                hashMap.put("resolution", this.resolution);
            }
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getDirective(String string) {
        Object object = this.monitor;
        synchronized (object) {
            if (string.equals("resolution")) {
                return this.resolution;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setDirective(String string, Object object) {
        Object object2 = this.monitor;
        synchronized (object2) {
            if (string.equals("resolution")) {
                this.resolution = (String)object;
                return this.resolution;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirectives(Map map) {
        Object object = this.monitor;
        synchronized (object) {
            if (map == null) {
                return;
            }
            this.resolution = (String)map.get("resolution");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBundleSymbolicName() {
        Object object = this.monitor;
        synchronized (object) {
            if ("system.bundle".equals(this.symbolicName)) {
                StateImpl stateImpl = (StateImpl)this.getBundle().getContainingState();
                String string = stateImpl == null ? Constants.getInternalSymbolicName() : stateImpl.getSystemBundle();
                return string;
            }
            return this.symbolicName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionRange getBundleVersionRange() {
        Object object = this.monitor;
        synchronized (object) {
            if (this.bundleVersionRange == null) {
                return VersionRange.emptyRange;
            }
            return this.bundleVersionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getAttributes() {
        Object object = this.monitor;
        synchronized (object) {
            return this.attributes;
        }
    }

    public boolean isSatisfiedBy(BaseDescription baseDescription) {
        String[] stringArray;
        String string;
        Object object;
        if (!(baseDescription instanceof ExportPackageDescription)) {
            return false;
        }
        ExportPackageDescriptionImpl exportPackageDescriptionImpl = (ExportPackageDescriptionImpl)baseDescription;
        String[] stringArray2 = (String[])exportPackageDescriptionImpl.getDirective("x-friends");
        Boolean bl = (Boolean)exportPackageDescriptionImpl.getDirective("x-internal");
        if (bl.booleanValue() || stringArray2 != null) {
            boolean bl2;
            object = (StateImpl)this.getBundle().getContainingState();
            boolean bl3 = bl2 = object == null ? false : ((StateImpl)object).inStrictMode();
            if (bl2) {
                if (bl.booleanValue()) {
                    return false;
                }
                boolean bl4 = false;
                if (stringArray2 != null && this.getBundle().getSymbolicName() != null) {
                    int n = 0;
                    while (n < stringArray2.length) {
                        if (this.getBundle().getSymbolicName().equals(stringArray2[n])) {
                            bl4 = true;
                        }
                        ++n;
                    }
                }
                if (!bl4) {
                    return false;
                }
            }
        }
        if ((object = this.getBundleSymbolicName()) != null) {
            BundleDescription bundleDescription = exportPackageDescriptionImpl.getExporter();
            if (!((String)object).equals(bundleDescription.getSymbolicName())) {
                return false;
            }
            if (this.getBundleVersionRange() != null && !this.getBundleVersionRange().isIncluded(bundleDescription.getVersion())) {
                return false;
            }
        }
        if (!("*".equals(string = this.getName()) || string.endsWith(".*") && exportPackageDescriptionImpl.getName().startsWith(string.substring(0, string.length() - 1)) || exportPackageDescriptionImpl.getName().equals(string))) {
            return false;
        }
        if (this.getVersionRange() != null && !this.getVersionRange().isIncluded(exportPackageDescriptionImpl.getVersion())) {
            return false;
        }
        Map map = this.getAttributes();
        if (map != null) {
            Map map2 = exportPackageDescriptionImpl.getAttributes();
            if (map2 == null) {
                return false;
            }
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object v = map.get(string2);
                Object v2 = map2.get(string2);
                if (v2 != null && v.equals(v2)) continue;
                return false;
            }
        }
        if ((stringArray = (String[])exportPackageDescriptionImpl.getDirective("mandatory")) != null) {
            int n = 0;
            while (n < stringArray.length) {
                if ("bundle-symbolic-name".equals(stringArray[n])) {
                    if (object == null) {
                        return false;
                    }
                } else if ("bundle-version".equals(stringArray[n])) {
                    if (this.bundleVersionRange == null) {
                        return false;
                    }
                } else if ("specification-version".equals(stringArray[n]) || "version".equals(stringArray[n])) {
                    if (this.getVersionRange() == null) {
                        return false;
                    }
                } else {
                    if (map == null) {
                        return false;
                    }
                    if (map.get(stringArray[n]) == null) {
                        return false;
                    }
                }
                ++n;
            }
        }
        if (((BundleDescriptionImpl)this.getBundle()).getEquinoxEE() < 0) {
            return true;
        }
        int n = (Integer)exportPackageDescriptionImpl.getDirective("x-equinox-ee");
        return n < 0 || n == ((BundleDescriptionImpl)this.getBundle()).getEquinoxEE();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleSymbolicName(String string) {
        Object object = this.monitor;
        synchronized (object) {
            this.symbolicName = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setBundleVersionRange(VersionRange versionRange) {
        Object object = this.monitor;
        synchronized (object) {
            this.bundleVersionRange = versionRange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAttributes(Map map) {
        Object object = this.monitor;
        synchronized (object) {
            this.attributes = map;
        }
    }

    public String toString() {
        return "Import-Package: " + this.getName() + "; version=\"" + this.getVersionRange() + "\"";
    }
}

