/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.serviceregistry;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.BundleContextImpl;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistrationImpl;
import org.eclipse.osgi.internal.serviceregistry.ServiceRegistry;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceFactory;

public class ServiceUse {
    final ServiceFactory factory;
    final BundleContextImpl context;
    final ServiceRegistrationImpl registration;
    private Object cachedService;
    private int useCount = 0;

    ServiceUse(BundleContextImpl bundleContextImpl, ServiceRegistrationImpl serviceRegistrationImpl) {
        Object object = serviceRegistrationImpl.getServiceObject();
        if (object instanceof ServiceFactory) {
            this.factory = (ServiceFactory)object;
            this.cachedService = null;
        } else {
            this.factory = null;
            this.cachedService = object;
        }
        this.context = bundleContextImpl;
        this.registration = serviceRegistrationImpl;
    }

    Object getService() {
        Object t;
        if (this.useCount > 0 || this.factory == null) {
            ++this.useCount;
            return this.cachedService;
        }
        if (Debug.DEBUG_SERVICES) {
            Debug.println("getService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        try {
            t = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return ServiceUse.this.factory.getService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration);
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".getService() exception: " + throwable.getMessage());
                Debug.printStackTrace(throwable);
            }
            this.context.getFramework().getAdaptor().handleRuntimeError(throwable);
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "getService"), 3, throwable);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
            return null;
        }
        if (t == null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".getService() returned null.");
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_OBJECT_NULL_EXCEPTION, this.factory.getClass().getName()), 2);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
            return null;
        }
        String[] stringArray = this.registration.getClasses();
        String string = ServiceRegistry.checkServiceClass(stringArray, t);
        if (string != null) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println("Service object is not an instanceof " + string);
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_NOT_INSTANCEOF_CLASS_EXCEPTION, this.factory.getClass().getName(), string), 2);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
            return null;
        }
        this.cachedService = t;
        ++this.useCount;
        return t;
    }

    boolean ungetService() {
        if (this.useCount == 0) {
            return true;
        }
        --this.useCount;
        if (this.useCount > 0) {
            return false;
        }
        if (this.factory == null) {
            return true;
        }
        final Object object = this.cachedService;
        this.cachedService = null;
        if (Debug.DEBUG_SERVICES) {
            Debug.println("ungetService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceUse.this.factory.ungetService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration, object);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_GENERAL) {
                Debug.println(this.factory + ".ungetService() exception");
                Debug.printStackTrace(throwable);
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), 3, throwable);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
        }
        return true;
    }

    void releaseService() {
        if (this.useCount == 0 || this.factory == null) {
            return;
        }
        final Object object = this.cachedService;
        this.cachedService = null;
        this.useCount = 0;
        if (Debug.DEBUG_SERVICES) {
            Debug.println("releaseService[factory=" + this.registration.getBundle() + "](" + this.context.getBundleImpl() + "," + this.registration + ")");
        }
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ServiceUse.this.factory.ungetService(ServiceUse.this.context.getBundleImpl(), ServiceUse.this.registration, object);
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            if (Debug.DEBUG_SERVICES) {
                Debug.println(this.factory + ".ungetService() exception");
                Debug.printStackTrace(throwable);
            }
            ServiceException serviceException = new ServiceException(NLS.bind(Msg.SERVICE_FACTORY_EXCEPTION, this.factory.getClass().getName(), "ungetService"), 3, throwable);
            this.context.getFramework().publishFrameworkEvent(2, this.registration.getBundle(), serviceException);
        }
    }
}

