/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.util.tracker.AbstractTracked;
import org.osgi.util.tracker.BundleTrackerCustomizer;

public class BundleTracker
implements BundleTrackerCustomizer {
    static final boolean DEBUG = false;
    protected final BundleContext context;
    final BundleTrackerCustomizer customizer;
    private volatile Tracked tracked;
    final int mask;

    private Tracked tracked() {
        return this.tracked;
    }

    public BundleTracker(BundleContext bundleContext, int n, BundleTrackerCustomizer bundleTrackerCustomizer) {
        this.context = bundleContext;
        this.mask = n;
        this.customizer = bundleTrackerCustomizer == null ? this : bundleTrackerCustomizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() {
        Tracked tracked;
        BundleTracker bundleTracker = this;
        synchronized (bundleTracker) {
            if (this.tracked != null) {
                return;
            }
            Tracked tracked2 = tracked = new Tracked();
            synchronized (tracked2) {
                this.context.addBundleListener(tracked);
                Object[] objectArray = this.context.getBundles();
                if (objectArray != null) {
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int n3 = objectArray[n2].getState();
                        if ((n3 & this.mask) == 0) {
                            objectArray[n2] = null;
                        }
                        ++n2;
                    }
                    tracked.setInitial(objectArray);
                }
            }
            this.tracked = tracked;
        }
        tracked.trackInitial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Bundle[] bundleArray;
        Tracked tracked;
        BundleTracker bundleTracker = this;
        synchronized (bundleTracker) {
            tracked = this.tracked;
            if (tracked == null) {
                return;
            }
            tracked.close();
            bundleArray = this.getBundles();
            this.tracked = null;
            try {
                this.context.removeBundleListener(tracked);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        if (bundleArray != null) {
            int n = 0;
            while (n < bundleArray.length) {
                tracked.untrack(bundleArray[n], null);
                ++n;
            }
        }
    }

    public Object addingBundle(Bundle bundle, BundleEvent bundleEvent) {
        return bundle;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent bundleEvent, Object object) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getBundles() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n;
            block5: {
                n = tracked.size();
                if (n != 0) break block5;
                return null;
            }
            return (Bundle[])tracked.getTracked(new Bundle[n]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(Bundle bundle) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getCustomizedObject(bundle);
        }
    }

    public void remove(Bundle bundle) {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return;
        }
        tracked.untrack(bundle, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return 0;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTrackingCount() {
        Tracked tracked = this.tracked();
        if (tracked == null) {
            return -1;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            return tracked.getTrackingCount();
        }
    }

    class Tracked
    extends AbstractTracked
    implements SynchronousBundleListener {
        Tracked() {
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            if (this.closed) {
                return;
            }
            Bundle bundle = bundleEvent.getBundle();
            int n = bundle.getState();
            if ((n & BundleTracker.this.mask) != 0) {
                this.track(bundle, bundleEvent);
            } else {
                this.untrack(bundle, bundleEvent);
            }
        }

        Object customizerAdding(Object object, Object object2) {
            return BundleTracker.this.customizer.addingBundle((Bundle)object, (BundleEvent)object2);
        }

        void customizerModified(Object object, Object object2, Object object3) {
            BundleTracker.this.customizer.modifiedBundle((Bundle)object, (BundleEvent)object2, object3);
        }

        void customizerRemoved(Object object, Object object2, Object object3) {
            BundleTracker.this.customizer.removedBundle((Bundle)object, (BundleEvent)object2, object3);
        }
    }
}

