/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.Contribution;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryObject;
import org.eclipse.core.internal.registry.RegistryObjectManager;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionsParser
extends DefaultHandler {
    private static final String NO_EXTENSION_MUNGING = "eclipse.noExtensionMunging";
    private static final String VERSION_3_0 = "3.0";
    private static final String VERSION_3_2 = "3.2";
    private static Map extensionPointMap;
    private static long cumulativeTime;
    private boolean compatibilityMode;
    private String locationName = null;
    private Stack stateStack = new Stack();
    private Stack objectStack = new Stack();
    private String schemaVersion = null;
    private MultiStatus status;
    private ExtensionRegistry registry;
    protected ResourceBundle resources;
    private RegistryObjectManager objectManager;
    private Contribution contribution;
    private String configurationElementValue;
    public static final int PARSE_PROBLEM = 1;
    public static final String PLUGIN = "plugin";
    public static final String PLUGIN_ID = "id";
    public static final String PLUGIN_NAME = "name";
    public static final String FRAGMENT = "fragment";
    public static final String BUNDLE_UID = "id";
    public static final String EXTENSION_POINT = "extension-point";
    public static final String EXTENSION_POINT_NAME = "name";
    public static final String EXTENSION_POINT_ID = "id";
    public static final String EXTENSION_POINT_SCHEMA = "schema";
    public static final String EXTENSION = "extension";
    public static final String EXTENSION_NAME = "name";
    public static final String EXTENSION_ID = "id";
    public static final String EXTENSION_TARGET = "point";
    public static final String ELEMENT = "element";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_VALUE = "value";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int BUNDLE_STATE = 2;
    private static final int BUNDLE_EXTENSION_POINT_STATE = 5;
    private static final int BUNDLE_EXTENSION_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 10;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private ArrayList[] scratchVectors = new ArrayList[2];
    private Locator locator = null;
    private boolean extractNamespaces = false;
    private ArrayList processedExtensionIds = null;
    private ArrayList addedRegistryObjects = new ArrayList(5);

    static {
        ExtensionsParser.initializeExtensionPointMap();
        cumulativeTime = 0L;
    }

    private static void initializeExtensionPointMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>(13);
        hashMap.put("org.eclipse.ui.markerImageProvider", "org.eclipse.ui.ide.markerImageProvider");
        hashMap.put("org.eclipse.ui.markerHelp", "org.eclipse.ui.ide.markerHelp");
        hashMap.put("org.eclipse.ui.markerImageProviders", "org.eclipse.ui.ide.markerImageProviders");
        hashMap.put("org.eclipse.ui.markerResolution", "org.eclipse.ui.ide.markerResolution");
        hashMap.put("org.eclipse.ui.projectNatureImages", "org.eclipse.ui.ide.projectNatureImages");
        hashMap.put("org.eclipse.ui.resourceFilters", "org.eclipse.ui.ide.resourceFilters");
        hashMap.put("org.eclipse.ui.markerUpdaters", "org.eclipse.ui.editors.markerUpdaters");
        hashMap.put("org.eclipse.ui.documentProviders", "org.eclipse.ui.editors.documentProviders");
        hashMap.put("org.eclipse.ui.workbench.texteditor.markerAnnotationSpecification", "org.eclipse.ui.editors.markerAnnotationSpecification");
        hashMap.put("org.eclipse.help.browser", "org.eclipse.help.base.browser");
        hashMap.put("org.eclipse.help.luceneAnalyzer", "org.eclipse.help.base.luceneAnalyzer");
        hashMap.put("org.eclipse.help.webapp", "org.eclipse.help.base.webapp");
        hashMap.put("org.eclipse.help.support", "org.eclipse.ui.helpSupport");
        extensionPointMap = hashMap;
    }

    public ExtensionsParser(MultiStatus multiStatus, ExtensionRegistry extensionRegistry) {
        this.status = multiStatus;
        this.registry = extensionRegistry;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] cArray, int n, int n2) {
        int n3 = (Integer)this.stateStack.peek();
        if (n3 != 10) {
            return;
        }
        if (n3 == 10) {
            ConfigurationElement configurationElement = (ConfigurationElement)this.objectStack.peek();
            String string = new String(cArray, n, n2);
            if (this.configurationElementValue == null) {
                if (string.trim().length() != 0) {
                    this.configurationElementValue = string;
                }
            } else {
                this.configurationElementValue = String.valueOf(this.configurationElementValue) + string;
            }
            if (this.configurationElementValue != null) {
                configurationElement.setValue(this.configurationElementValue);
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String string, String string2, String string3) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                this.internalError(NLS.bind((String)RegistryMessages.parse_internalStack, (Object)string2));
                break;
            }
            case 2: {
                Extension[] extensionArray;
                this.stateStack.pop();
                ArrayList arrayList = this.scratchVectors[0];
                ArrayList arrayList2 = this.scratchVectors[1];
                int[] nArray = new int[2 + arrayList.size() + arrayList2.size()];
                int n = 2;
                if (arrayList.size() > 0) {
                    nArray[0] = arrayList.size();
                    extensionArray = arrayList.iterator();
                    while (extensionArray.hasNext()) {
                        nArray[n++] = ((RegistryObject)extensionArray.next()).getObjectId();
                    }
                    arrayList.clear();
                }
                if (arrayList2.size() > 0) {
                    extensionArray = this.fixRenamedExtensionPoints(arrayList2.toArray(new Extension[arrayList2.size()]));
                    nArray[1] = extensionArray.length;
                    int n2 = 0;
                    while (n2 < extensionArray.length) {
                        nArray[n++] = extensionArray[n2].getObjectId();
                        ++n2;
                    }
                    arrayList2.clear();
                }
                this.contribution.setRawChildren(nArray);
                break;
            }
            case 5: {
                if (!string2.equals(EXTENSION_POINT)) break;
                this.stateStack.pop();
                break;
            }
            case 6: {
                if (!string2.equals(EXTENSION)) break;
                this.stateStack.pop();
                Extension extension = (Extension)this.objectStack.pop();
                if (extension.getNamespaceIdentifier() == null) {
                    extension.setNamespaceIdentifier(this.contribution.getDefaultNamespace());
                }
                extension.setContributorId(this.contribution.getContributorId());
                this.scratchVectors[1].add(extension);
                break;
            }
            case 10: {
                this.stateStack.pop();
                this.configurationElementValue = null;
                ConfigurationElement configurationElement = (ConfigurationElement)this.objectStack.pop();
                String string4 = configurationElement.getValueAsIs();
                if (string4 != null) {
                    configurationElement.setValue(this.translate(string4).trim());
                }
                RegistryObject registryObject = (RegistryObject)this.objectStack.peek();
                int[] nArray = registryObject.getRawChildren();
                int n = nArray.length;
                int[] nArray2 = new int[n + 1];
                int n3 = 0;
                while (n3 < n) {
                    nArray2[n3] = nArray[n3];
                    ++n3;
                }
                nArray2[n] = configurationElement.getObjectId();
                registryObject.setRawChildren(nArray2);
                configurationElement.setParentId(registryObject.getObjectId());
                configurationElement.setParentType(registryObject instanceof ConfigurationElement ? (byte)1 : 2);
            }
        }
    }

    public void error(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.cleanup();
        this.logStatus(sAXParseException);
        throw sAXParseException;
    }

    private void cleanup() {
        Iterator iterator = this.addedRegistryObjects.iterator();
        while (iterator.hasNext()) {
            RegistryObject registryObject = (RegistryObject)iterator.next();
            if (registryObject instanceof ExtensionPoint) {
                String string = ((ExtensionPoint)registryObject).getUniqueIdentifier();
                this.objectManager.removeExtensionPoint(string);
                continue;
            }
            this.objectManager.remove(registryObject.getObjectId(), true);
        }
    }

    private void handleExtensionPointState(String string) {
        this.stateStack.push(new Integer(0));
        this.unknownElement(EXTENSION_POINT, string);
    }

    private void handleExtensionState(String string, Attributes attributes) {
        this.stateStack.push(new Integer(10));
        this.configurationElementValue = null;
        ConfigurationElement configurationElement = this.registry.getElementFactory().createConfigurationElement(this.contribution.shouldPersist());
        configurationElement.setContributorId(this.contribution.getContributorId());
        this.objectStack.push(configurationElement);
        configurationElement.setName(string);
        this.parseConfigurationElementAttributes(attributes);
        this.objectManager.add(configurationElement, true);
        this.addedRegistryObjects.add(configurationElement);
    }

    private void handleInitialState(String string, Attributes attributes) {
        this.compatibilityMode = attributes.getLength() > 0;
        this.stateStack.push(new Integer(2));
        this.objectStack.push(this.contribution);
    }

    private void handleBundleState(String string, Attributes attributes) {
        if (string.equals(EXTENSION_POINT)) {
            this.stateStack.push(new Integer(5));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (string.equals(EXTENSION)) {
            this.stateStack.push(new Integer(6));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        if (!this.compatibilityMode) {
            this.unknownElement(PLUGIN, string);
        }
    }

    private void logStatus(SAXParseException sAXParseException) {
        String string = sAXParseException.getSystemId();
        if (string == null) {
            string = this.locationName;
        }
        string = string == null ? "" : string.substring(1 + string.lastIndexOf("/"));
        String string2 = string.equals("") ? NLS.bind((String)RegistryMessages.parse_error, (Object)sAXParseException.getMessage()) : NLS.bind((String)RegistryMessages.parse_errorNameLineColumn, (Object[])new Object[]{string, Integer.toString(sAXParseException.getLineNumber()), Integer.toString(sAXParseException.getColumnNumber()), sAXParseException.getMessage()});
        this.error((IStatus)new Status(2, "org.eclipse.equinox.registry", 1, string2, (Throwable)sAXParseException));
    }

    public Contribution parseManifest(SAXParserFactory sAXParserFactory, InputSource inputSource, String string, RegistryObjectManager registryObjectManager, Contribution contribution, ResourceBundle resourceBundle) throws ParserConfigurationException, SAXException, IOException {
        Contribution contribution2;
        block7: {
            long l = 0L;
            this.resources = resourceBundle;
            this.objectManager = registryObjectManager;
            this.contribution = contribution;
            if (this.registry.debug()) {
                l = System.currentTimeMillis();
            }
            if (sAXParserFactory == null) {
                throw new SAXException(RegistryMessages.parse_xmlParserNotAvailable);
            }
            try {
                this.locationName = inputSource.getSystemId();
                if (this.locationName == null) {
                    this.locationName = string;
                }
                sAXParserFactory.setNamespaceAware(true);
                try {
                    sAXParserFactory.setFeature("http://xml.org/sax/features/string-interning", true);
                }
                catch (SAXException sAXException) {}
                sAXParserFactory.setValidating(false);
                sAXParserFactory.newSAXParser().parse(inputSource, (DefaultHandler)this);
                contribution2 = (Contribution)this.objectStack.pop();
                Object var9_9 = null;
                if (!this.registry.debug()) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var9_10 = null;
                    if (!this.registry.debug()) break block8;
                    System.out.println("Cumulative parse time so far : " + (cumulativeTime += System.currentTimeMillis() - l));
                }
                throw throwable;
            }
            System.out.println("Cumulative parse time so far : " + (cumulativeTime += System.currentTimeMillis() - l));
        }
        return contribution2;
    }

    private void parseConfigurationElementAttributes(Attributes attributes) {
        int n;
        ConfigurationElement configurationElement = (ConfigurationElement)this.objectStack.peek();
        int n2 = n = attributes != null ? attributes.getLength() : 0;
        if (n == 0) {
            configurationElement.setProperties(RegistryObjectManager.EMPTY_STRING_ARRAY);
            return;
        }
        String[] stringArray = new String[n * 2];
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3 * 2] = attributes.getLocalName(n3);
            stringArray[n3 * 2 + 1] = this.translate(attributes.getValue(n3));
            ++n3;
        }
        configurationElement.setProperties(stringArray);
        stringArray = null;
    }

    private void parseExtensionAttributes(Attributes attributes) {
        String string;
        Object object;
        Object object2;
        Extension extension = this.registry.getElementFactory().createExtension(this.contribution.shouldPersist());
        this.objectStack.push(extension);
        String string2 = null;
        String string3 = null;
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            object2 = attributes.getLocalName(n2);
            object = attributes.getValue(n2).trim();
            if (((String)object2).equals("name")) {
                extension.setLabel(this.translate((String)object));
            } else if (((String)object2).equals("id")) {
                int n3 = ((String)object).lastIndexOf(46);
                if (n3 != -1 && this.extractNamespaces) {
                    string2 = ((String)object).substring(n3 + 1);
                    string3 = ((String)object).substring(0, n3);
                } else {
                    string2 = object;
                    string3 = this.contribution.getDefaultNamespace();
                }
                extension.setSimpleIdentifier(string2);
                extension.setNamespaceIdentifier(string3);
            } else if (((String)object2).equals(EXTENSION_TARGET)) {
                String string4;
                if (((String)object).lastIndexOf(46) == -1) {
                    string = this.contribution.getDefaultNamespace();
                    string4 = String.valueOf(string) + '.' + (String)object;
                } else {
                    string4 = object;
                }
                extension.setExtensionPointIdentifier(string4);
            } else {
                this.unknownAttribute(EXTENSION, (String)object2);
            }
            ++n2;
        }
        if (extension.getExtensionPointIdentifier() == null) {
            this.missingAttribute(EXTENSION_TARGET, EXTENSION);
            this.stateStack.pop();
            this.stateStack.push(new Integer(0));
            this.objectStack.pop();
            return;
        }
        if (string2 != null && this.registry.debug()) {
            String string5 = String.valueOf(string3) + '.' + string2;
            object2 = this.registry.getExtension(string5);
            if (object2 != null) {
                object = this.contribution.getDefaultNamespace();
                String string6 = object2.getContributor().getName();
                string = NLS.bind((String)RegistryMessages.parse_duplicateExtension, (Object[])new String[]{object, string6, string5});
                this.registry.log((IStatus)new Status(2, "org.eclipse.equinox.registry", 0, string, null));
            } else if (this.processedExtensionIds != null) {
                object = this.processedExtensionIds.iterator();
                while (object.hasNext()) {
                    String string7;
                    if (!string5.equals(object.next())) continue;
                    string = string7 = this.contribution.getDefaultNamespace();
                    String string8 = NLS.bind((String)RegistryMessages.parse_duplicateExtension, (Object[])new String[]{string7, string, string5});
                    this.registry.log((IStatus)new Status(2, "org.eclipse.equinox.registry", 0, string8, null));
                    break;
                }
            }
            if (this.processedExtensionIds == null) {
                this.processedExtensionIds = new ArrayList(10);
            }
            this.processedExtensionIds.add(string5);
        }
        this.objectManager.add(extension, true);
        this.addedRegistryObjects.add(extension);
    }

    private void missingAttribute(String string, String string2) {
        if (this.locator == null) {
            this.internalError(NLS.bind((String)RegistryMessages.parse_missingAttribute, (Object)string, (Object)string2));
        } else {
            this.internalError(NLS.bind((String)RegistryMessages.parse_missingAttributeLine, (Object[])new String[]{string, string2, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void unknownAttribute(String string, String string2) {
        if (this.locator == null) {
            this.internalError(NLS.bind((String)RegistryMessages.parse_unknownAttribute, (Object)string, (Object)string2));
        } else {
            this.internalError(NLS.bind((String)RegistryMessages.parse_unknownAttributeLine, (Object[])new String[]{string, string2, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void unknownElement(String string, String string2) {
        if (this.locator == null) {
            this.internalError(NLS.bind((String)RegistryMessages.parse_unknownElement, (Object)string2, (Object)string));
        } else {
            this.internalError(NLS.bind((String)RegistryMessages.parse_unknownElementLine, (Object[])new String[]{string2, string, Integer.toString(this.locator.getLineNumber())}));
        }
    }

    private void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPoint extensionPoint = this.registry.getElementFactory().createExtensionPoint(this.contribution.shouldPersist());
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getLocalName(n2);
            String string2 = attributes.getValue(n2).trim();
            if (string.equals("name")) {
                extensionPoint.setLabel(this.translate(string2));
            } else if (string.equals("id")) {
                String string3;
                String string4;
                int n3 = string2.lastIndexOf(46);
                if (n3 != -1 && this.extractNamespaces) {
                    string4 = string2.substring(0, n3);
                    string3 = string2;
                } else {
                    string4 = this.contribution.getDefaultNamespace();
                    string3 = String.valueOf(string4) + '.' + string2;
                }
                extensionPoint.setUniqueIdentifier(string3);
                extensionPoint.setNamespace(string4);
            } else if (string.equals(EXTENSION_POINT_SCHEMA)) {
                extensionPoint.setSchema(string2);
            } else {
                this.unknownAttribute(EXTENSION_POINT, string);
            }
            ++n2;
        }
        if (extensionPoint.getSimpleIdentifier() == null || extensionPoint.getLabel() == null) {
            String string = extensionPoint.getSimpleIdentifier() == null ? "id" : "name";
            this.missingAttribute(string, EXTENSION_POINT);
            this.stateStack.pop();
            this.stateStack.push(new Integer(0));
            return;
        }
        if (!this.objectManager.addExtensionPoint(extensionPoint, true)) {
            if (this.registry.debug()) {
                String string = NLS.bind((String)RegistryMessages.parse_duplicateExtensionPoint, (Object)extensionPoint.getUniqueIdentifier(), (Object)this.contribution.getDefaultNamespace());
                this.registry.log((IStatus)new Status(4, "org.eclipse.equinox.registry", 0, string, null));
            }
            this.stateStack.pop();
            this.stateStack.push(new Integer(0));
            return;
        }
        if (extensionPoint.getNamespace() == null) {
            extensionPoint.setNamespace(this.contribution.getDefaultNamespace());
        }
        extensionPoint.setContributorId(this.contribution.getContributorId());
        this.addedRegistryObjects.add(extensionPoint);
        this.scratchVectors[0].add(extensionPoint);
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
        int n = 0;
        while (n <= 1) {
            this.scratchVectors[n] = new ArrayList();
            ++n;
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(string2, attributes);
                break;
            }
            case 2: {
                this.handleBundleState(string2, attributes);
                break;
            }
            case 5: {
                this.handleExtensionPointState(string2);
                break;
            }
            case 6: 
            case 10: {
                this.handleExtensionState(string2, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
                if (this.compatibilityMode) break;
                this.internalError(NLS.bind((String)RegistryMessages.parse_unknownTopElement, (Object)string2));
            }
        }
    }

    public void warning(SAXParseException sAXParseException) {
        this.logStatus(sAXParseException);
    }

    private void internalError(String string) {
        this.error((IStatus)new Status(2, "org.eclipse.equinox.registry", 1, string, null));
    }

    public void processingInstruction(String string, String string2) {
        if (string.equalsIgnoreCase("eclipse")) {
            this.schemaVersion = VERSION_3_0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "=\"");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!string3.equalsIgnoreCase("version")) continue;
                if (!stringTokenizer.hasMoreTokens()) break;
                this.schemaVersion = stringTokenizer.nextToken();
                break;
            }
            this.initializeExtractNamespace();
        }
    }

    public void error(IStatus iStatus) {
        this.status.add(iStatus);
    }

    protected String translate(String string) {
        return this.registry.translate(string, this.resources);
    }

    private Extension[] fixRenamedExtensionPoints(Extension[] extensionArray) {
        if (extensionArray == null || this.versionAtLeast(VERSION_3_0) || RegistryProperties.getProperty(NO_EXTENSION_MUNGING) != null) {
            return extensionArray;
        }
        int n = 0;
        while (n < extensionArray.length) {
            Extension extension = extensionArray[n];
            String string = extension.getExtensionPointIdentifier();
            String string2 = (String)extensionPointMap.get(string);
            if (string2 != null) {
                extension.setExtensionPointIdentifier(string2);
            }
            ++n;
        }
        return extensionArray;
    }

    private void initializeExtractNamespace() {
        this.extractNamespaces = new Boolean(this.versionAtLeast(VERSION_3_2));
    }

    private boolean versionAtLeast(String string) {
        if (this.schemaVersion == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.schemaVersion, ".");
        while (stringTokenizer.hasMoreTokens() && stringTokenizer2.hasMoreTokens()) {
            try {
                if (Integer.parseInt(stringTokenizer2.nextToken()) >= Integer.parseInt(stringTokenizer.nextToken())) continue;
                return false;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }
}

