/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.eworkbench;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.eworkbench.ApplicationDescriptor;
import org.eclipse.ercp.eworkbench.ApplicationRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.RegistryReader;

public class ApplicationRegistryReader
extends RegistryReader {
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_VIEWS = "views";
    public static final String ATT_LARGE = "large";
    public static final String ATT_NORMAL = "normal";
    public static final String ATT_STATUS = "status";
    private static final String ATT_ICON = "icon";
    private static final String ATT_VIEW_ID = "id";
    private static final String EXTENSION_POINT_VIEW = "org.eclipse.ui.views";
    private ApplicationRegistry registry;

    public ApplicationRegistryReader(ApplicationRegistry applicationRegistry) {
        this.registry = applicationRegistry;
    }

    private String getIconPath(String string, String string2) {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_VIEW);
        if (iExtensionPoint == null) {
            return null;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            if (iExtensionArray[n].getNamespaceIdentifier().equals(string)) {
                IConfigurationElement[] iConfigurationElementArray = iExtensionArray[n].getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    if (string2.equals(iConfigurationElementArray[n2].getAttribute(ATT_VIEW_ID))) {
                        return iConfigurationElementArray[n2].getAttribute(ATT_ICON);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    protected boolean readElement(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement.getName().equals(TAG_APPLICATION)) {
            try {
                ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(iConfigurationElement.getAttribute(ATT_VIEW_ID), iConfigurationElement);
                IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
                int n = 0;
                while (n < iConfigurationElementArray.length) {
                    if (iConfigurationElementArray[n].getName().equals(TAG_VIEWS)) {
                        String string = iConfigurationElementArray[n].getAttribute(ATT_NORMAL);
                        if (string != null) {
                            String string2 = this.getIconPath(applicationDescriptor.getPluginId(), string);
                            applicationDescriptor.setImage(iConfigurationElement.getNamespaceIdentifier(), string2);
                            applicationDescriptor.setViewId(ATT_NORMAL, string);
                        } else {
                            WorkbenchPlugin.log((String)"Unable to find normal view in application descriptor.");
                        }
                        string = iConfigurationElementArray[n].getAttribute(ATT_LARGE);
                        if (string != null) {
                            applicationDescriptor.setViewId(ATT_LARGE, string);
                        }
                        if ((string = iConfigurationElementArray[n].getAttribute(ATT_STATUS)) != null) {
                            applicationDescriptor.setViewId(ATT_STATUS, string);
                        }
                    }
                    ++n;
                }
                this.registry.addApplication(applicationDescriptor);
            }
            catch (CoreException coreException) {
                WorkbenchPlugin.log((String)"Unable to create application descriptor.", (IStatus)coreException.getStatus());
            }
            return true;
        }
        return false;
    }

    public void readApplications(IExtensionRegistry iExtensionRegistry) {
        this.readRegistry(iExtensionRegistry, "org.eclipse.ercp.eworkbench", "applications");
    }
}

