/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.UpdateManagerLogWriter;
import org.eclipse.update.internal.core.connection.ConnectionThreadManagerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

public class UpdateCore
extends Plugin {
    public static boolean DEBUG;
    public static boolean DEBUG_SHOW_INSTALL;
    public static boolean DEBUG_SHOW_PARSING;
    public static boolean DEBUG_SHOW_WARNINGS;
    public static boolean DEBUG_SHOW_CONFIGURATION;
    public static boolean DEBUG_SHOW_TYPE;
    public static boolean DEBUG_SHOW_WEB;
    public static boolean DEBUG_SHOW_IHANDLER;
    public static boolean DEBUG_SHOW_RECONCILER;
    public static String HTTP_PROXY_HOST;
    public static String HTTP_PROXY_PORT;
    public static String HTTP_PROXY_ENABLE;
    public static final String P_HTTP_HOST = "http.proxyHost";
    public static final String P_HTTP_PORT = "http.proxyPort";
    public static final String P_HTTP_PROXY = "http.proxySet";
    private static final String PREFIX = "org.eclipse.update.core";
    public static final String P_HISTORY_SIZE = "org.eclipse.update.core.historySize";
    public static final String P_CHECK_SIGNATURE = "org.eclipse.update.core.checkSignature";
    public static final String P_AUTOMATICALLY_CHOOSE_MIRROR = "org.eclipse.update.core.automaticallyChooseMirror";
    public static final String P_UPDATE_VERSIONS = "org.eclipse.update.core.updateVersions";
    public static final String EQUIVALENT_VALUE = "equivalent";
    public static final String COMPATIBLE_VALUE = "compatible";
    public static final String MAJOR_VALUE = "greaterOrEqual";
    public static int DEFAULT_HISTORY;
    protected static UpdateCore plugin;
    private static UpdateManagerLogWriter log;
    private static final String LOG_FILE = "install.log";
    protected ResourceBundle resourceBundle;
    protected BundleContext context;
    protected ServiceTracker pkgAdminTracker;
    static /* synthetic */ Class class$0;

    static {
        HTTP_PROXY_HOST = "org.eclipse.update.core.proxy.host";
        HTTP_PROXY_PORT = "org.eclipse.update.core.proxy.port";
        HTTP_PROXY_ENABLE = "org.eclipse.update.core.proxy.enable";
        DEFAULT_HISTORY = 100;
    }

    public static native int SISInstall(String var0);

    public static native int SISUninstall(int var0);

    public UpdateCore() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.context = bundleContext;
        DEBUG = this.getBooleanDebugOption("org.eclipse.update.core/debug", false);
        if (DEBUG) {
            DEBUG_SHOW_WARNINGS = this.getBooleanDebugOption("org.eclipse.update.core/debug/warning", false);
            DEBUG_SHOW_PARSING = this.getBooleanDebugOption("org.eclipse.update.core/debug/parsing", false);
            DEBUG_SHOW_INSTALL = this.getBooleanDebugOption("org.eclipse.update.core/debug/install", false);
            DEBUG_SHOW_CONFIGURATION = this.getBooleanDebugOption("org.eclipse.update.core/debug/configuration", false);
            DEBUG_SHOW_TYPE = this.getBooleanDebugOption("org.eclipse.update.core/debug/type", false);
            DEBUG_SHOW_WEB = this.getBooleanDebugOption("org.eclipse.update.core/debug/web", false);
            DEBUG_SHOW_IHANDLER = this.getBooleanDebugOption("org.eclipse.update.core/debug/installhandler", false);
            DEBUG_SHOW_RECONCILER = this.getBooleanDebugOption("org.eclipse.update.core/debug/reconciler", false);
        }
        try {
            File file = UpdateCore.getInstallLogFile();
            if (file != null) {
                log = new UpdateManagerLogWriter(file);
            }
        }
        catch (IOException iOException) {
            UpdateCore.warn("", iOException);
        }
        try {
            this.initProxySettings();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        JarContentReference.shutdown();
        Utilities.shutdown();
        if (log != null) {
            log.shutdown();
        }
        ConnectionThreadManagerFactory.getConnectionManager().shutdown();
        this.context = null;
        if (this.pkgAdminTracker != null) {
            this.pkgAdminTracker.close();
            this.pkgAdminTracker = null;
        }
        plugin = null;
        this.resourceBundle = null;
    }

    public static UpdateCore getPlugin() {
        return plugin;
    }

    public static UpdateCore getDefault() {
        return plugin;
    }

    private boolean getBooleanDebugOption(String string, boolean bl) {
        String string2 = Platform.getDebugOption((String)string);
        if (string2 == null) {
            return bl;
        }
        return string2.trim().equalsIgnoreCase("true");
    }

    public PackageAdmin getPackageAdmin() {
        if (this.pkgAdminTracker == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.pkgAdminTracker = new ServiceTracker(this.context, clazz.getName(), null);
            this.pkgAdminTracker.open();
        }
        return (PackageAdmin)this.pkgAdminTracker.getService();
    }

    public BundleContext getBundleContext() {
        return this.context;
    }

    public static void log(IStatus iStatus) {
        UpdateCore.getPlugin().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        UpdateCore.log("", throwable);
    }

    public static void log(String string, Throwable throwable) {
        IStatus iStatus = null;
        iStatus = throwable instanceof CoreException ? ((CoreException)throwable).getStatus() : Utilities.newCoreException(string, throwable).getStatus();
        if (iStatus != null) {
            UpdateCore.log(iStatus);
        }
    }

    public static void log(IInstallConfiguration iInstallConfiguration) {
        if (log != null) {
            log.log(iInstallConfiguration);
        }
    }

    public static void debug(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(UpdateCore.getPlugin().toString());
        stringBuffer.append("^");
        stringBuffer.append(Integer.toHexString(Thread.currentThread().hashCode()));
        stringBuffer.append(" ");
        stringBuffer.append(string);
        System.out.println(stringBuffer.toString());
    }

    public static void warn(String string) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (string != null) {
                string = "WARNING: " + string;
            }
            UpdateCore.log(string, null);
        }
    }

    public static void warn(String string, Throwable throwable) {
        if (DEBUG && DEBUG_SHOW_WARNINGS) {
            if (string != null) {
                string = "UPDATE MANAGER INFO: " + string;
            }
            UpdateCore.log(string, throwable);
        }
    }

    private static File getInstallLogFile() throws IOException {
        IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
        URL uRL = iPlatformConfiguration.getConfigurationLocation();
        if (uRL == null) {
            UpdateCore.warn("Unable to retrieve location for update manager log file");
            return null;
        }
        File file = null;
        if ("file".equalsIgnoreCase(uRL.getProtocol())) {
            File file2 = new File(uRL.getFile());
            file = new File(file2.getParentFile(), LOG_FILE);
        }
        return file;
    }

    public static boolean isPatch(IFeature iFeature) {
        IImport[] iImportArray = iFeature.getImports();
        int n = 0;
        while (n < iImportArray.length) {
            IImport iImport = iImportArray[n];
            if (iImport.isPatch()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void initProxySettings() {
        String string;
        String string2;
        String string3 = string2 = System.getProperty(P_HTTP_HOST) != null ? System.getProperty(P_HTTP_HOST) : this.getPluginPreferences().getString(HTTP_PROXY_HOST);
        if ("".equals(string2)) {
            string2 = null;
        }
        String string4 = string = System.getProperty(P_HTTP_PORT) != null ? System.getProperty(P_HTTP_PORT) : this.getPluginPreferences().getString(HTTP_PROXY_PORT);
        if ("".equals(string)) {
            string = null;
        }
        boolean bl = System.getProperty(P_HTTP_HOST) != null && System.getProperty(P_HTTP_PORT) != null ? true : this.getPluginPreferences().getBoolean(HTTP_PROXY_ENABLE);
        SiteManager.setHttpProxyInfo(bl, string2, string);
    }

    public static void s60LoadDll() {
        try {
            System.out.println("[Update Debug] before loading SISInstaller DLL.");
            System.loadLibrary("SISInstaller");
            System.out.println("[Update Debug] after  loading SISInstaller DLL.");
        }
        catch (Exception exception) {
            System.out.println("[Update Debug] Exception while calling System.loadLibrary().");
            exception.printStackTrace();
        }
    }
}

