/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IImport;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InstallAbortedException;
import org.eclipse.update.internal.configurator.UpdateURLDecoder;
import org.eclipse.update.internal.core.ExtendedSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.search.UpdatePolicy;
import org.eclipse.update.internal.search.UpdatesSearchCategory;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.search.EnvironmentFilter;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.search.UpdateSearchScope;

public class UpdateUtils {
    public static final String P_UPDATE_POLICY_URL = "updatePolicyURL";

    private UpdateUtils() {
    }

    public static String getPluginId() {
        return UpdateCore.getPlugin().getBundle().getSymbolicName();
    }

    public static void logException(Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        IStatus iStatus = null;
        if (throwable instanceof CoreException) {
            iStatus = ((CoreException)throwable).getStatus();
        } else {
            String string = throwable.getMessage();
            if (string == null) {
                string = throwable.toString();
            }
            iStatus = new Status(4, UpdateUtils.getPluginId(), 0, string, throwable);
        }
        UpdateUtils.log(iStatus);
    }

    public static void log(IStatus iStatus) {
        if (iStatus.getSeverity() != 1) {
            UpdateCore.getPlugin().getLog().log(iStatus);
        }
    }

    public static IFeature[] searchSite(String string, IConfiguredSite iConfiguredSite, boolean bl) throws CoreException {
        IFeatureReference[] iFeatureReferenceArray = null;
        iFeatureReferenceArray = bl ? iConfiguredSite.getConfiguredFeatures() : iConfiguredSite.getSite().getFeatureReferences();
        Vector<IFeature> vector = new Vector<IFeature>();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            IFeature iFeature = iFeatureReferenceArray[n].getFeature(null);
            String string2 = iFeature.getVersionedIdentifier().getIdentifier();
            if (string.equals(string2)) {
                vector.add(iFeature);
            }
            ++n;
        }
        return vector.toArray(new IFeature[vector.size()]);
    }

    public static IFeature[] getInstalledFeatures(IFeature iFeature) {
        return UpdateUtils.getInstalledFeatures(iFeature, true);
    }

    public static IFeature[] getInstalledFeatures(IFeature iFeature, boolean bl) {
        return UpdateUtils.getInstalledFeatures(iFeature.getVersionedIdentifier(), bl);
    }

    public static IFeature[] getInstalledFeatures(VersionedIdentifier versionedIdentifier, boolean bl) {
        Vector<IFeature> vector = new Vector<IFeature>();
        try {
            ILocalSite iLocalSite = SiteManager.getLocalSite();
            IInstallConfiguration iInstallConfiguration = iLocalSite.getCurrentConfiguration();
            IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
            String string = versionedIdentifier.getIdentifier();
            int n = 0;
            while (n < iConfiguredSiteArray.length) {
                IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
                IFeature[] iFeatureArray = UpdateUtils.searchSite(string, iConfiguredSite, bl);
                int n2 = 0;
                while (n2 < iFeatureArray.length) {
                    IFeature iFeature = iFeatureArray[n2];
                    vector.add(iFeature);
                    ++n2;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            UpdateUtils.logException(coreException);
        }
        return vector.toArray(new IFeature[vector.size()]);
    }

    public static IFeature getPatchedFeature(IFeature iFeature) {
        IImport[] iImportArray = iFeature.getImports();
        int n = 0;
        while (n < iImportArray.length) {
            IImport iImport = iImportArray[n];
            if (iImport.isPatch()) {
                VersionedIdentifier versionedIdentifier = iImport.getVersionedIdentifier();
                IFeature[] iFeatureArray = UpdateUtils.getInstalledFeatures(versionedIdentifier, false);
                int n2 = 0;
                while (n2 < iFeatureArray.length) {
                    if (versionedIdentifier.equals(iFeatureArray[n2].getVersionedIdentifier())) {
                        return iFeatureArray[n2];
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return null;
    }

    public static boolean isPatch(IFeature iFeature) {
        IImport[] iImportArray = iFeature.getImports();
        int n = 0;
        while (n < iImportArray.length) {
            IImport iImport = iImportArray[n];
            if (iImport.isPatch()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean isPatch(IFeature iFeature, IFeature iFeature2) {
        VersionedIdentifier versionedIdentifier = iFeature.getVersionedIdentifier();
        IImport[] iImportArray = iFeature2.getImports();
        int n = 0;
        while (n < iImportArray.length) {
            VersionedIdentifier versionedIdentifier2;
            IImport iImport = iImportArray[n];
            if (iImport.isPatch() && versionedIdentifier.equals(versionedIdentifier2 = iImport.getVersionedIdentifier())) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static IInstallConfiguration getBackupConfigurationFor(IFeature iFeature) {
        VersionedIdentifier versionedIdentifier = iFeature.getVersionedIdentifier();
        String string = "@" + versionedIdentifier.getIdentifier() + "_" + versionedIdentifier.getVersion();
        try {
            ILocalSite iLocalSite = SiteManager.getLocalSite();
            IInstallConfiguration[] iInstallConfigurationArray = iLocalSite.getPreservedConfigurations();
            int n = 0;
            while (n < iInstallConfigurationArray.length) {
                IInstallConfiguration iInstallConfiguration = iInstallConfigurationArray[n];
                if (iInstallConfiguration.getLabel().startsWith(string)) {
                    return iInstallConfiguration;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static boolean hasLicense(IFeature iFeature) {
        IURLEntry iURLEntry = iFeature.getLicense();
        if (iURLEntry == null) {
            return false;
        }
        String string = iURLEntry.getAnnotation();
        if (string == null) {
            return false;
        }
        return string.trim().length() > 0;
    }

    public static boolean hasOptionalFeatures(IFeatureReference iFeatureReference) {
        try {
            return UpdateUtils.hasOptionalFeatures(iFeatureReference.getFeature(null));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasOptionalFeatures(IFeature iFeature) {
        try {
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
            int n = 0;
            while (true) {
                if (n >= iIncludedFeatureReferenceArray.length) {
                    return false;
                }
                IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
                if (iIncludedFeatureReference.isOptional()) {
                    return true;
                }
                IFeature iFeature2 = iIncludedFeatureReference.getFeature(null);
                if (UpdateUtils.hasOptionalFeatures(iFeature2)) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    public static IFeature getLocalFeature(IConfiguredSite iConfiguredSite, IFeature iFeature) throws CoreException {
        IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getConfiguredFeatures();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            IFeatureReference iFeatureReference = iFeatureReferenceArray[n];
            VersionedIdentifier versionedIdentifier = iFeatureReference.getVersionedIdentifier();
            if (iFeature.getVersionedIdentifier().equals(versionedIdentifier)) {
                return iFeatureReference.getFeature(null);
            }
            ++n;
        }
        return null;
    }

    public static IConfiguredSite getConfigSite(IFeature iFeature, IInstallConfiguration iInstallConfiguration) throws CoreException {
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            if (iConfiguredSite.getSite().equals(iFeature.getSite())) {
                return iConfiguredSite;
            }
            ++n;
        }
        return null;
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration iInstallConfiguration, IInstallFeatureOperation iInstallFeatureOperation) {
        return UpdateUtils.getDefaultTargetSite(iInstallConfiguration, iInstallFeatureOperation, true);
    }

    public static IConfiguredSite getDefaultTargetSite(IInstallConfiguration iInstallConfiguration, IInstallFeatureOperation iInstallFeatureOperation, boolean bl) {
        IFeature iFeature = iInstallFeatureOperation.getOldFeature();
        IFeature iFeature2 = iInstallFeatureOperation.getFeature();
        if (iFeature != null) {
            try {
                return UpdateUtils.getConfigSite(iFeature, iInstallConfiguration);
            }
            catch (CoreException coreException) {
                UpdateUtils.logException(coreException);
                return null;
            }
        }
        String string = iFeature2.getVersionedIdentifier().getIdentifier();
        IConfiguredSite iConfiguredSite = UpdateUtils.getSiteWithFeature(iInstallConfiguration, string);
        if (iConfiguredSite != null) {
            return iConfiguredSite;
        }
        if (bl) {
            return UpdateUtils.getAffinitySite(iInstallConfiguration, iFeature2);
        }
        return null;
    }

    public static IConfiguredSite getAffinitySite(IInstallConfiguration iInstallConfiguration, IFeature iFeature) {
        String string = iFeature.getAffinityFeature();
        if (string != null) {
            IConfiguredSite iConfiguredSite = UpdateUtils.getSiteWithFeature(iInstallConfiguration, string);
            if (iConfiguredSite != null) {
                return iConfiguredSite;
            }
        } else {
            IFeature iFeature2 = UpdateUtils.getPatchedFeature(iFeature);
            if (iFeature2 != null) {
                return UpdateUtils.getSiteWithFeature(iInstallConfiguration, iFeature2.getVersionedIdentifier().getIdentifier());
            }
        }
        return null;
    }

    public static IConfiguredSite getSiteWithFeature(IInstallConfiguration iInstallConfiguration, String string) {
        if (string == null) {
            return null;
        }
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getFeatureReferences();
            int n2 = 0;
            while (n2 < iFeatureReferenceArray.length) {
                IFeatureReference iFeatureReference = iFeatureReferenceArray[n2];
                try {
                    IFeature iFeature = iFeatureReference.getFeature(null);
                    if (string.equals(iFeature.getVersionedIdentifier().getIdentifier())) {
                        return iConfiguredSite;
                    }
                }
                catch (CoreException coreException) {
                    UpdateUtils.logException(coreException);
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public static void collectOldFeatures(IFeature iFeature, IConfiguredSite iConfiguredSite, ArrayList arrayList) throws CoreException {
        IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
        int n = 0;
        while (n < iIncludedFeatureReferenceArray.length) {
            block6: {
                IFeature iFeature2;
                IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
                try {
                    iFeature2 = iIncludedFeatureReference.getFeature(null);
                }
                catch (CoreException coreException) {
                    if (!iIncludedFeatureReference.isOptional()) {
                        throw coreException;
                    }
                    break block6;
                }
                String string = iIncludedFeatureReference.getVersionedIdentifier().getIdentifier();
                IFeature[] iFeatureArray = UpdateUtils.searchSite(string, iConfiguredSite, true);
                int n2 = 0;
                while (n2 < iFeatureArray.length) {
                    IFeature iFeature3 = iFeatureArray[n2];
                    if (!iFeature3.equals(iFeature2)) {
                        arrayList.add(iFeature3);
                    }
                    ++n2;
                }
                UpdateUtils.collectOldFeatures(iFeature2, iConfiguredSite, arrayList);
            }
            ++n;
        }
    }

    public static UpdateSearchRequest createNewUpdatesRequest(IFeature[] iFeatureArray) {
        UpdateSearchScope updateSearchScope = new UpdateSearchScope();
        updateSearchScope.setUpdateMapURL(UpdateUtils.getUpdateMapURL());
        UpdatesSearchCategory updatesSearchCategory = new UpdatesSearchCategory();
        if (iFeatureArray != null) {
            updatesSearchCategory.setFeatures(iFeatureArray);
        }
        UpdateSearchRequest updateSearchRequest = new UpdateSearchRequest(updatesSearchCategory, updateSearchScope);
        updateSearchRequest.addFilter(new EnvironmentFilter());
        return updateSearchRequest;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isNestedChild(IInstallConfiguration iInstallConfiguration, IFeature iFeature) {
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        try {
            int n = 0;
            while (iConfiguredSiteArray != null && n < iConfiguredSiteArray.length) {
                IFeatureReference[] iFeatureReferenceArray = iConfiguredSiteArray[n].getConfiguredFeatures();
                int n2 = 0;
                while (iFeatureReferenceArray != null && n2 < iFeatureReferenceArray.length) {
                    IFeature iFeature2 = iFeatureReferenceArray[n2].getFeature(null);
                    IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature2.getIncludedFeatureReferences();
                    int n3 = 0;
                    while (iIncludedFeatureReferenceArray != null && n3 < iIncludedFeatureReferenceArray.length) {
                        IFeature iFeature3 = iIncludedFeatureReferenceArray[n3].getFeature(null);
                        if (iFeature.equals(iFeature3)) {
                            return true;
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasObsoletePatches(IFeature iFeature) {
        try {
            IIncludedFeatureReference[] iIncludedFeatureReferenceArray = iFeature.getIncludedFeatureReferences();
            int n = 0;
            while (true) {
                if (n >= iIncludedFeatureReferenceArray.length) {
                    return true;
                }
                IIncludedFeatureReference iIncludedFeatureReference = iIncludedFeatureReferenceArray[n];
                IFeature iFeature2 = iIncludedFeatureReference.getFeature(null);
                IConfiguredSite iConfiguredSite = iFeature2.getSite().getCurrentConfiguredSite();
                if (!iConfiguredSite.isConfigured(iFeature2) && !UpdateUtils.isPatchHappy(iFeature2)) {
                    return false;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public static boolean isPatchHappy(IFeature iFeature) throws CoreException {
        IAdaptable iAdaptable;
        IImport[] iImportArray = iFeature.getImports();
        IImport iImport = null;
        int n = 0;
        while (n < iImportArray.length) {
            iAdaptable = iImportArray[n];
            if (iAdaptable.isPatch()) {
                iImport = iAdaptable;
                break;
            }
            ++n;
        }
        if (iImport == null) {
            return false;
        }
        VersionedIdentifier versionedIdentifier = iImport.getVersionedIdentifier();
        iAdaptable = iFeature.getSite().getCurrentConfiguredSite();
        if (iAdaptable == null) {
            return false;
        }
        IFeatureReference[] iFeatureReferenceArray = iAdaptable.getConfiguredFeatures();
        int n2 = 0;
        while (n2 < iFeatureReferenceArray.length) {
            IFeatureReference iFeatureReference = iFeatureReferenceArray[n2];
            VersionedIdentifier versionedIdentifier2 = iFeatureReference.getVersionedIdentifier();
            if (versionedIdentifier2.getIdentifier().equals(versionedIdentifier.getIdentifier()) && versionedIdentifier2.getVersion().isGreaterThan(versionedIdentifier.getVersion())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static URL getUpdateMapURL() {
        Preferences preferences = UpdateCore.getPlugin().getPluginPreferences();
        String string = preferences.getString(P_UPDATE_POLICY_URL);
        if (string != null && string.length() > 0) {
            try {
                String string2 = UpdateURLDecoder.decode((String)string, (String)"UTF-8");
                return new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return null;
    }

    public static IStatus loadUpdatePolicy(UpdatePolicy updatePolicy, URL uRL, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.subTask(Messages.UpdateSearchRequest_loadingPolicy);
        try {
            updatePolicy.load(uRL, iProgressMonitor);
            iProgressMonitor.worked(1);
        }
        catch (CoreException coreException) {
            IStatus iStatus = coreException.getStatus();
            if (iStatus == null || iStatus.getCode() != 42) {
                throw coreException;
            }
            iProgressMonitor.worked(1);
            return iStatus;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static void downloadFeatureContent(IConfiguredSite var0, IFeature var1_1, IFeatureReference[] var2_2, IProgressMonitor var3_3) throws InstallAbortedException, CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 469->473)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void monitorWork(IProgressMonitor iProgressMonitor, int n) throws CoreException {
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(n);
            if (iProgressMonitor.isCanceled()) {
                String string = "download cancelled";
                throw new InstallAbortedException(string, null);
            }
        }
    }

    public static IFeature getIncludedFeature(IFeature iFeature, IFeatureReference iFeatureReference) throws CoreException {
        IFeature iFeature2 = null;
        if (iFeature.getSite() instanceof ExtendedSite) {
            iFeature2 = ((ExtendedSite)iFeature.getSite()).getLiteFeature(iFeatureReference.getVersionedIdentifier());
        }
        if (iFeature2 == null) {
            iFeature2 = iFeatureReference.getFeature((IProgressMonitor)new NullProgressMonitor());
        }
        return iFeature2;
    }
}

