/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class WorkbenchPreferenceNode
extends PreferenceNode
implements IPluginContribution {
    IConfigurationElement element;
    String nodeId;
    private ImageDescriptor imageDescriptor;

    public WorkbenchPreferenceNode(String string, IConfigurationElement iConfigurationElement) {
        super(string);
        this.element = iConfigurationElement;
    }

    public void createPage() {
        PreferencePage preferencePage;
        try {
            preferencePage = (PreferencePage)WorkbenchPlugin.createExtension(this.getConfigurationElement(), "class");
        }
        catch (CoreException coreException) {
            System.out.println("Error creating preference page extension");
            Object var1_2 = null;
            return;
        }
        preferencePage.setImageDescriptor(this.getImageDescriptor());
        preferencePage.setTitle(this.getLabelText());
        this.setPage((IPreferencePage)preferencePage);
    }

    private IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public String getLocalId() {
        return this.nodeId;
    }

    public String getPluginId() {
        return this.getConfigurationElement().getNamespace();
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public String getLabelText() {
        return this.getConfigurationElement().getAttribute("name");
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDescriptor != null) {
            return this.imageDescriptor;
        }
        String string = this.getConfigurationElement().getAttribute("icon");
        if (string != null) {
            String string2 = this.getConfigurationElement().getNamespace();
            this.imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin(string2, string);
        }
        return this.imageDescriptor;
    }
}

