/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.plugin;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.util.BundleUtility;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class AbstractUIPlugin
extends Plugin {
    private static final String FN_DIALOG_SETTINGS = "dialog_settings.xml";
    private ScopedPreferenceStore preferenceStore;
    private ImageRegistry imageRegistry = null;
    private BundleListener bundleListener;

    public AbstractUIPlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
    }

    public AbstractUIPlugin() {
    }

    protected ImageRegistry createImageRegistry() {
        if (Display.getCurrent() != null) {
            return new ImageRegistry(Display.getCurrent());
        }
        if (PlatformUI.isWorkbenchRunning()) {
            return new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
        throw new SWTError(22);
    }

    public ImageRegistry getImageRegistry() {
        if (this.imageRegistry == null) {
            this.imageRegistry = this.createImageRegistry();
            this.initializeImageRegistry(this.imageRegistry);
        }
        return this.imageRegistry;
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), this.getBundle().getSymbolicName());
        }
        return this.preferenceStore;
    }

    public IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    protected void initializeDefaultPreferences(IPreferenceStore iPreferenceStore) {
    }

    protected void initializeDefaultPluginPreferences() {
        this.loadPreferenceStore();
        this.initializeDefaultPreferences(this.getPreferenceStore());
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
    }

    protected void loadPreferenceStore() {
    }

    protected void savePreferenceStore() {
        this.savePluginPreferences();
    }

    public void startup() throws CoreException {
        super.startup();
    }

    public void shutdown() throws CoreException {
        super.shutdown();
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        final BundleContext bundleContext2 = bundleContext;
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                if (bundleEvent.getBundle() == AbstractUIPlugin.this.getBundle() && bundleEvent.getType() == 2) {
                    bundleContext2.removeBundleListener((BundleListener)this);
                }
            }
        };
        bundleContext.addBundleListener(this.bundleListener);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(BundleContext bundleContext) throws Exception {
        try {
            if (this.bundleListener != null) {
                bundleContext.removeBundleListener(this.bundleListener);
            }
            this.savePreferenceStore();
            this.preferenceStore = null;
            this.imageRegistry = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            super.stop(bundleContext);
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        super.stop(bundleContext);
    }

    public static ImageDescriptor imageDescriptorFromPlugin(String string, String string2) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException();
        }
        Bundle bundle = Platform.getBundle((String)string);
        if (!BundleUtility.isReady(bundle)) {
            return null;
        }
        URL uRL = BundleUtility.find(bundle, string2);
        if (uRL == null) {
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (uRL == null) {
            return null;
        }
        return ImageDescriptor.createFromURL((URL)uRL);
    }

    private IPath getStateLocationOrNull() {
        try {
            return this.getStateLocation();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }
}

