/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.core.runtime.internal.adaptor.BundleStopper;
import org.eclipse.core.runtime.internal.adaptor.CachedManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorHook;
import org.eclipse.core.runtime.internal.adaptor.EclipseAdaptorMsg;
import org.eclipse.core.runtime.internal.adaptor.PluginConverterImpl;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.FrameworkAdaptor;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.framework.util.Headers;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.pluginconversion.PluginConversionException;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class EclipseStorageHook
implements StorageHook,
HookConfigurator {
    private static final String PROP_CHECK_CONFIG = "osgi.checkConfiguration";
    private static final int STORAGE_VERION = 2;
    public static final String KEY;
    public static final int HASHCODE;
    private static final byte FLAG_AUTO_START = 1;
    private static final byte FLAG_HAS_PACKAGE_INFO = 2;
    private static final byte FLAG_ACTIVATE_ON_CLASSLOAD = 4;
    private long manifestTimeStamp = 0L;
    private byte manifestType = 0;
    private BaseData bundledata;
    private String pluginClass = null;
    private String[] autoStartExceptions;
    private String buddyList;
    private String registeredBuddyList;
    private byte flags = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.runtime.internal.adaptor.EclipseStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
    }

    public int getStorageVersion() {
        return 2;
    }

    public StorageHook create(BaseData baseData) throws BundleException {
        EclipseStorageHook eclipseStorageHook = new EclipseStorageHook();
        eclipseStorageHook.bundledata = baseData;
        return eclipseStorageHook;
    }

    public void initialize(Dictionary dictionary) throws BundleException {
        ManifestElement manifestElement;
        String string;
        String string2 = (String)dictionary.get("Eclipse-LazyStart");
        if (string2 == null) {
            string2 = (String)dictionary.get("Eclipse-AutoStart");
        }
        this.parseLazyStart(this, string2);
        this.pluginClass = (String)dictionary.get("Plugin-Class");
        this.buddyList = (String)dictionary.get("Eclipse-BuddyPolicy");
        this.registeredBuddyList = (String)dictionary.get("Eclipse-RegisterBuddy");
        if (EclipseStorageHook.hasPackageInfo(this.bundledata.getEntry("META-INF/MANIFEST.MF"))) {
            this.flags = (byte)(this.flags | 2);
        }
        if ((string = (String)dictionary.get("Generated-from")) != null && (manifestElement = ManifestElement.parseHeader("Generated-from", string)[0]) != null) {
            this.manifestTimeStamp = Long.parseLong(manifestElement.getValue());
            this.manifestType = Byte.parseByte(manifestElement.getAttribute("type"));
        }
    }

    public StorageHook load(BaseData baseData, DataInputStream dataInputStream) throws IOException {
        EclipseStorageHook eclipseStorageHook = new EclipseStorageHook();
        eclipseStorageHook.bundledata = baseData;
        eclipseStorageHook.flags = dataInputStream.readByte();
        int n = dataInputStream.readInt();
        eclipseStorageHook.autoStartExceptions = n > 0 ? new String[n] : null;
        int n2 = 0;
        while (n2 < n) {
            eclipseStorageHook.autoStartExceptions[n2] = dataInputStream.readUTF();
            ++n2;
        }
        eclipseStorageHook.buddyList = AdaptorUtil.readString(dataInputStream, false);
        eclipseStorageHook.registeredBuddyList = AdaptorUtil.readString(dataInputStream, false);
        eclipseStorageHook.pluginClass = AdaptorUtil.readString(dataInputStream, false);
        eclipseStorageHook.manifestTimeStamp = dataInputStream.readLong();
        eclipseStorageHook.manifestType = dataInputStream.readByte();
        return eclipseStorageHook;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        if (this.bundledata == null) {
            throw new IllegalStateException();
        }
        dataOutputStream.writeByte(this.flags & 0xFFFFFFFB);
        String[] stringArray = this.getAutoStartExceptions();
        if (stringArray == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                dataOutputStream.writeUTF(stringArray[n]);
                ++n;
            }
        }
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.getBuddyList());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.getRegisteredBuddyList());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.getPluginClass());
        dataOutputStream.writeLong(this.getManifestTimeStamp());
        dataOutputStream.writeByte(this.getManifestType());
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public boolean compare(KeyedElement keyedElement) {
        return keyedElement.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }

    public boolean isAutoStart() {
        return (this.flags & 1) == 1;
    }

    public String[] getAutoStartExceptions() {
        return this.autoStartExceptions;
    }

    public String getBuddyList() {
        return this.buddyList;
    }

    public boolean hasPackageInfo() {
        return (this.flags & 2) == 2;
    }

    public String getPluginClass() {
        return this.pluginClass;
    }

    public String getRegisteredBuddyList() {
        return this.registeredBuddyList;
    }

    public long getManifestTimeStamp() {
        return this.manifestTimeStamp;
    }

    public byte getManifestType() {
        return this.manifestType;
    }

    public boolean isAutoStartable() {
        return this.isAutoStart() || this.autoStartExceptions != null && this.autoStartExceptions.length > 0;
    }

    private void parseLazyStart(EclipseStorageHook eclipseStorageHook, String string) {
        String string2;
        Object object;
        eclipseStorageHook.autoStartExceptions = null;
        ManifestElement[] manifestElementArray = null;
        try {
            manifestElementArray = ManifestElement.parseHeader("Eclipse-LazyStart", string);
        }
        catch (BundleException bundleException) {
            object = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CLASSLOADER_CANNOT_GET_HEADERS, eclipseStorageHook.bundledata.getLocation());
            this.bundledata.getAdaptor().getFrameworkLog().log(new FrameworkLogEntry("org.eclipse.osgi", 4, 0, (String)object, 0, bundleException, null));
        }
        if (manifestElementArray == null) {
            return;
        }
        if ("true".equalsIgnoreCase(manifestElementArray[0].getValue())) {
            this.flags = (byte)(this.flags | 1);
        }
        if ((string2 = manifestElementArray[0].getAttribute("exceptions")) == null) {
            return;
        }
        object = new StringTokenizer(string2, ",");
        int n = ((StringTokenizer)object).countTokens();
        eclipseStorageHook.autoStartExceptions = new String[n];
        int n2 = 0;
        while (n2 < n) {
            eclipseStorageHook.autoStartExceptions[n2] = ((StringTokenizer)object).nextToken().trim();
            ++n2;
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean hasPackageInfo(URL var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [4 : 134->137)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addStorageHook(this);
    }

    private void checkTimeStamp() throws IllegalArgumentException {
        if (!this.checkManifestTimeStamp()) {
            throw new IllegalArgumentException();
        }
    }

    private boolean checkManifestTimeStamp() {
        if (!"true".equalsIgnoreCase(FrameworkProperties.getProperty(PROP_CHECK_CONFIG))) {
            return true;
        }
        if (PluginConverterImpl.getTimeStamp(this.bundledata.getBundleFile().getBaseFile(), this.getManifestType()) == this.getManifestTimeStamp()) {
            if ((this.getManifestType() & 9) != 0) {
                return true;
            }
            String string = FrameworkProperties.getProperty("osgi.manifest.cache");
            Location location = LocationManager.getConfigurationLocation().getParentLocation();
            if (location != null) {
                try {
                    return this.checkManifestAndParent(string, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.getManifestType()) != null;
                }
                catch (BundleException bundleException) {
                    return false;
                }
            }
            File file = new File(string, String.valueOf(this.bundledata.getSymbolicName()) + '_' + this.bundledata.getVersion() + ".MF");
            if (file.isFile()) {
                return true;
            }
        }
        return false;
    }

    private Headers checkManifestAndParent(String string, String string2, String string3, byte by) throws BundleException {
        Headers headers = this.basicCheckManifest(string, string2, string3, by);
        if (headers != null) {
            return headers;
        }
        Location location = null;
        location = LocationManager.getConfigurationLocation().getParentLocation();
        if (location != null) {
            headers = this.basicCheckManifest(new File(location.getURL().getFile(), "org.eclipse.osgi/manifests").toString(), string2, string3, by);
        }
        return headers;
    }

    private Headers basicCheckManifest(String string, String string2, String string3, byte by) throws BundleException {
        File file = new File(string, String.valueOf(string2) + '_' + string3 + ".MF");
        if (PluginConverterImpl.upToDate(file, this.bundledata.getBundleFile().getBaseFile(), by)) {
            try {
                return Headers.parseManifest(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    Dictionary createCachedManifest(boolean bl) throws BundleException {
        return bl ? this.getGeneratedManifest() : new CachedManifest(this);
    }

    public Dictionary getGeneratedManifest() throws BundleException {
        Dictionary dictionary = AdaptorUtil.loadManifestFrom(this.bundledata);
        if (dictionary != null) {
            Dictionary dictionary2;
            if (!this.isComplete(dictionary) && (dictionary2 = this.generateManifest(dictionary)) != null) {
                return dictionary2;
            }
            this.manifestType = 1;
            if (this.bundledata.getBundleFile().getBaseFile().isFile()) {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getBaseFile().lastModified();
                this.manifestType = (byte)(this.manifestType | 8);
            } else {
                this.manifestTimeStamp = this.bundledata.getBundleFile().getEntry("META-INF/MANIFEST.MF").getTime();
            }
            return dictionary;
        }
        Dictionary dictionary3 = this.generateManifest(null);
        if (dictionary3 == null) {
            throw new BundleException(NLS.bind(EclipseAdaptorMsg.ECLIPSE_DATA_MANIFEST_NOT_FOUND, this.bundledata.getLocation()));
        }
        return dictionary3;
    }

    private Dictionary generateManifest(Dictionary dictionary) throws BundleException {
        Object object;
        Dictionary dictionary2;
        Object object2;
        String string = FrameworkProperties.getProperty("osgi.manifest.cache");
        if (this.bundledata.getSymbolicName() != null && (object2 = this.checkManifestAndParent(string, this.bundledata.getSymbolicName(), this.bundledata.getVersion().toString(), this.manifestType)) != null) {
            return object2;
        }
        object2 = PluginConverterImpl.getDefault();
        if (object2 == null) {
            object2 = new PluginConverterImpl(this.bundledata.getAdaptor(), this.bundledata.getAdaptor().getContext());
        }
        try {
            dictionary2 = ((PluginConverterImpl)object2).convertManifest(this.bundledata.getBundleFile().getBaseFile(), true, null, true, null);
        }
        catch (PluginConversionException pluginConversionException) {
            String string2 = NLS.bind(EclipseAdaptorMsg.ECLIPSE_CONVERTER_ERROR_CONVERTING, this.bundledata.getBundleFile().getBaseFile());
            throw new BundleException(string2, pluginConversionException);
        }
        Version version = Version.parseVersion((String)dictionary2.get("Bundle-Version"));
        String string3 = ManifestElement.parseHeader("Bundle-SymbolicName", (String)dictionary2.get("Bundle-SymbolicName"))[0].getValue();
        ManifestElement manifestElement = ManifestElement.parseHeader("Generated-from", (String)dictionary2.get("Generated-from"))[0];
        Headers headers = this.checkManifestAndParent(string, string3, version.toString(), Byte.parseByte(manifestElement.getAttribute("type")));
        this.manifestTimeStamp = Long.parseLong(manifestElement.getValue());
        this.manifestType = Byte.parseByte(manifestElement.getAttribute("type"));
        if (this.bundledata.getAdaptor().isReadOnly() || headers != null) {
            return headers;
        }
        if (dictionary != null) {
            object = dictionary.keys();
            while (object.hasMoreElements()) {
                Object k = object.nextElement();
                dictionary2.put(k, dictionary.get(k));
            }
        }
        object = new File(string, String.valueOf(string3) + '_' + version.toString() + ".MF");
        try {
            ((PluginConverterImpl)object2).writeManifest((File)object, dictionary2, true);
        }
        catch (Exception exception) {}
        return dictionary2;
    }

    private boolean isComplete(Dictionary dictionary) {
        if (dictionary.get("Bundle-SymbolicName") != null) {
            return true;
        }
        return this.bundledata.getEntry("plugin.xml") == null && this.bundledata.getEntry("fragment.xml") == null;
    }

    public BaseData getBaseData() {
        return this.bundledata;
    }

    public void copy(StorageHook storageHook) {
    }

    public void validate() throws IllegalArgumentException {
        this.checkTimeStamp();
    }

    public FrameworkAdaptor getAdaptor() {
        if (this.bundledata != null) {
            return this.bundledata.getAdaptor();
        }
        return null;
    }

    public Dictionary getManifest(boolean bl) throws BundleException {
        return this.createCachedManifest(bl);
    }

    public boolean forgetStatusChange(int n) {
        if (!this.isAutoStartable()) {
            return false;
        }
        if (!this.isActivatedOnClassLoad()) {
            BundleStopper bundleStopper = EclipseStorageHook.getBundleStopper(this.bundledata);
            return bundleStopper == null ? false : bundleStopper.isStopping();
        }
        return true;
    }

    public boolean forgetStartLevelChange(int n) {
        return false;
    }

    public boolean matchDNChain(String string) {
        return false;
    }

    void setActivatedOnClassLoad(boolean bl) {
        this.flags = bl ? (byte)(this.flags | 4) : (byte)(this.flags & 0xFFFFFFFB);
    }

    boolean isActivatedOnClassLoad() {
        return (this.flags & 4) == 4;
    }

    static BundleStopper getBundleStopper(BaseData baseData) {
        AdaptorHook[] adaptorHookArray = baseData.getAdaptor().getHookRegistry().getAdaptorHooks();
        int n = 0;
        while (n < adaptorHookArray.length) {
            if (adaptorHookArray[n] instanceof EclipseAdaptorHook) {
                return ((EclipseAdaptorHook)adaptorHookArray[n]).getBundleStopper();
            }
            ++n;
        }
        return null;
    }
}

