/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.FileBundleEntry;
import org.eclipse.osgi.internal.baseadaptor.AdaptorMsg;
import org.eclipse.osgi.util.NLS;

public class DirBundleFile
extends BundleFile {
    public DirBundleFile(File file) throws IOException {
        super(file);
        if (!BundleFile.secureAction.exists(file) || !BundleFile.secureAction.isDirectory(file)) {
            throw new IOException(NLS.bind(AdaptorMsg.ADAPTOR_DIRECTORY_EXCEPTION, file));
        }
    }

    public File getFile(String string, boolean bl) {
        File file = new File(this.basefile, string);
        if (BundleFile.secureAction.exists(file)) {
            return file;
        }
        return null;
    }

    public BundleEntry getEntry(String string) {
        File file = new File(this.basefile, string);
        if (!BundleFile.secureAction.exists(file)) {
            return null;
        }
        return new FileBundleEntry(file, string);
    }

    public boolean containsDir(String string) {
        File file = new File(this.basefile, string);
        return BundleFile.secureAction.exists(file) && BundleFile.secureAction.isDirectory(file);
    }

    public Enumeration getEntryPaths(final String string) {
        final File file = new File(this.basefile, string);
        if (!BundleFile.secureAction.exists(file)) {
            return null;
        }
        if (BundleFile.secureAction.isDirectory(file)) {
            final String[] stringArray = BundleFile.secureAction.list(file);
            if (stringArray == null || stringArray.length == 0) {
                return null;
            }
            final String string2 = string.length() == 0 || string.charAt(string.length() - 1) == '/' ? string : String.valueOf(string) + '/';
            return new Enumeration(){
                int cur = 0;

                public boolean hasMoreElements() {
                    return stringArray != null && this.cur < stringArray.length;
                }

                public Object nextElement() {
                    if (!this.hasMoreElements()) {
                        throw new NoSuchElementException();
                    }
                    File file2 = new File(file, stringArray[this.cur]);
                    StringBuffer stringBuffer = new StringBuffer(string2).append(stringArray[this.cur++]);
                    if (BundleFile.secureAction.isDirectory(file2)) {
                        stringBuffer.append("/");
                    }
                    return stringBuffer.toString();
                }
            };
        }
        return new Enumeration(){
            int cur = 0;

            public boolean hasMoreElements() {
                return this.cur < 1;
            }

            public Object nextElement() {
                if (this.cur == 0) {
                    this.cur = 1;
                    return string;
                }
                throw new NoSuchElementException();
            }
        };
    }

    public void close() {
    }

    public void open() {
    }
}

