/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkConsole;
import org.eclipse.osgi.framework.internal.core.Util;
import org.osgi.framework.Bundle;

public class FrameworkCommandInterpreter
implements CommandInterpreter {
    private StringTokenizer tok;
    private Object[] commandProviders;
    private FrameworkConsole con;
    private PrintWriter out;
    private String tab = "\t";
    private String newline = "\r\n";
    private boolean firstCommand = true;
    protected static int maxLineCount;
    protected int currentLineCount;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public FrameworkCommandInterpreter(String string, Object[] objectArray, FrameworkConsole frameworkConsole) {
        this.tok = new StringTokenizer(string);
        this.commandProviders = objectArray;
        this.con = frameworkConsole;
        this.out = frameworkConsole.getWriter();
    }

    public String nextArgument() {
        if (this.tok == null || !this.tok.hasMoreElements()) {
            return null;
        }
        String string = this.tok.nextToken();
        int n = string.indexOf(34);
        if (n != -1) {
            if (n == string.lastIndexOf(34)) {
                string = String.valueOf(string) + this.tok.nextToken("\"");
            }
            StringBuffer stringBuffer = new StringBuffer(string);
            while (n != -1) {
                stringBuffer.deleteCharAt(n);
                string = stringBuffer.toString();
                n = string.indexOf(34);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public Object execute(String string) {
        Object object;
        if (!this.firstCommand) {
            return this.innerExecute(string);
        }
        this.firstCommand = false;
        this.resetLineCount();
        Object object2 = null;
        if (string.equalsIgnoreCase("more")) {
            try {
                this._more();
            }
            catch (Exception exception) {
                this.printStackTrace(exception);
            }
            return object2;
        }
        if (string.equalsIgnoreCase("disconnect") && this.con.getUseSocketStream()) {
            try {
                this._disconnect();
            }
            catch (Exception exception) {
                this.printStackTrace(exception);
            }
            return object2;
        }
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandInterpreter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class[] classArray2 = classArray;
        Object[] objectArray = new Object[]{this};
        boolean bl = false;
        int n = this.commandProviders.length;
        int n2 = 0;
        while (!bl && n2 < n) {
            try {
                object = this.commandProviders[n2];
                Method method = object.getClass().getMethod("_" + string, classArray2);
                object2 = method.invoke(object, objectArray);
                bl = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                bl = true;
                this.printStackTrace(invocationTargetException.getTargetException());
            }
            catch (Exception exception) {
                bl = true;
                this.printStackTrace(exception);
            }
            ++n2;
        }
        if (!bl) {
            n2 = 0;
            while (n2 < n) {
                try {
                    object = (CommandProvider)this.commandProviders[n2];
                    this.out.print(object.getHelp());
                    this.out.flush();
                }
                catch (Exception exception) {
                    this.printStackTrace(exception);
                }
                ++n2;
            }
            this.out.print(this.getHelp());
            this.out.flush();
        }
        return object2;
    }

    private Object innerExecute(String string) {
        FrameworkCommandInterpreter frameworkCommandInterpreter;
        String string2;
        if (string != null && string.length() > 0 && (string2 = (frameworkCommandInterpreter = new FrameworkCommandInterpreter(string, this.commandProviders, this.con)).nextArgument()) != null) {
            return frameworkCommandInterpreter.execute(string2);
        }
        return null;
    }

    private int getMaximumLinesToScroll() {
        return maxLineCount;
    }

    private void setMaximumLinesToScroll(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(ConsoleMsg.CONSOLE_LINES_TO_SCROLL_NEGATIVE_ERROR);
        }
        maxLineCount = n;
    }

    private void resetLineCount() {
        this.currentLineCount = 0;
    }

    private void printline(Object object) {
        this.print(object + this.newline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Object object) {
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.check4More();
            this.out.print(object);
            this.out.flush();
        }
    }

    public void println() {
        this.println("");
    }

    public void printStackTrace(Throwable throwable) {
        throwable.printStackTrace(this.out);
        Method[] methodArray = throwable.getClass().getMethods();
        int n = methodArray.length;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Throwable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Modifier.isPublic(method.getModifiers()) && method.getName().startsWith("get") && clazz2.isAssignableFrom(method.getReturnType()) && method.getParameterTypes().length == 0) {
                try {
                    Throwable throwable2 = (Throwable)method.invoke((Object)throwable, null);
                    if (throwable2 != null && throwable2 != throwable) {
                        this.out.println(ConsoleMsg.CONSOLE_NESTED_EXCEPTION);
                        this.printStackTrace(throwable2);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {}
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        if (object == null) {
            return;
        }
        PrintWriter printWriter = this.out;
        synchronized (printWriter) {
            this.check4More();
            this.printline(object);
            ++this.currentLineCount;
            this.currentLineCount += object.toString().length() / 80;
        }
    }

    public void printDictionary(Dictionary dictionary, String string) {
        if (dictionary == null) {
            return;
        }
        int n = dictionary.size();
        Object[] objectArray = new String[n];
        Enumeration enumeration = dictionary.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            objectArray[n2++] = (String)enumeration.nextElement();
        }
        Util.sort(objectArray);
        if (string != null) {
            this.println(string);
        }
        n2 = 0;
        while (n2 < n) {
            this.println(" " + (String)objectArray[n2] + " = " + dictionary.get(objectArray[n2]));
            ++n2;
        }
        this.println();
    }

    /*
     * Exception decompiling
     */
    public void printBundleResource(Bundle var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [1 : 97->103)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void check4More() {
        int n = this.getMaximumLinesToScroll();
        if (n > 0 && this.currentLineCount >= n) {
            this.out.print(ConsoleMsg.CONSOLE_MORE);
            this.out.flush();
            this.con.getInput();
            this.resetLineCount();
        }
    }

    public String getHelp() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.newline);
        stringBuffer.append(ConsoleMsg.CONSOLE_HELP_CONTROLLING_CONSOLE_HEADING);
        stringBuffer.append(this.newline);
        stringBuffer.append(this.tab);
        stringBuffer.append("more - ");
        stringBuffer.append(ConsoleMsg.CONSOLE_HELP_MORE);
        if (this.con.getUseSocketStream()) {
            stringBuffer.append(this.newline);
            stringBuffer.append(this.tab);
            stringBuffer.append("disconnect - ");
            stringBuffer.append(ConsoleMsg.CONSOLE_HELP_DISCONNECT);
        }
        return stringBuffer.toString();
    }

    public void _more() throws Exception {
        if (this.confirm(ConsoleMsg.CONSOLE_CONFIRM_MORE, true)) {
            int n = this.prompt(String.valueOf(this.newline) + ConsoleMsg.CONSOLE_MORE_ENTER_LINES, 24);
            this.setMaximumLinesToScroll(n);
        } else {
            this.setMaximumLinesToScroll(0);
        }
    }

    private void _disconnect() throws Exception {
        if (this.confirm(ConsoleMsg.CONSOLE_CONFIRM_DISCONNECT, true)) {
            this.con.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean confirm(String string, boolean bl) {
        Object object = this.out;
        synchronized (object) {
            if (string.length() > 0) {
                this.print(string);
            } else {
                this.print(ConsoleMsg.CONSOLE_CONFIRM);
            }
            this.print(" (" + ConsoleMsg.CONSOLE_CONFIRM_VALUES);
            if (bl) {
                this.print(String.valueOf(ConsoleMsg.CONSOLE_Y) + ") ");
            } else {
                this.print(String.valueOf(ConsoleMsg.CONSOLE_N) + ") ");
            }
        }
        object = this.con.getInput();
        this.resetLineCount();
        if (((String)object).length() == 0) {
            return bl;
        }
        return ((String)object).toLowerCase().charAt(0) == ConsoleMsg.CONSOLE_Y.charAt(0);
    }

    protected String prompt(String string, String string2) {
        CharSequence charSequence;
        if (string.length() > 0) {
            if (string2.length() > 0) {
                charSequence = new StringBuffer(256);
                ((StringBuffer)charSequence).append(string);
                ((StringBuffer)charSequence).append(" ");
                ((StringBuffer)charSequence).append(ConsoleMsg.CONSOLE_PROMPT_DEFAULT);
                ((StringBuffer)charSequence).append("=");
                ((StringBuffer)charSequence).append(string2);
                ((StringBuffer)charSequence).append(") ");
                this.print(((StringBuffer)charSequence).toString());
            } else {
                this.print(string);
            }
        }
        charSequence = this.con.getInput();
        this.resetLineCount();
        if (((String)charSequence).length() > 0) {
            return charSequence;
        }
        return string2;
    }

    protected int prompt(String string, int n) {
        Integer n2 = new Integer(n);
        int n3 = 0;
        while (n3 < 3) {
            String string2 = this.prompt(string, n2.toString());
            try {
                int n4 = Integer.parseInt(string2);
                if (n4 >= 0) {
                    return n4;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            this.println(ConsoleMsg.CONSOLE_INVALID_INPUT);
            ++n3;
        }
        this.println(ConsoleMsg.CONSOLE_TOO_MUCH_INVALID_INPUT);
        return n;
    }
}

