/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.osgi.framework.internal.core.ConsoleMsg;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandInterpreter;
import org.eclipse.osgi.framework.internal.core.FrameworkCommandProvider;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.OSGi;
import org.eclipse.osgi.framework.internal.core.Util;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class FrameworkConsole
implements Runnable {
    protected Reader in;
    protected PrintWriter out;
    protected BundleContext context;
    protected OSGi osgi;
    protected String[] args;
    protected CommandProvider osgicp;
    protected CommandProviderTracker cptracker;
    static String defaultEncoding = "iso8859-1";
    static String encoding = FrameworkProperties.getProperty("osgi.console.encoding", FrameworkProperties.getProperty("file.encoding", defaultEncoding));
    protected boolean useSocketStream = false;
    protected boolean disconnect = false;
    protected int port = 0;
    protected ServerSocket ss = null;
    protected ConsoleSocketGetter scsg = null;
    protected Socket s;
    static /* synthetic */ Class class$0;

    public FrameworkConsole(OSGi oSGi, String[] stringArray) {
        this.args = stringArray;
        this.osgi = oSGi;
        this.initialize();
    }

    public FrameworkConsole(OSGi oSGi, int n, String[] stringArray) {
        this.useSocketStream = true;
        this.port = n;
        this.args = stringArray;
        this.osgi = oSGi;
        this.initialize();
    }

    private void getDefaultStreams() {
        this.in = this.createBufferedReader(System.in);
        this.out = this.createPrintWriter(System.out);
    }

    private void getSocketStream(int n) {
        try {
            System.out.println(NLS.bind(ConsoleMsg.CONSOLE_LISTENING_ON_PORT, String.valueOf(n)));
            if (this.ss == null) {
                this.ss = new ServerSocket(n);
                this.scsg = new ConsoleSocketGetter(this.ss);
            }
            this.scsg.setAcceptConnections(true);
            this.s = this.scsg.getSocket();
            this.in = this.createBufferedReader(this.s.getInputStream());
            this.out = this.createPrintWriter(this.s.getOutputStream());
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private BufferedReader createBufferedReader(InputStream inputStream) {
        BufferedReader bufferedReader;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream, encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        }
        return bufferedReader;
    }

    private PrintWriter createPrintWriter(OutputStream outputStream) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream, encoding)), true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            printWriter = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(outputStream)), true);
        }
        return printWriter;
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public BufferedReader getReader() {
        return (BufferedReader)this.in;
    }

    public boolean getUseSocketStream() {
        return this.useSocketStream;
    }

    private void initialize() {
        this.getDefaultStreams();
        this.context = this.osgi.getBundleContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.framework.console.CommandProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.cptracker = new CommandProviderTracker(this.context, clazz.getName(), this);
        this.cptracker.open();
        this.osgicp = new FrameworkCommandProvider(this.osgi);
    }

    public void run() {
        try {
            this.console(this.args);
            if (this.useSocketStream) {
                while (true) {
                    this.getSocketStream(this.port);
                    this.console();
                }
            }
            this.getDefaultStreams();
            this.console();
        }
        catch (IOException iOException) {
            iOException.printStackTrace(this.out);
        }
    }

    public void console(String[] stringArray) throws IOException {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.docommand(stringArray[n]);
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void console() throws IOException {
        Object object = new Object();
        this.disconnect = false;
        BufferedReader bufferedReader = (BufferedReader)this.in;
        String string = "\r\n" + ConsoleMsg.CONSOLE_PROMPT;
        boolean bl = FrameworkProperties.getProperty("osgi.dev") != null || FrameworkProperties.getProperty("osgi.console.blockOnReady") != null;
        while (!this.disconnect) {
            this.out.print(string);
            this.out.flush();
            String string2 = null;
            if (bl && !this.useSocketStream) {
                try {
                    Object object2 = object;
                    synchronized (object2) {
                        while (!bufferedReader.ready()) {
                            object.wait(300L);
                        }
                    }
                    string2 = bufferedReader.readLine();
                }
                catch (InterruptedException interruptedException) {}
            } else {
                string2 = bufferedReader.readLine();
            }
            if (string2 == null) break;
            this.docommand(string2);
        }
    }

    protected void docommand(String string) {
        FrameworkCommandInterpreter frameworkCommandInterpreter;
        String string2;
        if (string != null && string.length() > 0 && (string2 = (frameworkCommandInterpreter = new FrameworkCommandInterpreter(string, this.cptracker.getServices(), this)).nextArgument()) != null) {
            frameworkCommandInterpreter.execute(string2);
        }
    }

    void disconnect() throws IOException {
        this.disconnect = true;
        this.out.close();
        this.in.close();
        this.s.close();
    }

    public String getInput() {
        String string;
        try {
            string = ((BufferedReader)this.in).readLine();
            System.out.println("<" + string + ">");
        }
        catch (IOException iOException) {
            string = "";
        }
        return string;
    }

    static /* synthetic */ PrintWriter access$0(FrameworkConsole frameworkConsole, OutputStream outputStream) {
        return frameworkConsole.createPrintWriter(outputStream);
    }

    class ConsoleSocketGetter
    implements Runnable {
        ServerSocket server;
        Socket socket;
        boolean acceptConnections = true;
        Object lock = new Object();

        ConsoleSocketGetter(ServerSocket serverSocket) {
            this.server = serverSocket;
            Thread thread = new Thread((Runnable)this, "ConsoleSocketGetter");
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            while (true) {
                try {
                    while (true) lbl-1000:
                    // 3 sources

                    {
                        this.socket = FrameworkConsole.this.ss.accept();
                        if (!this.acceptConnections) {
                            var1_1 = FrameworkConsole.access$0(FrameworkConsole.this, this.socket.getOutputStream());
                            var1_1.println(ConsoleMsg.CONSOLE_TELNET_CONNECTION_REFUSED);
                            var1_1.println(ConsoleMsg.CONSOLE_TELNET_CURRENTLY_USED);
                            var1_1.println(ConsoleMsg.CONSOLE_TELNET_ONE_CLIENT_ONLY);
                            var1_1.close();
                            this.socket.close();
                            continue;
                        }
                        var1_1 = this.lock;
                        synchronized (var1_1) {
                            this.lock.notify();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception var1_2) {
                    var1_2.printStackTrace();
                    continue;
                }
                {
                    ** while (true)
                }
                break;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Socket getSocket() throws InterruptedException {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait();
            }
            this.setAcceptConnections(false);
            return this.socket;
        }

        public void setAcceptConnections(boolean bl) {
            this.acceptConnections = bl;
        }
    }

    class CommandProviderTracker
    extends ServiceTracker {
        FrameworkConsole con;

        CommandProviderTracker(BundleContext bundleContext, String string, FrameworkConsole frameworkConsole2) {
            super(bundleContext, string, null);
            this.con = frameworkConsole2;
        }

        public Object addingService(ServiceReference serviceReference) {
            CommandProvider commandProvider = (CommandProvider)super.addingService(serviceReference);
            return commandProvider;
        }

        public Object[] getServices() {
            Object[] objectArray = super.getServiceReferences();
            Util.dsort(objectArray, 0, objectArray.length);
            Object[] objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = FrameworkConsole.this.context.getService((ServiceReference)objectArray[n]);
                ++n;
            }
            return objectArray2;
        }
    }
}

