/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.internal.core.DependentPolicy;
import org.eclipse.osgi.framework.internal.core.GlobalPolicy;
import org.eclipse.osgi.framework.internal.core.IBuddyPolicy;
import org.eclipse.osgi.framework.internal.core.RegisteredPolicy;
import org.eclipse.osgi.framework.internal.core.SystemPolicy;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;

public class PolicyHandler {
    private static final String DEPENDENT_POLICY = "dependent";
    private static final String GLOBAL_POLICY = "global";
    private static final String REGISTERED_POLICY = "registered";
    private static final String APP_POLICY = "app";
    private static final String EXT_POLICY = "ext";
    private static final String BOOT_POLICY = "boot";
    private static final String PARENT_POLICY = "parent";
    BundleLoader policedLoader;
    Object[] policies = null;
    private ThreadLocal beingLoaded;
    private BundleListener listener = new BundleListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getType() == 2 || bundleEvent.getType() == 4) {
                return;
            }
            try {
                String string = (String)PolicyHandler.this.policedLoader.getBundle().getBundleData().getManifest().get("Eclipse-BuddyPolicy");
                1 var3_3 = this;
                synchronized (var3_3) {
                    PolicyHandler.this.policies = PolicyHandler.getArrayFromList(string);
                }
            }
            catch (BundleException bundleException) {}
        }
    };

    public PolicyHandler(BundleLoader bundleLoader, String string) {
        this.policedLoader = bundleLoader;
        this.policies = PolicyHandler.getArrayFromList(string);
        this.beingLoaded = new ThreadLocal();
        this.policedLoader.bundle.framework.systemBundle.context.addBundleListener(this.listener);
    }

    static Object[] getArrayFromList(String string) {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("")) continue;
            vector.addElement(string2);
        }
        return vector.isEmpty() ? new Object[]{} : vector.toArray(new Object[vector.size()]);
    }

    private synchronized IBuddyPolicy getPolicyImplementation(int n) {
        if (this.policies[n] instanceof String) {
            String string = (String)this.policies[n];
            if (REGISTERED_POLICY.equals(string)) {
                this.policies[n] = new RegisteredPolicy(this.policedLoader);
                return (IBuddyPolicy)this.policies[n];
            }
            if (BOOT_POLICY.equals(string)) {
                this.policies[n] = SystemPolicy.getInstance((byte)0);
                return (IBuddyPolicy)this.policies[n];
            }
            if (APP_POLICY.equals(string)) {
                this.policies[n] = SystemPolicy.getInstance((byte)2);
                return (IBuddyPolicy)this.policies[n];
            }
            if (EXT_POLICY.equals(string)) {
                this.policies[n] = SystemPolicy.getInstance((byte)1);
                return (IBuddyPolicy)this.policies[n];
            }
            if (DEPENDENT_POLICY.equals(string)) {
                this.policies[n] = new DependentPolicy(this.policedLoader);
                return (IBuddyPolicy)this.policies[n];
            }
            if (GLOBAL_POLICY.equals(string)) {
                this.policies[n] = new GlobalPolicy(this.policedLoader.bundle.framework.packageAdmin);
                return (IBuddyPolicy)this.policies[n];
            }
            if (PARENT_POLICY.equals(string)) {
                this.policies[n] = new SystemPolicy(this.policedLoader.parent);
                return (IBuddyPolicy)this.policies[n];
            }
        }
        return (IBuddyPolicy)this.policies[n];
    }

    public Class doBuddyClassLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        Class clazz = null;
        int n = 0;
        while (n < this.policies.length && clazz == null) {
            clazz = this.getPolicyImplementation(n).loadClass(string);
            ++n;
        }
        this.stopLoading(string);
        return clazz;
    }

    public URL doBuddyResourceLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        if (this.policies == null) {
            return null;
        }
        URL uRL = null;
        int n = 0;
        while (n < this.policies.length && uRL == null) {
            uRL = this.getPolicyImplementation(n).loadResource(string);
            ++n;
        }
        this.stopLoading(string);
        return uRL;
    }

    public Enumeration doBuddyResourcesLoading(String string) {
        if (!this.startLoading(string)) {
            return null;
        }
        if (this.policies == null) {
            return null;
        }
        Vector vector = null;
        int n = 0;
        while (n < this.policies.length) {
            Enumeration enumeration = this.getPolicyImplementation(n).loadResources(string);
            if (enumeration != null) {
                if (vector == null) {
                    vector = new Vector(this.policies.length);
                }
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (vector.contains(e)) continue;
                    vector.add(e);
                }
            }
            ++n;
        }
        this.stopLoading(string);
        return vector == null || vector.isEmpty() ? null : vector.elements();
    }

    private boolean startLoading(String string) {
        HashSet<String> hashSet = (HashSet<String>)this.beingLoaded.get();
        if (hashSet != null && hashSet.contains(string)) {
            return false;
        }
        if (hashSet == null) {
            hashSet = new HashSet<String>(3);
            this.beingLoaded.set(hashSet);
        }
        hashSet.add(string);
        return true;
    }

    private void stopLoading(String string) {
        ((Set)this.beingLoaded.get()).remove(string);
    }

    public void close() {
        this.policedLoader.bundle.framework.systemBundle.context.removeBundleListener(this.listener);
    }
}

