/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.baseadaptor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Dictionary;
import java.util.Properties;
import org.eclipse.core.runtime.adaptor.LocationManager;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.adaptor.FilePath;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.baseadaptor.AdaptorUtil;
import org.eclipse.osgi.internal.baseadaptor.BaseStorage;
import org.eclipse.osgi.internal.baseadaptor.InvalidVersion;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BaseStorageHook
implements StorageHook,
AdaptorHook {
    public static final String KEY;
    public static final int HASHCODE;
    public static final int DEL_BUNDLE_STORE = 1;
    public static final int DEL_GENERATION = 2;
    private static final int STORAGE_VERSION = 1;
    private String fileName;
    private String[] nativePaths;
    private int generation = 1;
    private boolean reference;
    private BaseData bundleData;
    private BaseStorage storage;
    private File bundleStore;
    private File dataStore;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.baseadaptor.BaseStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
    }

    public BaseStorageHook(BaseStorage baseStorage) {
        this.storage = baseStorage;
    }

    public int getStorageVersion() {
        return 1;
    }

    public StorageHook create(BaseData baseData) throws BundleException {
        BaseStorageHook baseStorageHook = new BaseStorageHook(this.storage);
        baseStorageHook.bundleData = baseData;
        return baseStorageHook;
    }

    public void initialize(Dictionary dictionary) throws BundleException {
        BaseStorageHook.loadManifest(this.bundleData, dictionary);
    }

    static void loadManifest(BaseData baseData, Dictionary dictionary) throws BundleException {
        String string;
        try {
            baseData.setVersion(Version.parseVersion((String)dictionary.get("Bundle-Version")));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            baseData.setVersion(new InvalidVersion((String)dictionary.get("Bundle-Version")));
        }
        ManifestElement[] manifestElementArray = ManifestElement.parseHeader("Bundle-SymbolicName", (String)dictionary.get("Bundle-SymbolicName"));
        int n = 0;
        if (manifestElementArray != null) {
            baseData.setSymbolicName(manifestElementArray[0].getValue());
            string = manifestElementArray[0].getDirective("singleton");
            if (string == null) {
                string = manifestElementArray[0].getAttribute("singleton");
            }
            if ("true".equals(string)) {
                n |= 8;
            }
        }
        baseData.setClassPathString((String)dictionary.get("Bundle-ClassPath"));
        baseData.setActivator((String)dictionary.get("Bundle-Activator"));
        string = (String)dictionary.get("Fragment-Host");
        if (string != null) {
            n |= 1;
            ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader("Fragment-Host", string);
            if (Constants.getInternalSymbolicName().equals(manifestElementArray2[0].getValue()) || "system.bundle".equals(manifestElementArray2[0].getValue())) {
                String string2 = manifestElementArray2[0].getDirective("extension");
                n = string2 == null || string2.equals("framework") ? (n |= 2) : (n |= 4);
            }
        }
        baseData.setType(n);
        baseData.setExecutionEnvironment((String)dictionary.get("Bundle-RequiredExecutionEnvironment"));
        baseData.setDynamicImports((String)dictionary.get("DynamicImport-Package"));
    }

    public StorageHook load(BaseData baseData, DataInputStream dataInputStream) throws IOException {
        baseData.setLocation(AdaptorUtil.readString(dataInputStream, false));
        baseData.setSymbolicName(AdaptorUtil.readString(dataInputStream, false));
        baseData.setVersion(AdaptorUtil.loadVersion(dataInputStream));
        baseData.setActivator(AdaptorUtil.readString(dataInputStream, false));
        baseData.setClassPathString(AdaptorUtil.readString(dataInputStream, false));
        baseData.setExecutionEnvironment(AdaptorUtil.readString(dataInputStream, false));
        baseData.setDynamicImports(AdaptorUtil.readString(dataInputStream, false));
        baseData.setStartLevel(dataInputStream.readInt());
        baseData.setStatus(dataInputStream.readInt());
        baseData.setType(dataInputStream.readInt());
        baseData.setLastModified(dataInputStream.readLong());
        baseData.setDirty(false);
        BaseStorageHook baseStorageHook = new BaseStorageHook(this.storage);
        baseStorageHook.bundleData = baseData;
        baseStorageHook.generation = dataInputStream.readInt();
        baseStorageHook.reference = dataInputStream.readBoolean();
        baseStorageHook.setFileName(this.getAbsolute(baseStorageHook.reference, AdaptorUtil.readString(dataInputStream, false)));
        int n = dataInputStream.readInt();
        baseStorageHook.nativePaths = n > 0 ? new String[n] : null;
        int n2 = 0;
        while (n2 < n) {
            baseStorageHook.nativePaths[n2] = dataInputStream.readUTF();
            ++n2;
        }
        return baseStorageHook;
    }

    private String getAbsolute(boolean bl, String string) {
        if (!bl) {
            return string;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            return new FilePath(String.valueOf(this.storage.getInstallPath()) + string).toString();
        }
        return string;
    }

    public void save(DataOutputStream dataOutputStream) throws IOException {
        if (this.bundleData == null) {
            throw new IllegalStateException();
        }
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.bundleData.getLocation());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.bundleData.getSymbolicName());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.bundleData.getVersion().toString());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.bundleData.getActivator());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.bundleData.getClassPathString());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.bundleData.getExecutionEnvironment());
        AdaptorUtil.writeStringOrNull(dataOutputStream, this.bundleData.getDynamicImports());
        StorageHook[] storageHookArray = this.bundleData.getStorageHooks();
        boolean bl = false;
        int n = 0;
        while (n < storageHookArray.length && !bl) {
            bl = storageHookArray[n].forgetStartLevelChange(this.bundleData.getStartLevel());
            ++n;
        }
        dataOutputStream.writeInt(!bl ? this.bundleData.getStartLevel() : 1);
        n = 0;
        int n2 = 0;
        while (n2 < storageHookArray.length && n == 0) {
            n = storageHookArray[n2].forgetStatusChange(this.bundleData.getStatus()) ? 1 : 0;
            ++n2;
        }
        dataOutputStream.writeInt(n == 0 ? this.bundleData.getStatus() : 0xFFFFFFFE & this.bundleData.getStatus());
        dataOutputStream.writeInt(this.bundleData.getType());
        dataOutputStream.writeLong(this.bundleData.getLastModified());
        dataOutputStream.writeInt(this.getGeneration());
        dataOutputStream.writeBoolean(this.isReference());
        String string = this.isReference() ? new FilePath(this.storage.getInstallPath()).makeRelative(new FilePath(this.getFileName())) : this.getFileName();
        AdaptorUtil.writeStringOrNull(dataOutputStream, string);
        if (this.nativePaths == null) {
            dataOutputStream.writeInt(0);
        } else {
            dataOutputStream.writeInt(this.nativePaths.length);
            int n3 = 0;
            while (n3 < this.nativePaths.length) {
                dataOutputStream.writeUTF(this.nativePaths[n3]);
                ++n3;
            }
        }
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public boolean compare(KeyedElement keyedElement) {
        return keyedElement.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getGeneration() {
        return this.generation;
    }

    public String[] getNativePaths() {
        return this.nativePaths;
    }

    public void setNativePaths(String[] stringArray) {
        this.nativePaths = stringArray;
    }

    public boolean isReference() {
        return this.reference;
    }

    public File getBundleStore() {
        if (this.bundleStore == null) {
            this.bundleStore = new File(this.storage.getBundleStoreRoot(), String.valueOf(this.bundleData.getBundleID()));
        }
        return this.bundleStore;
    }

    public File getDataFile(String string) {
        if (this.dataStore == null) {
            this.dataStore = new File(this.getBundleStore(), "data");
        }
        if (string != null && !this.dataStore.exists() && (this.storage.isReadOnly() || !this.dataStore.mkdirs()) && Debug.DEBUG_GENERAL) {
            Debug.println("Unable to create bundle data directory: " + this.dataStore.getPath());
        }
        return string == null ? this.dataStore : new File(this.dataStore, string);
    }

    void delete(boolean bl, int n) throws IOException {
        File file = null;
        switch (n) {
            case 2: {
                file = this.getGenerationDir();
                break;
            }
            case 1: {
                file = this.getBundleStore();
            }
        }
        if (file != null && file.exists() && (bl || !AdaptorUtil.rm(file))) {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(file, ".delete"));
            fileOutputStream.close();
        }
    }

    File getGenerationDir() {
        return new File(this.getBundleStore(), String.valueOf(this.getGeneration()));
    }

    File getParentGenerationDir() {
        Location location = null;
        Location location2 = LocationManager.getConfigurationLocation();
        if (location2 != null && (location = location2.getParentLocation()) != null) {
            return new File(location.getURL().getFile(), "org.eclipse.osgi/bundles/" + this.bundleData.getBundleID() + '/' + this.getGeneration());
        }
        return null;
    }

    File createGenerationDir() {
        File file = this.getGenerationDir();
        if (!file.exists() && (this.storage.isReadOnly() || !file.mkdirs()) && Debug.DEBUG_GENERAL) {
            Debug.println("Unable to create bundle generation directory: " + file.getPath());
        }
        return file;
    }

    public void setReference(boolean bl) {
        this.reference = bl;
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.bundleData.setFileName(string);
    }

    public void copy(StorageHook storageHook) {
        if (!(storageHook instanceof BaseStorageHook)) {
            throw new IllegalArgumentException();
        }
        BaseStorageHook baseStorageHook = (BaseStorageHook)storageHook;
        this.bundleStore = baseStorageHook.bundleStore;
        this.dataStore = baseStorageHook.dataStore;
        this.generation = baseStorageHook.generation + 1;
    }

    public void validate() throws IllegalArgumentException {
    }

    public Dictionary getManifest(boolean bl) throws BundleException {
        return null;
    }

    public boolean forgetStatusChange(int n) {
        return false;
    }

    public boolean forgetStartLevelChange(int n) {
        return false;
    }

    public boolean matchDNChain(String string) {
        return false;
    }

    public void initialize(BaseAdaptor baseAdaptor) {
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String string) throws IOException {
        Bundle[] bundleArray = this.storage.getAdaptor().getContext().getBundles();
        AbstractBundle abstractBundle = null;
        int n = 0;
        while (n < bundleArray.length && abstractBundle == null) {
            if (string.equals(bundleArray[n].getLocation())) {
                abstractBundle = (AbstractBundle)bundleArray[n];
            }
            ++n;
        }
        if (abstractBundle == null) {
            return null;
        }
        BaseData baseData = (BaseData)abstractBundle.getBundleData();
        BaseStorageHook baseStorageHook = (BaseStorageHook)baseData.getStorageHook(KEY);
        return baseStorageHook.isReference() ? new URL("reference:file:" + baseStorageHook.getFileName()).openConnection() : null;
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public boolean matchDNChain(String string, String[] stringArray) {
        return false;
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    public BaseStorage getStorage() {
        return this.storage;
    }
}

