/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.internal.jobs.ThreadJob;
import org.eclipse.core.internal.jobs.Worker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;

class WorkerPool {
    private static final int BEST_BEFORE = 60000;
    private static final int MIN_THREADS = 1;
    private int busyThreads = 0;
    protected final ClassLoader defaultContextLoader;
    private JobManager manager;
    private int numThreads = 0;
    private int sleepingThreads = 0;
    private Worker[] threads = new Worker[10];

    protected WorkerPool(JobManager jobManager) {
        this.manager = jobManager;
        this.defaultContextLoader = Thread.currentThread().getContextClassLoader();
    }

    private synchronized void add(Worker worker) {
        int n = this.threads.length;
        if (this.numThreads + 1 > n) {
            Worker[] workerArray = new Worker[2 * n];
            System.arraycopy(this.threads, 0, workerArray, 0, n);
            this.threads = workerArray;
        }
        this.threads[this.numThreads++] = worker;
    }

    private synchronized void decrementBusyThreads() {
        if (--this.busyThreads < 0) {
            if (JobManager.DEBUG) {
                Assert.isTrue((boolean)false, (String)Integer.toString(this.busyThreads));
            }
            this.busyThreads = 0;
        }
    }

    protected void endJob(InternalJob internalJob, IStatus iStatus) {
        this.decrementBusyThreads();
        if (internalJob.getRule() != null && !(internalJob instanceof ThreadJob)) {
            this.manager.getLockManager().removeLockCompletely(Thread.currentThread(), internalJob.getRule());
        }
        this.manager.endJob(internalJob, iStatus, true);
        this.manager.implicitJobs.endJob(internalJob);
    }

    protected synchronized void endWorker(Worker worker) {
        if (this.remove(worker) && JobManager.DEBUG) {
            JobManager.debug("worker removed from pool: " + worker);
        }
    }

    private synchronized void incrementBusyThreads() {
        if (++this.busyThreads > this.numThreads) {
            if (JobManager.DEBUG) {
                Assert.isTrue((boolean)false, (String)(String.valueOf(Integer.toString(this.busyThreads)) + ',' + this.numThreads));
            }
            this.busyThreads = this.numThreads;
        }
    }

    protected synchronized void jobQueued() {
        if (this.sleepingThreads > 0) {
            this.notify();
            return;
        }
        if (this.busyThreads >= this.numThreads) {
            Worker worker = new Worker(this);
            this.add(worker);
            if (JobManager.DEBUG) {
                JobManager.debug("worker added to pool: " + worker);
            }
            worker.start();
            return;
        }
    }

    private synchronized boolean remove(Worker worker) {
        int n = 0;
        while (n < this.threads.length) {
            if (this.threads[n] == worker) {
                System.arraycopy(this.threads, n + 1, this.threads, n, this.numThreads - n - 1);
                this.threads[--this.numThreads] = null;
                return true;
            }
            ++n;
        }
        return false;
    }

    protected synchronized void shutdown() {
        this.notifyAll();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void sleep(long l) {
        ++this.sleepingThreads;
        --this.busyThreads;
        if (JobManager.DEBUG) {
            JobManager.debug("worker sleeping for: " + l + "ms");
        }
        try {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                if (JobManager.DEBUG) {
                    JobManager.debug("worker interrupted while waiting... :-|");
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            --this.sleepingThreads;
            ++this.busyThreads;
            throw throwable;
        }
        {
            Object var3_4 = null;
            --this.sleepingThreads;
            ++this.busyThreads;
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected InternalJob startJob(Worker var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [8 : 233->236)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

