/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.configuration.IActivity;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.internal.core.ConfigurationActivity;
import org.eclipse.update.internal.model.ConfigurationActivityModel;

public class UpdateManagerLogWriter {
    private File logFile = null;
    private Writer log = null;
    private static final String CONFIGURATION = "!CONFIGURATION";
    private static final String ACTIVITY = "!ACTIVITY";
    private static final String SUCCESS = "success";
    private static final String FAILURE = "failure";
    private static final String FEATURE_INSTALL = "feature-install";
    private static final String FEATURE_REMOVE = "feature-remove";
    private static final String SITE_INSTALL = "site-install";
    private static final String SITE_REMOVE = "site-remove";
    private static final String UNCONFIGURE = "feature-disable";
    private static final String CONFIGURE = "feature-enable";
    private static final String REVERT = "revert";
    private static final String RECONCILIATION = "reconciliation";
    private static final String PRESERVED = "preserve-configuration";
    private static final String UNKNOWN = "unknown";
    private static final String LINE_SEPARATOR;

    static {
        String string = System.getProperty("line.separator");
        LINE_SEPARATOR = string == null ? "\n" : string;
    }

    public UpdateManagerLogWriter(File file) {
        this.logFile = file;
        AppPlugin.warn("UPDATE MANAGER LOG Location: " + file.getAbsolutePath());
        if (!file.exists()) {
            this.initLog();
        }
    }

    private void initLog() {
        try {
            IPlatformConfiguration iPlatformConfiguration = ConfiguratorUtils.getCurrentPlatformConfiguration();
            IPlatformConfiguration.ISiteEntry[] iSiteEntryArray = iPlatformConfiguration.getConfiguredSites();
            IActivity[] iActivityArray = new ConfigurationActivity[iSiteEntryArray.length];
            int n = 0;
            while (n < iSiteEntryArray.length) {
                iActivityArray[n] = new ConfigurationActivity(3);
                ((ConfigurationActivityModel)((Object)iActivityArray[n])).setLabel(Platform.asLocalURL((URL)iSiteEntryArray[n].getURL()).toExternalForm());
                ((ConfigurationActivityModel)((Object)iActivityArray[n])).setDate(new Date());
                ((ConfigurationActivityModel)((Object)iActivityArray[n])).setStatus(0);
                ++n;
            }
            Date date = new Date(iPlatformConfiguration.getChangeStamp());
            this.safeWriteConfiguration(date, iActivityArray);
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeLogFile() throws IOException {
        try {
            if (this.log != null) {
                this.log.flush();
                this.log.close();
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.log = null;
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.log = null;
            return;
        }
    }

    public void log(IInstallConfiguration iInstallConfiguration) {
        this.safeWriteConfiguration(iInstallConfiguration.getCreationDate(), iInstallConfiguration.getActivities());
    }

    private void openLogFile() {
        try {
            this.log = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logFile.getAbsolutePath(), true), "UTF-8"));
        }
        catch (IOException iOException) {
            this.log = this.logForStream(System.err);
        }
    }

    private String getFormattedDate(Date date) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy kk:mm:ss.SS");
            return simpleDateFormat.format(date);
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }

    private Writer logForStream(OutputStream outputStream) {
        try {
            return new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new BufferedWriter(new OutputStreamWriter(outputStream));
        }
    }

    public synchronized void shutdown() {
        try {
            if (this.logFile != null) {
                this.closeLogFile();
                this.logFile = null;
            } else if (this.log != null) {
                Writer writer = this.log;
                this.log = null;
                writer.flush();
                writer.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void safeWriteConfiguration(Date date, IActivity[] iActivityArray) {
        if (this.logFile != null) {
            this.openLogFile();
        }
        if (this.log == null) {
            this.log = this.logForStream(System.err);
        }
        try {
            block14: {
                try {
                    block13: {
                        try {
                            this.write(date, iActivityArray);
                            Object var3_6 = null;
                            if (this.logFile == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var3_5 = null;
                            if (this.logFile != null) {
                                this.closeLogFile();
                                throw throwable;
                            }
                            this.log.flush();
                            throw throwable;
                        }
                        this.closeLogFile();
                        break block14;
                    }
                    this.log.flush();
                }
                catch (Exception exception) {
                    System.err.println("An exception occurred while writing to the update manager log:");
                    exception.printStackTrace(System.err);
                    System.err.println("Logging to the console instead.");
                    try {
                        this.log = this.logForStream(System.err);
                        this.write(date, iActivityArray);
                        this.log.flush();
                    }
                    catch (Exception exception2) {
                        System.err.println("An exception occurred while logging to the console:");
                        exception2.printStackTrace(System.err);
                    }
                }
            }
            Object var5_10 = null;
            this.log = null;
            return;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.log = null;
            throw throwable;
        }
    }

    private void write(Date date, IActivity[] iActivityArray) throws IOException {
        this.writeln();
        this.write(CONFIGURATION);
        this.writeSpace();
        this.write(String.valueOf(date.getTime()));
        this.writeSpace();
        this.write(date.toString());
        this.writeln();
        int n = 0;
        while (n < iActivityArray.length) {
            this.write(iActivityArray[n]);
            ++n;
        }
    }

    private void write(IActivity iActivity) throws IOException {
        this.write(ACTIVITY);
        this.writeSpace();
        this.write(String.valueOf(iActivity.getDate().getTime()));
        this.writeSpace();
        this.write(this.getFormattedDate(iActivity.getDate()));
        this.writeSpace();
        this.write(iActivity.getLabel());
        this.writeSpace();
        this.write(this.getAction(iActivity.getAction()));
        this.writeSpace();
        this.write(iActivity.getStatus() == 0 ? SUCCESS : FAILURE);
        this.writeln();
    }

    private String getAction(int n) {
        switch (n) {
            case 1: {
                return FEATURE_INSTALL;
            }
            case 2: {
                return FEATURE_REMOVE;
            }
            case 3: {
                return SITE_INSTALL;
            }
            case 4: {
                return SITE_REMOVE;
            }
            case 5: {
                return UNCONFIGURE;
            }
            case 6: {
                return CONFIGURE;
            }
            case 7: {
                return REVERT;
            }
            case 8: {
                return RECONCILIATION;
            }
            case 9: {
                return PRESERVED;
            }
        }
        return "unknown [" + n + "]";
    }

    private void writeln() throws IOException {
        this.write(LINE_SEPARATOR);
    }

    private void write(String string) throws IOException {
        if (string != null) {
            this.log.write(string);
        }
    }

    private void writeSpace() throws IOException {
        this.write(" ");
    }
}

