/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core.connection;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.connection.AbstractResponse;
import org.eclipse.update.internal.core.connection.TooManyOpenConnectionsException;

public class HttpResponse
extends AbstractResponse {
    protected URL url;
    protected InputStream in;
    protected long lastModified;
    protected long offset;

    protected HttpResponse(URL uRL) {
        this.url = uRL;
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            try {
                InputStream inputStream = this.connection.getInputStream();
                if (inputStream != null) {
                    this.in = new MonitoringInputStream(inputStream);
                }
            }
            catch (IOException iOException) {
                this.connection = null;
                throw iOException;
            }
            this.checkOffset();
        }
        return this.in;
    }

    /*
     * Unable to fully structure code
     */
    public InputStream getInputStream(IProgressMonitor var1_1) throws IOException, CoreException, TooManyOpenConnectionsException {
        if (this.in == null && this.url != null) {
            if (this.connection == null || this.offset > 0L) {
                this.connection = this.url.openConnection();
            }
            if (this.offset > 0L) {
                this.connection.setRequestProperty("Range", "bytes=" + this.offset + "-");
            }
            if (var1_1 != null) {
                try {
                    var2_2 = this.openStreamWithCancel(this.connection, var1_1);
                    if (var2_2 == null) ** GOTO lbl23
                    this.in = new MonitoringInputStream(var2_2);
                }
                catch (IOException var2_3) {
                    this.connection = null;
                    throw var2_3;
                }
            } else {
                try {
                    var2_4 = this.connection.getInputStream();
                    if (var2_4 != null) {
                        this.in = new MonitoringInputStream(var2_4);
                    }
                }
                catch (IOException var2_5) {
                    this.connection = null;
                    throw var2_5;
                }
            }
lbl23:
            // 3 sources

            this.checkOffset();
            if (this.in != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.in;
    }

    public long getContentLength() {
        if (this.connection != null) {
            return this.connection.getContentLength();
        }
        return 0L;
    }

    public int getStatusCode() {
        if (this.connection == null) {
            try {
                this.connection = this.url.openConnection();
            }
            catch (IOException iOException) {}
        }
        if (this.connection != null) {
            try {
                return ((HttpURLConnection)this.connection).getResponseCode();
            }
            catch (IOException iOException) {
                AppPlugin.warn("", iOException);
            }
        }
        return 200;
    }

    public String getStatusMessage() {
        if (this.connection != null) {
            try {
                return ((HttpURLConnection)this.connection).getResponseMessage();
            }
            catch (IOException iOException) {
                AppPlugin.warn("", iOException);
            }
        }
        return "";
    }

    public long getLastModified() {
        if (this.lastModified == 0L) {
            if (this.connection == null) {
                try {
                    this.connection = this.url.openConnection();
                }
                catch (IOException iOException) {}
            }
            if (this.connection != null) {
                this.lastModified = this.connection.getLastModified();
            }
        }
        return this.lastModified;
    }

    public void setOffset(long l) {
        this.offset = l;
    }

    private void checkOffset() throws IOException {
        if (this.offset == 0L) {
            return;
        }
        String string = this.connection.getHeaderField("Content-Range");
        if (string == null) {
            throw new IOException(Messages.HttpResponse_rangeExpected);
        }
        if (!string.startsWith("bytes " + this.offset + "-")) {
            throw new IOException(Messages.HttpResponse_wrongRange);
        }
    }

    private class MonitoringInputStream
    extends FilterInputStream {
        InputStream in;

        public MonitoringInputStream(InputStream inputStream) {
            super(inputStream);
            this.in = inputStream;
        }

        public int available() throws IOException {
            try {
                return super.available();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public void close() throws IOException {
            try {
                super.close();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public synchronized void reset() throws IOException {
            try {
                super.reset();
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public int read(byte[] byArray) throws IOException {
            try {
                return super.read(byArray);
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            try {
                return super.read(byArray, n, n2);
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }

        public long skip(long l) throws IOException {
            try {
                return super.skip(l);
            }
            catch (IOException iOException) {
                HttpResponse.this.connection = null;
                throw iOException;
            }
        }
    }
}

