/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IVerificationListener;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.FeatureOperation;
import org.eclipse.update.internal.operations.JobRoot;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperationListener;

public class InstallOperation
extends FeatureOperation
implements IInstallFeatureOperation {
    private IFeatureReference[] optionalFeatures;
    private IFeature[] unconfiguredOptionalFeatures;
    private IVerificationListener verifier;

    public InstallOperation(IConfiguredSite iConfiguredSite, IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, IFeature[] iFeatureArray, IVerificationListener iVerificationListener) {
        super(iConfiguredSite, iFeature);
        IFeature[] iFeatureArray2 = UpdateUtils.getInstalledFeatures(iFeature);
        if (iFeatureArray2.length > 0) {
            this.oldFeature = iFeatureArray2[0];
        }
        this.unconfiguredOptionalFeatures = iFeatureArray;
        this.optionalFeatures = iFeatureReferenceArray;
        this.verifier = iVerificationListener;
    }

    public IFeatureReference[] getOptionalFeatures() {
        return this.optionalFeatures;
    }

    public boolean execute(IProgressMonitor iProgressMonitor, IOperationListener iOperationListener) throws CoreException {
        boolean bl = false;
        if (this.oldFeature != null && this.feature.getVersionedIdentifier().equals(this.oldFeature.getVersionedIdentifier())) {
            bl = true;
        }
        this.setOptionalFeatures();
        if (this.optionalFeatures == null) {
            this.targetSite.install(this.feature, this.verifier, iProgressMonitor);
        } else {
            this.targetSite.install(this.feature, this.optionalFeatures, this.verifier, iProgressMonitor);
        }
        if (!bl && this.oldFeature != null) {
            IInstallConfiguration iInstallConfiguration;
            this.preserveOptionalState();
            boolean bl2 = InstallOperation.unconfigure(this.oldFeature, null);
            if (!bl2 && !UpdateUtils.isNestedChild(iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration(), this.oldFeature)) {
                String string = NLS.bind((String)Messages.OperationsManager_error_old, (Object[])new String[]{this.oldFeature.getLabel()});
                Status status = new Status(4, UpdateUtils.getPluginId(), 0, string, null);
                throw new CoreException((IStatus)status);
            }
        }
        return true;
    }

    private void preserveOptionalState() {
        if (this.unconfiguredOptionalFeatures == null) {
            return;
        }
        int n = 0;
        while (n < this.unconfiguredOptionalFeatures.length) {
            try {
                IFeature iFeature = UpdateUtils.getLocalFeature(this.targetSite, this.unconfiguredOptionalFeatures[n]);
                if (iFeature != null) {
                    this.targetSite.unconfigure(iFeature);
                }
            }
            catch (CoreException coreException) {}
            ++n;
        }
    }

    private void setOptionalFeatures() {
        try {
            if (this.optionalFeatures == null && UpdateUtils.hasOptionalFeatures(this.feature)) {
                JobRoot jobRoot = new JobRoot(this);
                IInstallConfiguration iInstallConfiguration = SiteManager.getLocalSite().getCurrentConfiguration();
                HashSet hashSet = new HashSet();
                boolean bl = this.oldFeature != null;
                boolean bl2 = UpdateUtils.isPatch(this.feature);
                FeatureHierarchyElement[] featureHierarchyElementArray = jobRoot.getElements();
                int n = 0;
                while (n < featureHierarchyElementArray.length) {
                    featureHierarchyElementArray[n].addCheckedOptionalFeatures(bl, bl2, iInstallConfiguration, hashSet);
                    ++n;
                }
                this.optionalFeatures = new IFeatureReference[hashSet.size()];
                hashSet.toArray(this.optionalFeatures);
                this.unconfiguredOptionalFeatures = jobRoot.getUnconfiguredOptionalFeatures(iInstallConfiguration, this.targetSite);
            }
        }
        catch (CoreException coreException) {
            UpdateUtils.logException(coreException);
        }
    }
}

