/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.operations.OperationsManager;
import org.eclipse.update.standalone.ScriptedCommand;

public class AddSiteCommand
extends ScriptedCommand {
    private ISite site;
    private File sitePath;

    public AddSiteCommand(String string) throws Exception {
        block6: {
            if (string != null) {
                this.sitePath = new File(string);
                if (!this.sitePath.exists()) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string}));
                }
                URL uRL = this.sitePath.toURL();
                this.site = SiteManager.getSite(uRL, null);
                if (this.site == null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_noSite, (Object[])new String[]{string}));
                }
                IConfiguredSite iConfiguredSite = this.site.getCurrentConfiguredSite();
                if (iConfiguredSite != null) {
                    throw new Exception(NLS.bind((String)Messages.Standalone_siteConfigured, (Object[])new String[]{string}));
                }
                break block6;
            }
            throw new Exception(Messages.Standalone_noSite3);
        }
    }

    public boolean run(IProgressMonitor iProgressMonitor) {
        IStatus iStatus = OperationsManager.getValidator().validatePlatformConfigValid();
        if (iStatus != null) {
            AppPlugin.log(iStatus);
            return false;
        }
        if (this.site == null) {
            return false;
        }
        try {
            IConfiguredSite iConfiguredSite = this.getConfiguration().createConfiguredSite(this.sitePath);
            this.getConfiguration().addConfiguredSite(iConfiguredSite);
            this.getConfiguration().getConfiguredSites();
            SiteManager.getLocalSite().save();
            return true;
        }
        catch (CoreException coreException) {
            AppPlugin.log(coreException);
            return false;
        }
    }
}

