/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.standalone;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.mirror.MirrorCommand;
import org.eclipse.update.standalone.AddSiteCommand;
import org.eclipse.update.standalone.DisableCommand;
import org.eclipse.update.standalone.EnableCommand;
import org.eclipse.update.standalone.InstallCommand;
import org.eclipse.update.standalone.ListFeaturesCommand;
import org.eclipse.update.standalone.RemoveSiteCommand;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.SearchCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;
import org.eclipse.update.standalone.UninstallCommand;
import org.eclipse.update.standalone.UpdateCommand;

public class CmdLineArgs {
    private HashMap options = new HashMap();

    public CmdLineArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length - 1) {
            String string;
            if ("-command".equals(stringArray[n])) {
                if (this.isValidCommand(stringArray[n + 1])) {
                    this.options.put("-command", stringArray[n + 1]);
                    ++n;
                } else {
                    StandaloneUpdateApplication.exceptionLogged();
                    AppPlugin.log(Utilities.newCoreException(String.valueOf(Messages.Standalone_invalidCmd) + stringArray[n + 1], null));
                    return;
                }
            }
            if (this.isValidParam(stringArray[n])) {
                this.options.put(stringArray[n], stringArray[n + 1]);
                ++n;
            }
            if ((string = (String)this.options.get("-to")) != null && string.startsWith("file:")) {
                try {
                    URL uRL = new URL(string);
                    this.options.put("-to", uRL.getFile());
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++n;
        }
    }

    private boolean isValidParam(String string) {
        return string.equals("-command") || string.equals("-version") || string.equals("-to") || string.equals("-from") || string.equals("-featureId") || string.equals("-verifyOnly") || string.equals("-mirrorURL");
    }

    private boolean isValidCommand(String string) {
        if (string == null) {
            return false;
        }
        return string.equals("install") || string.equals("enable") || string.equals("disable") || string.equals("search") || string.equals("update") || string.equals("mirror") || string.equals("uninstall") || string.equals("listFeatures") || string.equals("addSite") || string.equals("removeSite");
    }

    public ScriptedCommand getCommand() {
        String string;
        block13: {
            try {
                string = (String)this.options.get("-command");
                if (string != null) break block13;
                return null;
            }
            catch (Exception exception) {
                StandaloneUpdateApplication.exceptionLogged();
                AppPlugin.log(exception);
                return null;
            }
        }
        if (string.equals("install")) {
            return new InstallCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-from"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (string.equals("enable")) {
            return new EnableCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (string.equals("disable")) {
            return new DisableCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (string.equals("search")) {
            return new SearchCommand((String)this.options.get("-from"));
        }
        if (string.equals("update")) {
            return new UpdateCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-verifyOnly"));
        }
        if (string.equals("mirror")) {
            return new MirrorCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-from"), (String)this.options.get("-to"), (String)this.options.get("-mirrorURL"));
        }
        if (string.equals("uninstall")) {
            return new UninstallCommand((String)this.options.get("-featureId"), (String)this.options.get("-version"), (String)this.options.get("-to"), (String)this.options.get("-verifyOnly"));
        }
        if (string.equals("listFeatures")) {
            return new ListFeaturesCommand((String)this.options.get("-from"));
        }
        if (string.equals("addSite")) {
            return new AddSiteCommand((String)this.options.get("-from"));
        }
        if (string.equals("removeSite")) {
            return new RemoveSiteCommand((String)this.options.get("-to"));
        }
        return null;
    }
}

