/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.internal.content.ContentMessages;
import org.eclipse.core.internal.content.XMLContentDescriber;
import org.eclipse.core.internal.content.XMLRootHandler;
import org.eclipse.core.internal.runtime.RuntimeLog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLRootElementContentDescriber
extends XMLContentDescriber
implements IExecutableExtension {
    private static final String DTD_TO_FIND = "dtd";
    private static final String ELEMENT_TO_FIND = "element";
    private String dtdToFind = null;
    private String elementToFind = null;
    static /* synthetic */ Class class$0;

    private int checkCriteria(InputSource inputSource) throws IOException {
        XMLRootHandler xMLRootHandler = new XMLRootHandler(this.elementToFind != null);
        try {
            if (!xMLRootHandler.parseContents(inputSource)) {
                return 1;
            }
        }
        catch (SAXException sAXException) {
            return 1;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = ContentMessages.content_parserConfiguration;
            RuntimeLog.log((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, string, (Throwable)parserConfigurationException));
            throw new RuntimeException(string);
        }
        if (this.elementToFind != null && !this.elementToFind.equals(xMLRootHandler.getRootName())) {
            return 1;
        }
        if (this.dtdToFind != null && !this.dtdToFind.equals(xMLRootHandler.getDTD())) {
            return 1;
        }
        return 2;
    }

    public int describe(InputStream inputStream, IContentDescription iContentDescription) throws IOException {
        if (super.describe(inputStream, iContentDescription) == 0) {
            return 0;
        }
        inputStream.reset();
        return this.checkCriteria(new InputSource(inputStream));
    }

    public int describe(Reader reader, IContentDescription iContentDescription) throws IOException {
        if (super.describe(reader, iContentDescription) == 0) {
            return 0;
        }
        reader.reset();
        return this.checkCriteria(new InputSource(reader));
    }

    public void setInitializationData(IConfigurationElement iConfigurationElement, String string, Object object) throws CoreException {
        Object object2;
        if (object instanceof String) {
            this.elementToFind = (String)object;
        } else if (object instanceof Hashtable) {
            object2 = (Hashtable)object;
            this.dtdToFind = (String)((Hashtable)object2).get(DTD_TO_FIND);
            this.elementToFind = (String)((Hashtable)object2).get(ELEMENT_TO_FIND);
        }
        if (this.dtdToFind == null && this.elementToFind == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.runtime.content.XMLRootElementContentDescriber");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            object2 = NLS.bind((String)ContentMessages.content_badInitializationData, (Object)clazz.getName());
            throw new CoreException((IStatus)new Status(4, "org.eclipse.core.contenttype", 0, (String)object2, null));
        }
    }
}

