/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.Calendar;

import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.DateEditor;
import org.eclipse.ercp.swt.mobile.MultiPageDialog;
import org.eclipse.ercp.swt.samples.eswtdemo.Calendar.CalendarDataBaseEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CalendarEditEntryDialog
implements SelectionListener,
ModifyListener {
    MultiPageDialog dialog;
    Point pagesSize = new Point(230, 110);
    Canvas page1;
    RowLayout layout;
    int lastScrollBarSelection = 0;
    Text description;
    Text location;
    Combo timedCombo;
    DateEditor startdate;
    DateEditor enddate;
    DateEditor duration;
    CaptionedControl startdateCT;
    CaptionedControl enddateCT;
    CaptionedControl durationCT;
    Text notes;
    Command commandDelete;
    Command commandDone;
    CalendarDataBaseEntry calendardatabaseentry;
    boolean update = false;
    boolean isNewEntry;
    FocusListener focusListener = new FocusListener(){

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.widget == CalendarEditEntryDialog.this.description) {
                CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(CalendarEditEntryDialog.this.page1.getVerticalBar().getMinimum());
                CalendarEditEntryDialog.this.updateCanvas();
            } else if (focusEvent.widget == CalendarEditEntryDialog.this.duration) {
                CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(CalendarEditEntryDialog.this.page1.getVerticalBar().getMaximum());
                CalendarEditEntryDialog.this.updateCanvas();
            } else if (focusEvent.widget == CalendarEditEntryDialog.this.location || focusEvent.widget == CalendarEditEntryDialog.this.startdate || focusEvent.widget == CalendarEditEntryDialog.this.enddate || focusEvent.widget == CalendarEditEntryDialog.this.timedCombo) {
                Rectangle rectangle = ((Control)focusEvent.widget).getParent().getBounds();
                Rectangle rectangle2 = CalendarEditEntryDialog.this.page1.getClientArea();
                int n = CalendarEditEntryDialog.this.page1.getVerticalBar().getSelection();
                if (rectangle.y < n) {
                    CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(rectangle.y);
                    CalendarEditEntryDialog.this.updateCanvas();
                } else if (rectangle.y + rectangle.height > n + rectangle2.height) {
                    CalendarEditEntryDialog.this.page1.getVerticalBar().setSelection(rectangle.y);
                    CalendarEditEntryDialog.this.updateCanvas();
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    };
    SelectionListener scrollBarListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            if (selectionEvent.widget == CalendarEditEntryDialog.this.page1.getVerticalBar()) {
                CalendarEditEntryDialog.this.updateCanvas();
            }
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        }
    };

    public CalendarEditEntryDialog(Shell shell) {
        this.dialog = new MultiPageDialog(shell);
    }

    public boolean open(CalendarDataBaseEntry calendarDataBaseEntry, boolean bl) {
        this.calendardatabaseentry = calendarDataBaseEntry;
        this.isNewEntry = bl;
        this.update = !bl;
        this.dialog.setText(Messages.getString("CalendarEditEntryDialog.0"));
        Composite composite = this.dialog.createPage(Messages.getString("CalendarEditEntryDialog.1"), null);
        composite.setSize(this.pagesSize);
        this.page1 = new Canvas(composite, 512);
        this.page1.setSize(this.pagesSize);
        this.layout = new RowLayout();
        this.layout.type = 512;
        this.layout.wrap = false;
        this.page1.setLayout((Layout)this.layout);
        CaptionedControl captionedControl = new CaptionedControl((Composite)this.page1, 0x2000000);
        captionedControl.setText(Messages.getString("CalendarEditEntryDialog.3"));
        this.description = new Text((Composite)captionedControl, 4);
        this.description.setText(calendarDataBaseEntry.getDescription());
        CaptionedControl captionedControl2 = new CaptionedControl((Composite)this.page1, 0x2000000);
        captionedControl2.setText(Messages.getString("CalendarEditEntryDialog.4"));
        this.location = new Text((Composite)captionedControl2, 4);
        this.location.setText(calendarDataBaseEntry.getLocation());
        CaptionedControl captionedControl3 = new CaptionedControl((Composite)this.page1, 0x2000000);
        captionedControl3.setText(Messages.getString("CalendarEditEntryDialog.5"));
        this.timedCombo = new Combo((Composite)captionedControl3, 8);
        this.timedCombo.add(Messages.getString("CalendarEditEntryDialog.6"));
        this.timedCombo.add(Messages.getString("CalendarEditEntryDialog.7"));
        this.timedCombo.select(0);
        this.timedCombo.addSelectionListener((SelectionListener)this);
        this.startdateCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        this.startdateCT.setText(Messages.getString("CalendarEditEntryDialog.8"));
        this.startdate = new DateEditor((Composite)this.startdateCT, 0, 34);
        this.startdate.setDate(calendarDataBaseEntry.getStartDate());
        this.startdate.addModifyListener((ModifyListener)this);
        this.enddateCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        this.enddateCT.setText(Messages.getString("CalendarEditEntryDialog.9"));
        this.enddate = new DateEditor((Composite)this.enddateCT, 0, 34);
        this.enddate.setDate(calendarDataBaseEntry.getEndDate());
        this.enddate.addModifyListener((ModifyListener)this);
        this.durationCT = new CaptionedControl((Composite)this.page1, 0x2000000);
        this.durationCT.setText(Messages.getString("CalendarEditEntryDialog.10"));
        this.duration = new DateEditor((Composite)this.durationCT, 0, 36);
        long l = (calendarDataBaseEntry.getEndDate().getTime() - calendarDataBaseEntry.getStartDate().getTime()) / 1000L;
        if (this.VerifyDatesConsistencies(l)) {
            this.duration.setTime((int)l);
        } else {
            this.duration.setTime(0);
            this.enddate.setDate(calendarDataBaseEntry.getStartDate());
        }
        this.duration.addModifyListener((ModifyListener)this);
        this.description.addFocusListener(this.focusListener);
        this.location.addFocusListener(this.focusListener);
        this.timedCombo.addFocusListener(this.focusListener);
        this.startdate.addFocusListener(this.focusListener);
        this.enddate.addFocusListener(this.focusListener);
        this.duration.addFocusListener(this.focusListener);
        this.commandDelete = new Command((Control)composite.getShell(), 1, 2);
        this.commandDelete.setText(Messages.getString("CalendarEditEntryDialog.11"));
        this.commandDelete.addSelectionListener((SelectionListener)this);
        this.commandDone = new Command((Control)composite.getShell(), 7, 0);
        this.commandDone.setText(Messages.getString("CalendarEditEntryDialog.12"));
        this.commandDone.addSelectionListener((SelectionListener)this);
        this.page1.layout();
        Rectangle rectangle = this.getChildrenBounds((Composite)this.page1);
        Rectangle rectangle2 = this.page1.getClientArea();
        this.page1.getVerticalBar().setMaximum(rectangle.height);
        this.page1.getVerticalBar().setMinimum(0);
        this.page1.getVerticalBar().setThumb(rectangle2.height);
        this.page1.getVerticalBar().setPageIncrement(rectangle2.height);
        this.page1.getVerticalBar().setIncrement(rectangle2.height / 10);
        this.page1.getVerticalBar().addSelectionListener(this.scrollBarListener);
        Composite composite2 = this.dialog.createPage(Messages.getString("CalendarEditEntryDialog.13"), null);
        composite2.setSize(this.pagesSize);
        this.notes = new Text(composite2, 2048);
        this.notes.setBounds(0, 0, composite2.getBounds().width, composite2.getBounds().height);
        this.notes.setText(calendarDataBaseEntry.getNotes() != null ? calendarDataBaseEntry.getNotes() : "");
        this.dialog.setSelection(0);
        this.dialog.open();
        return this.update;
    }

    private Rectangle getChildrenBounds(Composite composite) {
        Rectangle rectangle = null;
        Control[] controlArray = this.page1.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (rectangle == null) {
                rectangle = new Rectangle(controlArray[n].getBounds().x, controlArray[n].getBounds().y, controlArray[n].getBounds().width, controlArray[n].getBounds().height);
            } else {
                rectangle.add(controlArray[n].getBounds());
            }
            ++n;
        }
        rectangle.y -= this.layout.marginTop;
        rectangle.height += this.layout.marginTop + this.layout.marginBottom;
        return rectangle;
    }

    private void updateCanvas() {
        int n = this.page1.getVerticalBar().getSelection();
        Rectangle rectangle = this.getChildrenBounds((Composite)this.page1);
        this.page1.scroll(rectangle.x, rectangle.y + (this.lastScrollBarSelection - n), rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        this.lastScrollBarSelection = n;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandDelete) {
            String string = this.isNewEntry ? Messages.getString("CalendarEditEntryDialog.16") : Messages.getString("CalendarEditEntryDialog.17");
            MessageBox messageBox = new MessageBox(this.dialog.getParent(), 292);
            messageBox.setMessage(string);
            if (messageBox.open() == 32) {
                this.update = false;
                this.quit();
            }
        } else if (selectionEvent.widget == this.commandDone) {
            this.update = true;
            this.updateEntry();
            this.quit();
        } else if (selectionEvent.widget == this.timedCombo) {
            if (this.timedCombo.getSelectionIndex() == 0) {
                this.startdateCT.setEnabled(true);
                this.enddateCT.setEnabled(true);
                this.durationCT.setEnabled(true);
            } else {
                this.startdateCT.setEnabled(false);
                this.enddateCT.setEnabled(false);
                this.durationCT.setEnabled(false);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    private void quit() {
        this.commandDelete.dispose();
        this.commandDone.dispose();
        this.dialog.close();
    }

    private void updateEntry() {
        this.calendardatabaseentry.setDescription(this.description.getText());
        this.calendardatabaseentry.setLocation(this.location.getText());
        this.calendardatabaseentry.setStartDate(this.startdate.getDate());
        this.calendardatabaseentry.setEndDate(this.enddate.getDate());
        this.calendardatabaseentry.setNotes(this.notes.getText());
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.startdate) {
            int n;
            int n2 = this.startdate.getTime();
            if (n2 + (n = this.duration.getTime()) < 86400) {
                this.enddate.setTime(n2 + n);
            } else {
                this.enddate.setTime(86399);
                this.duration.setTime(86399 - n2);
            }
        } else if (modifyEvent.widget == this.enddate) {
            int n = this.startdate.getTime();
            int n3 = this.enddate.getTime();
            int n4 = this.duration.getTime();
            if (n3 >= n) {
                this.duration.setTime(n3 - n);
            } else {
                n = n3 - n4;
                if (n >= 0) {
                    this.startdate.setTime(n);
                } else {
                    this.startdate.setTime(0);
                    this.duration.setTime(n3);
                }
            }
        } else if (modifyEvent.widget == this.duration) {
            int n = this.startdate.getTime();
            int n5 = this.enddate.getTime();
            int n6 = this.duration.getTime();
            n5 = n + n6;
            if (n5 < 86400) {
                this.enddate.setTime(n5);
            } else {
                this.enddate.setTime(86399);
                this.duration.setTime(86399 - n);
            }
        }
    }

    private boolean VerifyDatesConsistencies(long l) {
        boolean bl = true;
        if (l < 0L) {
            bl = false;
        }
        return bl;
    }
}

