/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook;

import java.util.Vector;
import org.eclipse.ercp.swt.mobile.CaptionedControl;
import org.eclipse.ercp.swt.mobile.Command;
import org.eclipse.ercp.swt.mobile.ConstrainedText;
import org.eclipse.ercp.swt.mobile.HyperLink;
import org.eclipse.ercp.swt.mobile.MobileDevice;
import org.eclipse.ercp.swt.mobile.Screen;
import org.eclipse.ercp.swt.mobile.ScreenEvent;
import org.eclipse.ercp.swt.mobile.ScreenListener;
import org.eclipse.ercp.swt.mobile.SortedList;
import org.eclipse.ercp.swt.mobile.TextExtension;
import org.eclipse.ercp.swt.samples.eswtdemo.Messages;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookDataBase;
import org.eclipse.ercp.swt.samples.eswtdemo.PhoneBook.PhoneBookEntry;
import org.eclipse.ercp.swt.samples.eswtdemo.ScrolledComposite;
import org.eclipse.ercp.swt.samples.eswtdemo.ShowCase;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PhoneBookShowCase
extends ShowCase
implements SelectionListener,
KeyListener,
TraverseListener,
ModifyListener,
PaintListener,
ControlListener {
    private PhoneBookDataBase phoneBookDataBase;
    private Shell shellDirectory;
    private SortedList listNameWidget;
    private boolean landscape;
    private boolean detailsOpened;
    private Image background;
    private Shell shellDetails;
    Label detailOrganization;
    Label detailPosition;
    HyperLink detailPhone;
    HyperLink detailMobile;
    HyperLink detailEmail;
    private ScrolledComposite entryScrollScreen;
    private Composite entryScreen;
    Text entryLastName;
    Text entryFirstName;
    Text entryCompany;
    Text entryJob;
    ConstrainedText entryTelephone;
    ConstrainedText entryMobile;
    TextExtension entryEMail;
    Command commandExitDirectory;
    Command commandExitDetails;
    Command commandEdit;
    Command commandNew;
    Command commandDelete;
    Command commandEntryScreenDone;
    Command commandBackDetails;
    Screen[] screens;
    RotationListener rotationListener;
    static /* synthetic */ Class class$0;

    public String getName() {
        return Messages.getString("PhoneBookShowCase.0");
    }

    public void paintControl(PaintEvent paintEvent) {
        if (this.background == null) {
            ImageData imageData = new ImageData(this.getClass().getResourceAsStream("/res/background.jpg"));
            ImageData imageData2 = imageData.scaledTo(this.entryScreen.getClientArea().width, this.entryScreen.getClientArea().height);
            this.background = new Image((Device)Display.getCurrent(), imageData2);
        }
        paintEvent.gc.drawImage(this.background, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height, paintEvent.x, paintEvent.y, paintEvent.width, paintEvent.height);
    }

    private void positionDirectory() {
        Rectangle rectangle = this.getComposite().getShell().getBounds();
        if (this.landscape) {
            int n = rectangle.x + 5;
            int n2 = rectangle.y + 5;
            int n3 = rectangle.width / 2 - 10;
            int n4 = rectangle.height - 10;
            this.shellDirectory.setBounds(n, n2, n3, n4);
        } else {
            this.shellDirectory.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void positionDetails() {
        Rectangle rectangle = this.getComposite().getShell().getBounds();
        if (this.landscape) {
            int n = rectangle.x + rectangle.width / 2 + 5;
            int n2 = rectangle.y + 5;
            int n3 = rectangle.width / 2 - 10;
            int n4 = rectangle.height - 10;
            this.shellDetails.setBounds(n, n2, n3, n4);
        } else {
            this.shellDetails.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void controlResized(ControlEvent controlEvent) {
        this.positionDirectory();
        this.positionDetails();
    }

    public void controlMoved(ControlEvent controlEvent) {
        this.positionDirectory();
        this.positionDetails();
    }

    public void show() {
        this.phoneBookDataBase = PhoneBookDataBase.getThePhoneBook();
        Rectangle rectangle = this.getComposite().getShell().getBounds();
        this.landscape = rectangle.width > 240 && rectangle.width > rectangle.height;
        this.shellDirectory = new Shell(this.getComposite().getShell(), 2080);
        this.shellDirectory.setText(Messages.getString("PhoneBookShowCase.2"));
        this.positionDirectory();
        this.shellDirectory.setLayout((Layout)new FillLayout());
        this.shellDirectory.addControlListener((ControlListener)this);
        this.listNameWidget = new SortedList((Composite)this.shellDirectory, 516, 1);
        this.listNameWidget.addSelectionListener((SelectionListener)this);
        this.listNameWidget.addKeyListener((KeyListener)this);
        this.listNameWidget.addTraverseListener((TraverseListener)this);
        Vector vector = this.phoneBookDataBase.getSurnameNameVector();
        int n = 0;
        while (n < vector.size()) {
            this.listNameWidget.add((String)vector.get(n));
            ++n;
        }
        this.shellDetails = new Shell(this.getComposite().getShell(), 2080);
        this.detailsOpened = false;
        this.shellDetails.setText(Messages.getString("PhoneBookShowCase.3"));
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        this.shellDetails.setLayout((Layout)rowLayout);
        this.shellDetails.addControlListener((ControlListener)this);
        CaptionedControl captionedControl = new CaptionedControl((Composite)this.shellDetails, 0);
        this.detailOrganization = new Label((Composite)captionedControl, 0);
        captionedControl.setText(Messages.getString("PhoneBookShowCase.4"));
        CaptionedControl captionedControl2 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailPosition = new Label((Composite)captionedControl2, 0);
        captionedControl2.setText(Messages.getString("PhoneBookShowCase.5"));
        CaptionedControl captionedControl3 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailPhone = new HyperLink((Composite)captionedControl3, 0, 4);
        captionedControl3.setText(Messages.getString("PhoneBookShowCase.6"));
        this.detailPhone.addKeyListener((KeyListener)this);
        CaptionedControl captionedControl4 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailMobile = new HyperLink((Composite)captionedControl4, 0, 4);
        captionedControl4.setText(Messages.getString("PhoneBookShowCase.7"));
        this.detailMobile.addKeyListener((KeyListener)this);
        CaptionedControl captionedControl5 = new CaptionedControl((Composite)this.shellDetails, 0x2000000);
        this.detailEmail = new HyperLink((Composite)captionedControl5, 0, 2);
        captionedControl5.setText(Messages.getString("PhoneBookShowCase.8"));
        this.detailEmail.addKeyListener((KeyListener)this);
        Composite composite = this.getComposite();
        this.entryScrollScreen = new ScrolledComposite(composite, 512);
        this.entryScrollScreen.setLayout((Layout)new FormLayout());
        this.entryScrollScreen.setBounds(composite.getClientArea());
        this.entryScreen = new Composite((Composite)this.entryScrollScreen, 0);
        Rectangle rectangle2 = this.entryScrollScreen.getClientArea();
        this.entryScreen.setSize(rectangle2.width, rectangle2.height);
        this.entryScreen.addPaintListener((PaintListener)this);
        Vector<CaptionedControl> vector2 = new Vector<CaptionedControl>();
        CaptionedControl captionedControl6 = new CaptionedControl(this.entryScreen, 0x2000800);
        captionedControl6.setText(Messages.getString("PhoneBookShowCase.9"));
        this.entryLastName = new Text((Composite)captionedControl6, 2048);
        this.entryLastName.addModifyListener((ModifyListener)this);
        vector2.add(captionedControl6);
        CaptionedControl captionedControl7 = new CaptionedControl(this.entryScreen, 0x2000000);
        captionedControl7.setText(Messages.getString("PhoneBookShowCase.10"));
        this.entryFirstName = new Text((Composite)captionedControl7, 2048);
        this.entryFirstName.addModifyListener((ModifyListener)this);
        vector2.add(captionedControl7);
        CaptionedControl captionedControl8 = new CaptionedControl(this.entryScreen, 0x2000000);
        captionedControl8.setText(Messages.getString("PhoneBookShowCase.11"));
        this.entryCompany = new Text((Composite)captionedControl8, 2048);
        vector2.add(captionedControl8);
        CaptionedControl captionedControl9 = new CaptionedControl(this.entryScreen, 0x2000000);
        captionedControl9.setText(Messages.getString("PhoneBookShowCase.12"));
        this.entryJob = new Text((Composite)captionedControl9, 2048);
        vector2.add(captionedControl9);
        CaptionedControl captionedControl10 = new CaptionedControl(this.entryScreen, 0x2000000);
        captionedControl10.setText(Messages.getString("PhoneBookShowCase.13"));
        this.entryTelephone = new ConstrainedText((Composite)captionedControl10, 2048, 4);
        vector2.add(captionedControl10);
        CaptionedControl captionedControl11 = new CaptionedControl(this.entryScreen, 0x2000000);
        captionedControl11.setText(Messages.getString("PhoneBookShowCase.14"));
        this.entryMobile = new ConstrainedText((Composite)captionedControl11, 2048, 4);
        vector2.add(captionedControl11);
        CaptionedControl captionedControl12 = new CaptionedControl(this.entryScreen, 0x2000000);
        captionedControl12.setText(Messages.getString("PhoneBookShowCase.15"));
        this.entryEMail = new TextExtension((Composite)captionedControl12, 2048, 2);
        vector2.add(captionedControl12);
        Point point = captionedControl6.computeSize(this.entryScreen.getClientArea().width, -1);
        Point point2 = new Point(0, 0);
        int n2 = 2;
        int n3 = 0;
        while (n3 < vector2.size()) {
            CaptionedControl captionedControl13 = (CaptionedControl)vector2.elementAt(n3);
            captionedControl13.setBounds(point2.x, point2.y, point.x, point.y);
            point2.y += point.y + n2;
            ++n3;
        }
        this.entryScreen.setSize(rectangle2.width, point2.y);
        this.entryScrollScreen.setContent((Control)this.entryScreen);
        this.entryScrollScreen.setAutoScroll(true);
        this.entryScrollScreen.setVisible(false);
        this.commandNew = new Command((Control)this.shellDirectory, 1, 3);
        this.commandNew.setText(Messages.getString("PhoneBookShowCase.16"));
        this.commandNew.addSelectionListener((SelectionListener)this);
        this.commandDelete = new Command((Control)this.shellDirectory, 1, 2);
        this.commandDelete.setText(Messages.getString("PhoneBookShowCase.17"));
        this.commandDelete.addSelectionListener((SelectionListener)this);
        this.commandExitDirectory = new Command((Control)this.shellDirectory, 7, 1);
        this.commandExitDirectory.setText(Messages.getString("PhoneBookShowCase.18"));
        this.commandExitDirectory.setLongLabel(Messages.getString("PhoneBookShowCase.19"));
        this.commandExitDirectory.addSelectionListener((SelectionListener)this);
        this.commandEdit = new Command((Control)this.shellDirectory, 2, 4);
        this.commandEdit.setText(Messages.getString("PhoneBookShowCase.20"));
        this.commandEdit.addSelectionListener((SelectionListener)this);
        this.commandEdit.setDefaultCommand();
        this.commandEntryScreenDone = new Command((Control)this.entryScreen, 7, 0);
        this.commandEntryScreenDone.setText(Messages.getString("PhoneBookShowCase.21"));
        this.commandEntryScreenDone.addSelectionListener((SelectionListener)this);
        this.addKeyListenerToAllChildren((Composite)this.shellDirectory, this);
        this.addKeyListenerToAllChildren((Composite)this.shellDetails, this);
        this.addTraverseListenerToAllChildren((Composite)this.shellDetails, this);
        this.setOrientation();
        this.shellDirectory.layout();
        this.shellDirectory.open();
        this.updateSelectedDetail();
        MobileDevice mobileDevice = MobileDevice.getMobileDevice();
        this.screens = mobileDevice.getScreens();
        this.rotationListener = new RotationListener();
        this.screens[0].addEventListener((ScreenListener)this.rotationListener);
    }

    void setOrientation() {
        if (this.landscape) {
            if (!this.detailsOpened) {
                this.detailsOpened = true;
                this.positionDetails();
                this.shellDetails.open();
            }
            this.shellDetails.setVisible(true);
            this.commandExitDetails = new Command((Control)this.shellDetails, 7, 0);
            this.commandExitDetails.setText(Messages.getString("PhoneBookShowCase.22"));
            this.commandExitDetails.setLongLabel(Messages.getString("PhoneBookShowCase.23"));
            this.commandExitDetails.addSelectionListener((SelectionListener)this);
            if (this.commandBackDetails != null) {
                this.commandBackDetails.dispose();
                this.commandBackDetails = null;
            }
        } else {
            this.commandBackDetails = new Command((Control)this.shellDetails, 7, 0);
            this.commandBackDetails.setText(Messages.getString("PhoneBookShowCase.24"));
            this.commandBackDetails.addSelectionListener((SelectionListener)this);
            if (this.commandExitDetails != null) {
                this.commandExitDetails.dispose();
                this.commandExitDetails = null;
            }
        }
    }

    boolean addEntry(PhoneBookEntry phoneBookEntry) {
        boolean bl = false;
        if (this.phoneBookDataBase.getEntryWithSurnameAndName(phoneBookEntry.getSurnameAndName()) == null) {
            this.phoneBookDataBase.addEntry(phoneBookEntry);
            this.listNameWidget.add(phoneBookEntry.getSurnameAndName());
            bl = true;
        }
        return bl;
    }

    void removeEntry(String string) {
        PhoneBookEntry phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(string);
        this.phoneBookDataBase.removeEntry(phoneBookEntry);
        this.listNameWidget.remove(string);
    }

    void showEntryScreen() {
        if (this.listNameWidget.getSelectionCount() == 0) {
            return;
        }
        String string = this.listNameWidget.getSelection()[0];
        PhoneBookEntry phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(string);
        this.getComposite().getShell().setText(string);
        this.entryLastName.setText(phoneBookEntry.getSurName());
        this.entryFirstName.setText(phoneBookEntry.getName());
        this.entryCompany.setText(phoneBookEntry.get0rganization());
        this.entryJob.setText(phoneBookEntry.getPosition());
        this.entryTelephone.setText(phoneBookEntry.getPhone());
        this.entryMobile.setText(phoneBookEntry.getMobilePhone());
        this.entryEMail.setText(phoneBookEntry.getEmail());
        this.shellDetails.setVisible(false);
        this.shellDirectory.setVisible(false);
        this.entryScrollScreen.setVisible(true);
        this.entryScreen.setVisible(true);
        this.entryScreen.forceFocus();
    }

    void hideEntryScreen() {
        String string = this.listNameWidget.getSelection()[0];
        PhoneBookEntry phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(string);
        this.listNameWidget.remove(phoneBookEntry.getSurnameAndName());
        phoneBookEntry.setSurName(this.entryLastName.getText());
        phoneBookEntry.setName(this.entryFirstName.getText());
        phoneBookEntry.set0rganization(this.entryCompany.getText());
        phoneBookEntry.setPosition(this.entryJob.getText());
        phoneBookEntry.setPhone(this.entryTelephone.getText());
        phoneBookEntry.setMobilePhone(this.entryMobile.getText());
        phoneBookEntry.setEmail(this.entryEMail.getText());
        this.phoneBookDataBase.update();
        this.listNameWidget.add(phoneBookEntry.getSurnameAndName());
        this.listNameWidget.select(phoneBookEntry.getSurnameAndName());
        this.updateSelectedDetail();
        this.getComposite().getShell().setText(this.getName());
        this.entryScrollScreen.setVisible(false);
        this.entryScreen.setVisible(false);
        this.shellDetails.setVisible(this.landscape);
        this.shellDirectory.setVisible(true);
        this.shellDirectory.forceActive();
        this.listNameWidget.showSelection();
        this.listNameWidget.forceFocus();
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.listNameWidget) {
            this.updateSelectedDetail();
            this.setFocusOnDetails(true);
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (selectionEvent.widget == this.commandExitDirectory || selectionEvent.widget == this.commandExitDetails) {
            this.quit();
        } else if (selectionEvent.widget == this.commandEdit) {
            this.showEntryScreen();
        } else if (selectionEvent.widget == this.commandDelete) {
            if (this.listNameWidget.getSelectionCount() > 0) {
                MessageBox messageBox = new MessageBox(this.getComposite().getShell(), 292);
                messageBox.setMessage(Messages.getString("PhoneBookShowCase.25"));
                if (messageBox.open() == 32) {
                    this.removeEntry(this.listNameWidget.getSelection()[0]);
                    this.updateSelectedDetail();
                }
            }
        } else if (selectionEvent.widget == this.commandNew) {
            PhoneBookEntry phoneBookEntry = new PhoneBookEntry("", "", "", "", "0", "", "", "");
            if (this.addEntry(phoneBookEntry)) {
                this.listNameWidget.select(Messages.getString("PhoneBookShowCase.34"));
                this.listNameWidget.showSelection();
                this.showEntryScreen();
            }
        } else if (selectionEvent.widget == this.listNameWidget) {
            this.updateSelectedDetail();
        } else if (selectionEvent.widget == this.commandEntryScreenDone) {
            this.hideEntryScreen();
        } else if (selectionEvent.widget == this.commandBackDetails) {
            this.setFocusOnDetails(false);
        }
    }

    public void quit() {
        this.screens[0].removeEventListener((ScreenListener)this.rotationListener);
        this.getComposite().getShell().removeControlListener((ControlListener)this);
        if (this.background != null) {
            this.background.dispose();
            this.background = null;
        }
        this.commandExitDirectory.dispose();
        if (this.commandExitDetails != null) {
            this.commandExitDetails.dispose();
        }
        if (this.commandBackDetails != null) {
            this.commandBackDetails.dispose();
        }
        this.commandEdit.dispose();
        this.commandNew.dispose();
        this.commandDelete.dispose();
        this.shellDetails.dispose();
        this.shellDirectory.dispose();
        this.entryScreen.dispose();
        this.entryScrollScreen.dispose();
        this.dispose();
    }

    public void setFocusOnDetails(boolean bl) {
        if (this.landscape) {
            if (bl) {
                this.shellDetails.setFocus();
            } else {
                this.shellDirectory.setFocus();
            }
        } else if (bl) {
            if (!this.detailsOpened) {
                this.detailsOpened = true;
                this.positionDetails();
                this.shellDetails.open();
            }
            this.shellDetails.setVisible(true);
            this.shellDirectory.setVisible(false);
            this.shellDetails.setActive();
        } else {
            this.shellDirectory.setVisible(true);
            this.shellDetails.setVisible(false);
            this.shellDirectory.setActive();
        }
    }

    private void updateSelectedDetail() {
        if (this.listNameWidget.getSelectionCount() == 0) {
            return;
        }
        PhoneBookEntry phoneBookEntry = this.phoneBookDataBase.getEntryWithSurnameAndName(this.listNameWidget.getSelection()[0]);
        if (phoneBookEntry != null) {
            this.updateDetail(phoneBookEntry);
        }
    }

    private void updateDetail(PhoneBookEntry phoneBookEntry) {
        this.shellDetails.setText(phoneBookEntry.getSurnameAndName());
        if (phoneBookEntry.get0rganization() != "") {
            this.detailOrganization.setVisible(true);
            this.detailOrganization.setText(phoneBookEntry.get0rganization());
        } else {
            this.detailOrganization.setVisible(false);
        }
        if (phoneBookEntry.getPosition() != "") {
            this.detailPosition.setVisible(true);
            this.detailPosition.setText(phoneBookEntry.getPosition());
        } else {
            this.detailPosition.setVisible(false);
        }
        if (phoneBookEntry.getPhone() != "") {
            this.detailPhone.setVisible(true);
            this.detailPhone.setText(phoneBookEntry.getPhone());
        } else {
            this.detailPhone.setVisible(false);
        }
        if (phoneBookEntry.getMobilePhone() != "") {
            this.detailMobile.setVisible(true);
            this.detailMobile.setText(phoneBookEntry.getMobilePhone());
        } else {
            this.detailMobile.setVisible(false);
        }
        if (phoneBookEntry.getEmail() != "") {
            this.detailEmail.setVisible(true);
            this.detailEmail.setText(phoneBookEntry.getEmail());
        } else {
            this.detailEmail.setVisible(false);
        }
        this.shellDetails.layout();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 0x1000004) {
            this.setFocusOnDetails(true);
        } else if (keyEvent.keyCode == 0x1000003) {
            this.setFocusOnDetails(false);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    private void addKeyListenerToAllChildren(Composite composite, KeyListener keyListener) {
        if (composite != null) {
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.swt.widgets.Composite");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(controlArray[n].getClass())) {
                    this.addKeyListenerToAllChildren((Composite)controlArray[n], this);
                } else {
                    controlArray[n].addKeyListener(keyListener);
                }
                ++n;
            }
        }
    }

    private void addTraverseListenerToAllChildren(Composite composite, TraverseListener traverseListener) {
        if (composite != null) {
            Control[] controlArray = composite.getChildren();
            int n = 0;
            while (n < controlArray.length) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.swt.widgets.Composite");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(controlArray[n].getClass())) {
                    this.addTraverseListenerToAllChildren((Composite)controlArray[n], this);
                } else {
                    controlArray[n].addTraverseListener(traverseListener);
                }
                ++n;
            }
        }
    }

    public void keyTraversed(TraverseEvent traverseEvent) {
        if (traverseEvent.character == '\u001b' && ((Control)traverseEvent.widget).getShell() == this.shellDetails) {
            traverseEvent.doit = false;
        } else if (traverseEvent.doit && traverseEvent.widget == this.shellDetails) {
            this.setFocusOnDetails(true);
        } else if (traverseEvent.doit && traverseEvent.widget == this.listNameWidget) {
            this.setFocusOnDetails(true);
        }
    }

    public void modifyText(ModifyEvent modifyEvent) {
        if (modifyEvent.widget == this.entryFirstName || modifyEvent.widget == this.entryLastName) {
            if (this.entryLastName.getText() != "" && this.entryFirstName.getText() != "") {
                this.getComposite().getShell().setText(String.valueOf(this.entryLastName.getText()) + ", " + this.entryFirstName.getText());
            } else if (this.entryLastName.getText() == "" && this.entryFirstName.getText() != "") {
                this.getComposite().getShell().setText(this.entryFirstName.getText());
            } else if (this.entryLastName.getText() != "" && this.entryFirstName.getText() == "") {
                this.getComposite().getShell().setText(this.entryLastName.getText());
            } else if (this.entryLastName.getText() == "" && this.entryFirstName.getText() == "") {
                this.getComposite().getShell().setText(Messages.getString("PhoneBookShowCase.49"));
            }
        }
    }

    public class RotationListener
    implements ScreenListener {
        public void screenActivated(ScreenEvent screenEvent) {
        }

        public void screenDeactivated(ScreenEvent screenEvent) {
        }

        public void screenOrientationChanged(ScreenEvent screenEvent) {
            PhoneBookShowCase.this.landscape = screenEvent.orientation == 1;
            PhoneBookShowCase.this.setOrientation();
            PhoneBookShowCase.this.positionDirectory();
            PhoneBookShowCase.this.positionDetails();
        }
    }
}

