/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.launcher;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.launcher.Main;

public class WebStartMain
extends Main {
    private static final String PROP_WEBSTART_AUTOMATIC_INSTALLATION = "eclipse.webstart.automaticInstallation";
    private static final String DEFAULT_OSGI_BUNDLES = "org.eclipse.core.runtime@2:start";
    private static final String PROP_OSGI_BUNDLES = "osgi.bundles";
    private String[] allJars = null;
    private Set onTheBundleList = new HashSet();
    static /* synthetic */ Class class$0;

    public static void main(String[] stringArray) {
        System.setSecurityManager(null);
        int n = new WebStartMain().run(stringArray);
        System.exit(n);
    }

    private void setDefaultBundles() {
        if (System.getProperty(PROP_OSGI_BUNDLES) != null) {
            return;
        }
        System.getProperties().put(PROP_OSGI_BUNDLES, DEFAULT_OSGI_BUNDLES);
    }

    protected void basicRun(String[] stringArray) throws Exception {
        String string = this.searchFor(this.framework, null);
        System.getProperties().setProperty("osgi.framework", string);
        this.onTheBundleList.add(string);
        super.basicRun(stringArray);
    }

    protected URL[] getBootPath(String string) throws IOException {
        URL[] uRLArray = super.getBootPath(string);
        this.setDefaultBundles();
        this.convertBundleList();
        this.addAllBundlesToBundleList();
        this.cleanup();
        return uRLArray;
    }

    private void cleanup() {
        this.allJars = null;
        this.onTheBundleList = null;
    }

    protected String searchFor(String string, String string2) {
        String[] stringArray = this.getAllJars();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf(string) != -1) {
                arrayList.add(stringArray[n]);
            }
            ++n;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[arrayList.size()];
        int n2 = 0;
        while (n2 < arrayList.size()) {
            stringArray2[n2] = this.extractFileName((String)arrayList.get(n2));
            ++n2;
        }
        if (this.debug) {
            System.out.println(this.extractInnerURL((String)arrayList.get(this.findMax(stringArray2))));
        }
        return this.extractInnerURL((String)arrayList.get(this.findMax(stringArray2)));
    }

    private String extractFileName(String string) {
        String string2 = this.extractInnerURL(string);
        return string2.substring(string2.lastIndexOf("/") + 1);
    }

    private String[] getAllJars() {
        if (this.allJars != null) {
            return this.allJars;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.launcher.WebStartMain");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Enumeration<URL> enumeration = clazz.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement().toExternalForm());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.allJars = new String[arrayList.size()];
        arrayList.toArray(this.allJars);
        if (this.debug) {
            this.printArray("Jars found on the webstart path:\n", this.allJars);
        }
        return this.allJars;
    }

    private String extractInnerURL(String string) {
        int n;
        if (string.startsWith("jar:")) {
            string = string.substring(string.indexOf("jar:") + 4);
        }
        if ((n = string.lastIndexOf(33)) != -1) {
            string = string.substring(0, n);
        }
        return this.decode(string);
    }

    private void convertBundleList() {
        if (this.debug) {
            System.out.println("Osgi bundles before conversion:\n" + System.getProperty(PROP_OSGI_BUNDLES));
        }
        String[] stringArray = this.getArrayFromList(System.getProperty(PROP_OSGI_BUNDLES));
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(64);
            String string3 = null;
            string3 = n2 == -1 ? string2 : string2.substring(0, n2);
            String string4 = this.searchFor(string3, null);
            if (string4 == null) {
                if (this.debug) {
                    System.out.println("Could not find " + string3);
                }
            } else {
                this.onTheBundleList.add(string4);
                string4 = "reference:" + string4;
                string = String.valueOf(string) + string4;
                if (n2 != -1) {
                    string = String.valueOf(string) + string2.substring(n2);
                }
                string = String.valueOf(string) + ',';
            }
            ++n;
        }
        System.getProperties().setProperty(PROP_OSGI_BUNDLES, string);
    }

    private void addAllBundlesToBundleList() {
        if ("false".equalsIgnoreCase(System.getProperties().getProperty(PROP_WEBSTART_AUTOMATIC_INSTALLATION))) {
            return;
        }
        String[] stringArray = this.getAllJars();
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.onTheBundleList.contains(stringArray[n]);
            stringArray2[n] = "reference:" + this.extractInnerURL(stringArray[n]);
            ++n;
        }
        System.getProperties().setProperty(PROP_OSGI_BUNDLES, String.valueOf(System.getProperty(PROP_OSGI_BUNDLES)) + this.arrayToString(stringArray2, ','));
        if (this.debug) {
            this.printArray("Bundles list:\n", stringArray2);
        }
    }

    private void printArray(String string, String[] stringArray) {
        System.out.println(string);
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("\t" + stringArray[n]);
            ++n;
        }
    }

    private String arrayToString(String[] stringArray, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length - 1) {
            stringBuffer.append(stringArray[n]).append(c);
            ++n;
        }
        stringBuffer.append(stringArray[stringArray.length - 1]);
        return new String(stringBuffer);
    }
}

