/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.Hashtable;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.service.runnable.ParameterizedRunnable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class PlatformActivator
extends Plugin
implements BundleActivator {
    private static final String PROP_ECLIPSE_EXITCODE = "eclipse.exitcode";
    private static final String PROP_ECLIPSE_APPLICATION = "eclipse.application";
    private static BundleContext context;
    private ServiceRegistration entryLocatorRegistration;
    static /* synthetic */ Class class$0;

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        InternalPlatform.getDefault().start(bundleContext);
        this.registerApplicationService();
        InternalPlatform.getDefault().setRuntimeInstance(this);
        super.start(bundleContext);
    }

    public void stop(BundleContext bundleContext) {
        this.unregisterEntryLocator();
        InternalPlatform.getDefault().stop(bundleContext);
        InternalPlatform.getDefault().setRuntimeInstance(null);
    }

    private void registerApplicationService() {
        ParameterizedRunnable parameterizedRunnable = new ParameterizedRunnable(){

            public Object run(Object stringArray) throws Exception {
                Object object;
                IPlatformRunnable iPlatformRunnable = null;
                String string = InternalPlatform.getDefault().getApplicationId();
                if (string == null) {
                    throw new RuntimeException(Messages.application_noIdFound);
                }
                IExtensionRegistry iExtensionRegistry = InternalPlatform.getDefault().getRegistry();
                IExtension iExtension = iExtensionRegistry.getExtension("org.eclipse.core.runtime", "applications", string);
                if (iExtension == null) {
                    IExtension[] iExtensionArray = iExtensionRegistry.getExtensionPoint("org.eclipse.core.runtime.applications").getExtensions();
                    String string2 = "<NONE>";
                    if (iExtensionArray.length != 0) {
                        string2 = iExtensionArray[0].getUniqueIdentifier();
                        int n = 1;
                        while (n < iExtensionArray.length) {
                            string2 = String.valueOf(string2) + ", " + iExtensionArray[n].getUniqueIdentifier();
                            ++n;
                        }
                    }
                    throw new RuntimeException(NLS.bind((String)Messages.application_notFound, (Object)string, (Object)string2));
                }
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                if (iConfigurationElementArray.length == 0) {
                    throw new RuntimeException(NLS.bind((String)Messages.application_invalidExtension, (Object)string));
                }
                IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
                iPlatformRunnable = (IPlatformRunnable)iConfigurationElement.createExecutableExtension("run");
                if (stringArray == null) {
                    stringArray = InternalPlatform.getDefault().getApplicationArgs();
                }
                int n = (object = iPlatformRunnable.run(stringArray)) instanceof Integer ? (Integer)object : 0;
                System.getProperties().setProperty(PlatformActivator.PROP_ECLIPSE_EXITCODE, Integer.toString(n));
                if (InternalPlatform.DEBUG) {
                    System.out.println(NLS.bind((String)Messages.application_returned, (Object[])new String[]{string, object == null ? "null" : object.toString()}));
                }
                return object;
            }
        };
        Hashtable<String, String> hashtable = new Hashtable<String, String>(1);
        hashtable.put(PROP_ECLIPSE_APPLICATION, "default");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.service.runnable.ParameterizedRunnable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(clazz.getName(), (Object)parameterizedRunnable, hashtable);
    }

    private void unregisterEntryLocator() {
        if (this.entryLocatorRegistration != null) {
            this.entryLocatorRegistration.unregister();
            this.entryLocatorRegistration = null;
        }
    }
}

