/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.text.MessageFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class DialogCellEditor
extends CellEditor {
    public static final String CELL_EDITOR_IMG_DOTS_BUTTON = "cell_editor_dots_button_image";
    private Composite editor;
    private Control contents;
    private Label defaultLabel;
    private Button button;
    private Object value = null;
    private static final int defaultStyle = 0;
    static /* synthetic */ Class class$0;

    static {
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.viewers.DialogCellEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        imageRegistry.put(CELL_EDITOR_IMG_DOTS_BUTTON, ImageDescriptor.createFromFile(clazz, "images/dots_button.gif"));
    }

    public DialogCellEditor() {
        this.setStyle(0);
    }

    protected DialogCellEditor(Composite composite) {
        this(composite, 0);
    }

    protected DialogCellEditor(Composite composite, int n) {
        super(composite, n);
    }

    protected Button createButton(Composite composite) {
        Button button = new Button(composite, 1024);
        button.setText("...");
        return button;
    }

    protected Control createContents(Composite composite) {
        this.defaultLabel = new Label(composite, 16384);
        this.defaultLabel.setFont(composite.getFont());
        this.defaultLabel.setBackground(composite.getBackground());
        return this.defaultLabel;
    }

    protected Control createControl(Composite composite) {
        Font font = composite.getFont();
        Color color = composite.getBackground();
        this.editor = new Composite(composite, this.getStyle());
        this.editor.setFont(font);
        this.editor.setBackground(color);
        this.editor.setLayout((Layout)new DialogCellLayout());
        this.contents = this.createContents(this.editor);
        this.updateContents(this.value);
        this.button = this.createButton(this.editor);
        this.button.setFont(font);
        this.button.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.character == '\u001b') {
                    DialogCellEditor.this.fireCancelEditor();
                }
            }

            public void keyPressed(KeyEvent keyEvent) {
            }
        });
        this.button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Object object = DialogCellEditor.this.openDialogBox((Control)DialogCellEditor.this.editor);
                if (object != null) {
                    boolean bl = DialogCellEditor.this.isCorrect(object);
                    if (bl) {
                        DialogCellEditor.this.markDirty();
                        DialogCellEditor.this.doSetValue(object);
                    } else {
                        DialogCellEditor.this.setErrorMessage(MessageFormat.format(DialogCellEditor.this.getErrorMessage(), object.toString()));
                    }
                    DialogCellEditor.this.fireApplyEditorValue();
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.setValueValid(true);
        return this.editor;
    }

    protected Object doGetValue() {
        return this.value;
    }

    protected void doSetFocus() {
        this.button.setFocus();
    }

    protected void doSetValue(Object object) {
        this.value = object;
        this.updateContents(object);
    }

    protected Label getDefaultLabel() {
        return this.defaultLabel;
    }

    protected abstract Object openDialogBox(Control var1);

    protected void updateContents(Object object) {
        if (this.defaultLabel == null) {
            return;
        }
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        this.defaultLabel.setText(string);
    }

    private class DialogCellLayout
    extends Layout {
        private DialogCellLayout() {
        }

        public void layout(Composite composite, boolean bl) {
            Rectangle rectangle = composite.getClientArea();
            Point point = DialogCellEditor.this.button.computeSize(-1, -1, bl);
            if (DialogCellEditor.this.contents != null) {
                DialogCellEditor.this.contents.setBounds(0, 0, rectangle.width - point.x, rectangle.height);
            }
            DialogCellEditor.this.button.setBounds(rectangle.width - point.x, 0, point.x, rectangle.height);
        }

        public Point computeSize(Composite composite, int n, int n2, boolean bl) {
            if (n != -1 && n2 != -1) {
                return new Point(n, n2);
            }
            Point point = DialogCellEditor.this.contents.computeSize(-1, -1, bl);
            Point point2 = DialogCellEditor.this.button.computeSize(-1, -1, bl);
            Point point3 = new Point(point2.x, Math.max(point.y, point2.y));
            return point3;
        }
    }
}

