/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;
import org.eclipse.update.internal.core.Messages;

public class IncludedFeatureReference
extends IncludedFeatureReferenceModel
implements IIncludedFeatureReference {
    public IncludedFeatureReference() {
    }

    public IncludedFeatureReference(IIncludedFeatureReference iIncludedFeatureReference) {
        super((IncludedFeatureReferenceModel)((Object)iIncludedFeatureReference));
    }

    public IncludedFeatureReference(IFeatureReference iFeatureReference) {
        super(iFeatureReference);
    }

    private boolean isDisabled() {
        IConfiguredSite iConfiguredSite = this.getSite().getCurrentConfiguredSite();
        if (iConfiguredSite == null) {
            return false;
        }
        IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getConfiguredFeatures();
        int n = 0;
        while (n < iFeatureReferenceArray.length) {
            if (this.equals(iFeatureReferenceArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private boolean isUninstalled() {
        if (!this.isDisabled()) {
            return false;
        }
        ISiteFeatureReference[] iSiteFeatureReferenceArray = this.getSite().getFeatureReferences();
        int n = 0;
        while (n < iSiteFeatureReferenceArray.length) {
            if (this.equals(iSiteFeatureReferenceArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public IFeature getFeature(boolean bl, IConfiguredSite iConfiguredSite) throws CoreException {
        return this.getFeature(null);
    }

    public IFeature getFeature(boolean bl, IConfiguredSite iConfiguredSite, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.getFeature(iProgressMonitor);
    }

    public IFeature getFeature() throws CoreException {
        return this.getFeature(null);
    }

    public IFeature getFeature(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.isUninstalled()) {
            throw new CoreException((IStatus)new Status(4, AppPlugin.getPlugin().getBundle().getSymbolicName(), 0, NLS.bind((String)Messages.IncludedFeatureReference_featureUninstalled, (Object[])new String[]{this.getFeatureIdentifier()}), null));
        }
        return super.getFeature(iProgressMonitor);
    }
}

