/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.model.ModelObject;

public class URLEntryModel
extends ModelObject {
    private String annotation;
    private String localizedAnnotation;
    private String urlString;
    private URL url;
    private int type = 0;
    private URL bundleURL;
    private URL base;
    private boolean resolved = false;

    public String getAnnotation() {
        this.delayedResolve();
        if (this.localizedAnnotation != null) {
            return this.localizedAnnotation;
        }
        return this.annotation;
    }

    public String getAnnotationNonLocalized() {
        return this.annotation;
    }

    public String getURLString() {
        this.delayedResolve();
        return this.urlString;
    }

    public URL getURL() {
        this.delayedResolve();
        return this.url;
    }

    public void setAnnotation(String string) {
        this.assertIsWriteable();
        this.annotation = string;
        this.localizedAnnotation = null;
    }

    public void setURLString(String string) {
        this.assertIsWriteable();
        this.urlString = string;
        this.url = null;
    }

    public void resolve(URL uRL, URL uRL2) throws MalformedURLException {
        this.base = uRL;
        this.bundleURL = uRL2;
    }

    private void delayedResolve() {
        if (this.resolved) {
            return;
        }
        this.resolved = true;
        this.localizedAnnotation = this.resolveNLString(this.bundleURL, this.annotation);
        try {
            this.url = this.resolveURL(this.base, this.bundleURL, this.urlString);
        }
        catch (MalformedURLException malformedURLException) {
            AppPlugin.warn("", malformedURLException);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }
}

