/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.ISiteFactoryExtension;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.core.LocalSite;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteTypeFactory;
import org.eclipse.update.internal.core.URLEncoder;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.model.ITimestamp;

public class InternalSiteManager {
    public static ILocalSite localSite;
    public static final String DEFAULT_SITE_TYPE = "org.eclipse.ercp.update.http";
    private static final String DEFAULT_EXECUTABLE_SITE_TYPE = "org.eclipse.ercp.update.file";
    private static Map estimates;
    private static Map sites;
    private static Map httpSitesUpdatedUrls;
    private static Map siteTimestamps;
    public static boolean globalUseCache;
    private static CoreException exceptionOccured;

    static {
        sites = new HashMap();
        httpSitesUpdatedUrls = new HashMap();
        siteTimestamps = new HashMap();
        globalUseCache = true;
        exceptionOccured = null;
    }

    public static ILocalSite getLocalSite() throws CoreException {
        return InternalSiteManager.internalGetLocalSite();
    }

    private static ILocalSite internalGetLocalSite() throws CoreException {
        if (exceptionOccured != null) {
            throw exceptionOccured;
        }
        if (localSite == null) {
            try {
                localSite = LocalSite.internalGetLocalSite();
            }
            catch (CoreException coreException) {
                exceptionOccured = coreException;
                throw coreException;
            }
        }
        return localSite;
    }

    private static boolean isValidCachedSite(URL uRL) {
        if (!sites.containsKey(uRL.toExternalForm())) {
            return false;
        }
        Long l = (Long)siteTimestamps.get(uRL);
        if (l == null) {
            return false;
        }
        long l2 = l;
        return UpdateManagerUtils.isSameTimestamp(uRL, l2);
    }

    public static ISite getSite(URL uRL, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        Object object;
        ISite iSite;
        block22: {
            File file;
            iSite = null;
            if (iProgressMonitor == null) {
                iProgressMonitor = new NullProgressMonitor();
            }
            if (uRL == null) {
                return null;
            }
            if (httpSitesUpdatedUrls.containsKey(uRL.toExternalForm())) {
                uRL = (URL)httpSitesUpdatedUrls.get(uRL.toExternalForm());
            }
            String string = uRL.toExternalForm();
            if (bl && globalUseCache && InternalSiteManager.isValidCachedSite(uRL)) {
                iSite = (ISite)sites.get(string);
                return iSite;
            }
            if ("file".equals(uRL.getProtocol()) && (file = new File(uRL.getFile())).isDirectory() && !"eclipse".equals(file.getName())) {
                file = new File(file, "eclipse");
                try {
                    if (bl && globalUseCache && InternalSiteManager.isValidCachedSite(file.toURL())) {
                        iSite = (ISite)sites.get(file.toURL().toExternalForm());
                        return iSite;
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            }
            boolean bl2 = "file".equalsIgnoreCase(uRL.getProtocol());
            boolean bl3 = false;
            if (bl2 && (object = new File(uRL.getFile())) != null && ((File)object).isDirectory() && !new File((File)object, "site.xml").exists()) {
                bl3 = true;
            }
            iProgressMonitor.beginTask(Messages.InternalSiteManager_ConnectingToSite, 8);
            if (bl2 && bl3) {
                iSite = InternalSiteManager.attemptCreateSite(DEFAULT_EXECUTABLE_SITE_TYPE, uRL, iProgressMonitor);
                iProgressMonitor.worked(4);
            } else {
                try {
                    iProgressMonitor.worked(3);
                    iSite = InternalSiteManager.attemptCreateSite(DEFAULT_SITE_TYPE, uRL, iProgressMonitor);
                    iProgressMonitor.worked(1);
                }
                catch (CoreException coreException) {
                    if (iProgressMonitor.isCanceled()) break block22;
                    if (!bl2) {
                        throw coreException;
                    }
                    try {
                        iSite = InternalSiteManager.attemptCreateSite(DEFAULT_EXECUTABLE_SITE_TYPE, uRL, iProgressMonitor);
                    }
                    catch (CoreException coreException2) {
                        IStatus iStatus = coreException.getStatus();
                        MultiStatus multiStatus = new MultiStatus(iStatus.getPlugin(), 0, Messages.InternalSiteManager_FailedRetryAccessingSite, (Throwable)coreException2);
                        multiStatus.addAll(iStatus);
                        throw coreException;
                    }
                }
            }
        }
        if (iSite != null) {
            sites.put(iSite.getURL().toExternalForm(), iSite);
            if (iSite instanceof ITimestamp) {
                siteTimestamps.put(iSite.getURL(), new Long(((ITimestamp)((Object)iSite)).getTimestamp().getTime()));
            } else {
                try {
                    object = ConnectionFactory.get(URLEncoder.encode(uRL));
                    siteTimestamps.put(uRL, new Long(object.getLastModified()));
                }
                catch (MalformedURLException malformedURLException) {
                }
                catch (IOException iOException) {}
            }
        }
        JarContentReference.shutdown();
        return iSite;
    }

    private static ISite attemptCreateSite(String string, URL uRL, IProgressMonitor iProgressMonitor) throws CoreException {
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        ISite iSite = null;
        try {
            iProgressMonitor.worked(1);
            iSite = InternalSiteManager.createSite(string, uRL, iProgressMonitor);
            iProgressMonitor.worked(1);
        }
        catch (InvalidSiteTypeException invalidSiteTypeException) {
            if (iProgressMonitor.isCanceled()) {
                return null;
            }
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_TYPE) {
                AppPlugin.debug("The Site :" + uRL.toExternalForm() + " is a different type than the guessed type based on the protocol. new Type:" + invalidSiteTypeException.getNewType());
            }
            try {
                if (invalidSiteTypeException.getNewType() == null) {
                    throw invalidSiteTypeException;
                }
                iSite = InternalSiteManager.createSite(invalidSiteTypeException.getNewType(), uRL, iProgressMonitor);
            }
            catch (InvalidSiteTypeException invalidSiteTypeException2) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InternalSiteManager_UnableToCreateSiteWithType, (Object[])new String[]{invalidSiteTypeException.getNewType(), uRL.toExternalForm()}), invalidSiteTypeException2);
            }
        }
        return iSite;
    }

    private static ISite createSite(String string, URL uRL, IProgressMonitor iProgressMonitor) throws CoreException, InvalidSiteTypeException {
        URL uRL2;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        ISiteFactory iSiteFactory = SiteTypeFactory.getInstance().getFactory(string);
        try {
            uRL2 = uRL.getRef() != null || uRL.getFile().endsWith("site.xml") || uRL.getProtocol().equalsIgnoreCase("file") ? uRL : (uRL.getFile().endsWith("/") ? new URL(uRL, "site.xml") : new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(uRL.getFile()) + "/" + "site.xml"));
        }
        catch (MalformedURLException malformedURLException) {
            uRL2 = uRL;
        }
        try {
            iProgressMonitor.worked(1);
            return InternalSiteManager.createSite(iSiteFactory, uRL2, uRL, iProgressMonitor);
        }
        catch (CoreException coreException) {
            block13: {
                try {
                    if (!iProgressMonitor.isCanceled()) break block13;
                    return null;
                }
                catch (CoreException coreException2) {
                    throw Utilities.newCoreException(NLS.bind((String)Messages.InternalSiteManager_UnableToAccessURL, (Object[])new String[]{uRL.toExternalForm()}), coreException2);
                }
            }
            if (!uRL2.equals(uRL)) {
                return InternalSiteManager.createSite(iSiteFactory, uRL, uRL, iProgressMonitor);
            }
            if (uRL.getProtocol().equalsIgnoreCase("file") && !uRL.getFile().endsWith("site.xml")) {
                try {
                    if (uRL.getFile().endsWith("/")) {
                        return InternalSiteManager.createSite(iSiteFactory, new URL(uRL, "site.xml"), uRL, iProgressMonitor);
                    }
                    return InternalSiteManager.createSite(iSiteFactory, new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), String.valueOf(uRL.getFile()) + "/" + "site.xml"), uRL, iProgressMonitor);
                }
                catch (MalformedURLException malformedURLException) {
                    throw coreException;
                }
            }
            throw coreException;
        }
    }

    private static ISite createSite(ISiteFactory iSiteFactory, URL uRL, URL uRL2, IProgressMonitor iProgressMonitor) throws CoreException, InvalidSiteTypeException {
        ISite iSite = InternalSiteManager.createSite(iSiteFactory, uRL, iProgressMonitor);
        httpSitesUpdatedUrls.put(uRL2.toExternalForm(), uRL);
        return iSite;
    }

    private static ISite createSite(ISiteFactory iSiteFactory, URL uRL, IProgressMonitor iProgressMonitor) throws CoreException, InvalidSiteTypeException {
        if (iSiteFactory instanceof ISiteFactoryExtension) {
            return ((ISiteFactoryExtension)((Object)iSiteFactory)).createSite(uRL, iProgressMonitor);
        }
        return iSiteFactory.createSite(uRL);
    }

    public static ISite createSite(File file) throws CoreException {
        ISite iSite = null;
        if (file != null) {
            try {
                URL uRL = file.toURL();
                iSite = InternalSiteManager.getSite(uRL, false, null);
            }
            catch (MalformedURLException malformedURLException) {
                throw Utilities.newCoreException(NLS.bind((String)Messages.InternalSiteManager_UnableToCreateURL, (Object[])new String[]{file.getAbsolutePath()}), malformedURLException);
            }
        }
        return iSite;
    }

    public static void downloaded(long l, long l2, URL uRL) {
        if (l <= 0L || l2 < 0L) {
            return;
        }
        String string = uRL.getHost();
        long l3 = l2 == 0L ? 0L : l / l2;
        Long l4 = new Long(l3);
        if (estimates == null) {
            estimates = new HashMap();
        } else {
            Long l5 = (Long)estimates.get(string);
            if (l5 != null) {
                l4 = new Long((l5 + l3) / 2L);
            }
        }
        estimates.put(string, l4);
    }

    public static long getEstimatedTransferRate(String string) {
        if (estimates == null) {
            return 0L;
        }
        Long l = (Long)estimates.get(string);
        if (l == null) {
            return 0L;
        }
        return l;
    }
}

