/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.IContentConsumer;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.internal.core.ContentConsumer;
import org.eclipse.update.internal.core.ErrorRecoveryLog;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.SiteContentConsumer;
import org.eclipse.update.internal.core.SiteFile;
import org.eclipse.update.internal.core.SiteFileFactory;
import org.eclipse.update.internal.core.SiteFileNonPluginContentConsumer;
import org.eclipse.update.internal.core.SiteFilePackedPluginContentConsumer;
import org.eclipse.update.internal.core.SiteFilePluginContentConsumer;
import org.eclipse.update.internal.core.UpdateManagerUtils;

public class SiteFileContentConsumer
extends SiteContentConsumer {
    private IFeature feature;
    private boolean closed = false;
    private String oldPath;
    private String newPath;
    private List contentConsumers;
    private List installedFiles;
    private SiteFileFactory archiveFactory = new SiteFileFactory();

    public SiteFileContentConsumer(IFeature iFeature) {
        this.feature = iFeature;
        this.installedFiles = new ArrayList();
    }

    private String getFeaturePath() throws CoreException {
        String string = null;
        try {
            VersionedIdentifier versionedIdentifier = this.feature.getVersionedIdentifier();
            String string2 = "features/" + versionedIdentifier.toString() + File.separator;
            URL uRL = new URL(this.getSite().getURL(), string2);
            string = uRL.getFile();
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(String.valueOf(Messages.SiteFileContentConsumer_UnableToCreateURL) + malformedURLException.getMessage(), malformedURLException);
        }
        return string;
    }

    public IContentConsumer open(INonPluginEntry iNonPluginEntry) throws CoreException {
        return new SiteFileNonPluginContentConsumer(this.getFeaturePath());
    }

    public IContentConsumer open(IPluginEntry iPluginEntry) throws CoreException {
        ContentConsumer contentConsumer = iPluginEntry instanceof PluginEntryModel && !((PluginEntryModel)((Object)iPluginEntry)).isUnpack() ? new SiteFilePackedPluginContentConsumer(iPluginEntry, this.getSite()) : new SiteFilePluginContentConsumer(iPluginEntry, this.getSite());
        this.addContentConsumers(contentConsumer);
        return contentConsumer;
    }

    /*
     * Exception decompiling
     */
    public void store(ContentReference var1_1, IProgressMonitor var2_2) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 235->239)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IFeatureReference close() throws CoreException {
        Object object;
        if (this.closed) {
            AppPlugin.warn("Attempt to close a closed SiteFileContentConsumer", new Exception());
        }
        SiteFeatureReference siteFeatureReference = new SiteFeatureReference();
        siteFeatureReference.setSite(this.getSite());
        File file = null;
        try {
            file = new File(this.getFeaturePath());
            siteFeatureReference.setURL(file.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFileContentConsumer_UnableToCreateURLForFile, (Object[])new String[]{file.getAbsolutePath()}), malformedURLException);
        }
        if (this.newPath != null) {
            Object object2;
            ErrorRecoveryLog.getLog().appendPath("RENAME", this.newPath);
            boolean bl = false;
            object = new File(this.newPath);
            if (((File)object).exists()) {
                object2 = new File(this.oldPath);
                if (((File)object2).exists()) {
                    UpdateManagerUtils.removeFromFileSystem((File)object2);
                    AppPlugin.warn("Removing already existing file:" + this.oldPath);
                }
                bl = ((File)object).renameTo((File)object2);
            }
            if (!bl) {
                object2 = NLS.bind((String)Messages.ContentConsumer_UnableToRename, (Object[])new String[]{this.newPath, this.oldPath});
                throw Utilities.newCoreException((String)object2, new Exception((String)object2));
            }
        }
        if (this.contentConsumers != null) {
            Iterator iterator = this.contentConsumers.iterator();
            while (iterator.hasNext()) {
                object = (ContentConsumer)iterator.next();
                object.close();
            }
        }
        this.contentConsumers = null;
        if (siteFeatureReference != null) {
            this.commitPlugins(siteFeatureReference);
            siteFeatureReference.markReadOnly();
        }
        this.closed = true;
        return siteFeatureReference;
    }

    public void abort() throws CoreException {
        Object object;
        if (this.closed) {
            AppPlugin.warn("Attempt to abort a closed SiteFileContentConsumer", new Exception());
            return;
        }
        if (this.contentConsumers != null) {
            Iterator iterator = this.contentConsumers.iterator();
            while (iterator.hasNext()) {
                object = (ContentConsumer)iterator.next();
                if (object instanceof SiteFilePluginContentConsumer) {
                    ((SiteFilePluginContentConsumer)object).abort();
                    continue;
                }
                if (!(object instanceof SiteFilePackedPluginContentConsumer)) continue;
                ((SiteFilePackedPluginContentConsumer)object).abort();
            }
        }
        this.contentConsumers = null;
        boolean bl = true;
        if (this.oldPath != null) {
            ErrorRecoveryLog.getLog().appendPath("DELETE", this.oldPath);
            object = new File(this.oldPath);
            if (((File)object).exists()) {
                bl = ((File)object).delete();
            }
        }
        if (!bl) {
            object = NLS.bind((String)Messages.SiteFileContentConsumer_unableToDelete, (Object[])new String[]{this.oldPath});
            AppPlugin.log((String)object, null);
        } else {
            String string;
            object = this.installedFiles.iterator();
            File file = null;
            while (object.hasNext()) {
                string = (String)object.next();
                file = new File(string);
                UpdateManagerUtils.removeFromFileSystem(file);
            }
            string = this.getFeaturePath();
            UpdateManagerUtils.removeEmptyDirectoriesFromFileSystem(new File(string));
        }
        this.closed = true;
    }

    private void commitPlugins(IFeatureReference iFeatureReference) throws CoreException {
        ((SiteFile)this.getSite()).addFeatureReferenceModel((SiteFeatureReferenceModel)iFeatureReference);
        IFeature iFeature = null;
        try {
            iFeature = iFeatureReference.getFeature(null);
        }
        catch (CoreException coreException) {
            AppPlugin.warn(null, coreException);
            return;
        }
        if (iFeature == null) {
            return;
        }
        ArchiveReferenceModel archiveReferenceModel = null;
        IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
        int n = 0;
        while (n < iPluginEntryArray.length) {
            String string = iPluginEntryArray[n].getVersionedIdentifier().toString();
            String string2 = "plugins/" + string + ".jar";
            archiveReferenceModel = this.archiveFactory.createArchiveReferenceModel();
            archiveReferenceModel.setPath(string2);
            try {
                URL uRL = null;
                uRL = iPluginEntryArray[n] instanceof PluginEntryModel && !((PluginEntryModel)((Object)iPluginEntryArray[n])).isUnpack() ? new URL(this.getSite().getURL(), "plugins/" + string + ".jar") : new URL(this.getSite().getURL(), "plugins/" + string + File.separator);
                archiveReferenceModel.setURLString(uRL.toExternalForm());
                archiveReferenceModel.resolve(uRL, null);
                ((SiteFile)this.getSite()).addArchiveReferenceModel(archiveReferenceModel);
            }
            catch (MalformedURLException malformedURLException) {
                String string3 = this.getSite().getURL() != null ? this.getSite().getURL().toExternalForm() : "";
                string3 = String.valueOf(string3) + "plugins/" + iPluginEntryArray[n].toString();
                throw Utilities.newCoreException(NLS.bind((String)Messages.SiteFile_UnableToCreateURL, (Object[])new String[]{string3}), malformedURLException);
            }
            ++n;
        }
    }

    private void addContentConsumers(ContentConsumer contentConsumer) {
        if (this.contentConsumers == null) {
            this.contentConsumers = new ArrayList();
        }
        this.contentConsumers.add(contentConsumer);
    }
}

