/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.internal.core.Messages;

public final class SiteTypeFactory {
    public static final String SIMPLE_EXTENSION_ID = "siteTypes";
    private static SiteTypeFactory inst;
    private Map factories;

    private SiteTypeFactory() {
    }

    public static SiteTypeFactory getInstance() {
        if (inst == null) {
            inst = new SiteTypeFactory();
        }
        return inst;
    }

    public ISiteFactory getFactory(String string) throws CoreException {
        Object object = this.getFactories().get(string);
        if (object == null) {
            object = this.createFactoryFor(string);
            this.getFactories().put(string, object);
        }
        return (ISiteFactory)object;
    }

    private ISiteFactory createFactoryFor(String string) throws CoreException {
        ISiteFactory iSiteFactory = null;
        String string2 = AppPlugin.getPlugin().getBundle().getSymbolicName();
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(string2, SIMPLE_EXTENSION_ID, string);
        if (iConfigurationElementArray == null || iConfigurationElementArray.length == 0) {
            throw Utilities.newCoreException(NLS.bind((String)Messages.SiteTypeFactory_UnableToFindSiteFactory, (Object[])new String[]{string}), null);
        }
        IConfigurationElement iConfigurationElement = iConfigurationElementArray[0];
        iSiteFactory = (ISiteFactory)iConfigurationElement.createExecutableExtension("class");
        return iSiteFactory;
    }

    private Map getFactories() {
        if (this.factories == null) {
            this.factories = new HashMap();
        }
        return this.factories;
    }
}

