/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.mirror;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.JarContentReference;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.Utilities;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.internal.mirror.MirrorSite;
import org.eclipse.update.internal.mirror.MirrorSiteFactory;
import org.eclipse.update.standalone.ScriptedCommand;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class MirrorCommand
extends ScriptedCommand {
    private String featureId;
    private String featureVersion;
    private String fromSiteUrl;
    private String toSiteDir;
    private String mirrorURL;
    private MirrorSite mirrorSite;

    public MirrorCommand(String string, String string2, String string3, String string4, String string5) {
        this.featureId = string;
        this.featureVersion = string2;
        this.fromSiteUrl = string3;
        this.toSiteDir = string4;
        this.mirrorURL = string5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(IProgressMonitor iProgressMonitor) {
        if (!this.validateParameters()) {
            return false;
        }
        try {
            block8: {
                try {
                    if (this.getMirrorSite() == null) {
                        break block8;
                    }
                    URL uRL = new URL(this.fromSiteUrl);
                    ISite iSite = SiteManager.getSite(uRL, (IProgressMonitor)new NullProgressMonitor());
                    ISiteFeatureReference[] iSiteFeatureReferenceArray = this.findFeaturesToMirror(iSite);
                    if (iSiteFeatureReferenceArray.length == 0) {
                        StandaloneUpdateApplication.exceptionLogged();
                        AppPlugin.log(Utilities.newCoreException("No matching features found on " + uRL + ".", null));
                        break block8;
                    }
                    this.mirrorSite.mirrorAndExpose(iSite, iSiteFeatureReferenceArray, null, this.mirrorURL);
                    Object var5_3 = null;
                }
                catch (MalformedURLException malformedURLException) {
                    StandaloneUpdateApplication.exceptionLogged();
                    AppPlugin.log(malformedURLException);
                }
                catch (CoreException coreException) {
                    StandaloneUpdateApplication.exceptionLogged();
                    AppPlugin.log(coreException);
                }
                JarContentReference.shutdown();
                return true;
            }
            Object var5_2 = null;
            JarContentReference.shutdown();
            return false;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            JarContentReference.shutdown();
            throw throwable;
        }
    }

    private boolean validateParameters() {
        if (this.fromSiteUrl == null || this.fromSiteUrl.length() <= 0) {
            StandaloneUpdateApplication.exceptionLogged();
            AppPlugin.log(Utilities.newCoreException("from parameter is missing.", null));
            return false;
        }
        try {
            new URL(this.fromSiteUrl);
        }
        catch (MalformedURLException malformedURLException) {
            StandaloneUpdateApplication.exceptionLogged();
            AppPlugin.log(Utilities.newCoreException("from must be a valid URL", null));
            return false;
        }
        if (this.toSiteDir == null || this.toSiteDir.length() <= 0) {
            StandaloneUpdateApplication.exceptionLogged();
            AppPlugin.log(Utilities.newCoreException("to parameter is missing.", null));
            return false;
        }
        return true;
    }

    private MirrorSite getMirrorSite() throws MalformedURLException, CoreException {
        if (this.mirrorSite == null) {
            if (this.toSiteDir != null) {
                MirrorSiteFactory mirrorSiteFactory = new MirrorSiteFactory();
                System.out.print("Analyzing features already mirrored ...");
                try {
                    this.mirrorSite = (MirrorSite)mirrorSiteFactory.createSite(new File(this.toSiteDir));
                }
                catch (InvalidSiteTypeException invalidSiteTypeException) {}
                System.out.println("  Done.");
            }
            if (this.mirrorSite == null) {
                StandaloneUpdateApplication.exceptionLogged();
                AppPlugin.log(Utilities.newCoreException("Mirror site at " + this.toSiteDir + " cannot be accessed.", null));
                return null;
            }
        }
        return this.mirrorSite;
    }

    private ISiteFeatureReference[] findFeaturesToMirror(ISite iSite) throws CoreException {
        ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getRawFeatureReferences();
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = this.mirrorSite.getFeatureReferenceModels();
        ArrayList<ISiteFeatureReference> arrayList = new ArrayList<ISiteFeatureReference>();
        PluginVersionIdentifier pluginVersionIdentifier = null;
        if (this.featureId == null) {
            System.out.println("Parameter feature not specified.  All features on the remote site will be mirrored.");
        }
        if (this.featureVersion == null) {
            System.out.println("Parameter version not specified.  All versions of features on the remote site will be mirrored.");
        } else {
            pluginVersionIdentifier = new PluginVersionIdentifier(this.featureVersion);
        }
        int n = 0;
        while (n < iSiteFeatureReferenceArray.length) {
            VersionedIdentifier versionedIdentifier = iSiteFeatureReferenceArray[n].getVersionedIdentifier();
            if ((this.featureId == null || this.featureId.equals(versionedIdentifier.getIdentifier())) && (pluginVersionIdentifier == null || pluginVersionIdentifier.isPerfect(versionedIdentifier.getVersion()))) {
                int n2 = 0;
                while (n2 < siteFeatureReferenceModelArray.length) {
                    if (siteFeatureReferenceModelArray[n2].getVersionedIdentifier().equals(versionedIdentifier)) {
                        System.out.println("Feature " + versionedIdentifier + " already mirrored and exposed.");
                    }
                    ++n2;
                }
                String string = ((SiteFeatureReference)iSiteFeatureReferenceArray[n]).getType();
                if (string != null && !"org.eclipse.ercp.update.packaged".equals(string)) {
                    throw Utilities.newCoreException("Feature " + versionedIdentifier + " is of type " + string + ".  Only features of type " + "org.eclipse.ercp.update.packaged" + " are supported.", null);
                }
                arrayList.add(iSiteFeatureReferenceArray[n]);
                System.out.println("Feature " + iSiteFeatureReferenceArray[n].getVersionedIdentifier() + " will be mirrored.");
            }
            ++n;
        }
        return arrayList.toArray(new ISiteFeatureReference[arrayList.size()]);
    }
}

