/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.mirror;

import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.ICategory;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureContentProvider;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.INonPluginEntry;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.IURLEntry;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.FeatureReferenceModel;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.standalone.StandaloneUpdateApplication;

public class MirrorSite
extends Site {
    private static final String INDENT = "   ";
    private SiteModelFactory factory;
    private Collection downloadedPluginEntries = new ArrayList();
    private Collection downloadedFeatureReferenceModels = new ArrayList();

    public MirrorSite(SiteModelFactory siteModelFactory) {
        this.factory = siteModelFactory;
    }

    public void mirrorAndExpose(ISite iSite, ISiteFeatureReference[] iSiteFeatureReferenceArray, IFeatureReference[] iFeatureReferenceArray, String string) throws CoreException {
        this.mirrorAndExposeFeatures(iSite, iSiteFeatureReferenceArray, iFeatureReferenceArray);
        System.out.println("Installing features finished. Updating categories ...");
        this.updateCategories(iSite);
        System.out.println("Updating categories finished. Updating site description ...");
        this.updateDescription(iSite);
        System.out.println("Updating site description finished. Saving site.xml ...");
        this.save();
        if (string != null) {
            this.generateUpdatePolicy(string);
        }
    }

    private void mirrorAndExposeFeatures(ISite iSite, ISiteFeatureReference[] iSiteFeatureReferenceArray, IFeatureReference[] iFeatureReferenceArray) throws CoreException {
        int n;
        ICategory[] iCategoryArray;
        SiteFeatureReferenceModel siteFeatureReferenceModel;
        IFeature iFeature;
        ArrayList<ISiteFeatureReference> arrayList = new ArrayList<ISiteFeatureReference>();
        int n2 = 0;
        while (n2 < iSiteFeatureReferenceArray.length) {
            try {
                iFeature = iSiteFeatureReferenceArray[n2].getFeature((IProgressMonitor)new NullProgressMonitor());
                siteFeatureReferenceModel = this.mirrorFeature(iSite, iFeature, iFeatureReferenceArray, 1);
                iCategoryArray = iSiteFeatureReferenceArray[n2].getCategories();
                n = 0;
                while (n < iCategoryArray.length) {
                    siteFeatureReferenceModel.addCategoryName(iCategoryArray[n].getName());
                    ++n;
                }
                this.addFeatureReferenceModel(iSite, siteFeatureReferenceModel);
            }
            catch (CoreException coreException) {
                arrayList.add(iSiteFeatureReferenceArray[n2]);
            }
            ++n2;
        }
        if (arrayList.size() <= 0) {
            return;
        }
        iSiteFeatureReferenceArray = arrayList.toArray(new ISiteFeatureReference[arrayList.size()]);
        n2 = 0;
        while (n2 < iSiteFeatureReferenceArray.length) {
            iFeature = iSiteFeatureReferenceArray[n2].getFeature((IProgressMonitor)new NullProgressMonitor());
            siteFeatureReferenceModel = this.mirrorFeature(iSite, iFeature, iFeatureReferenceArray, 1);
            iCategoryArray = iSiteFeatureReferenceArray[n2].getCategories();
            n = 0;
            while (n < iCategoryArray.length) {
                siteFeatureReferenceModel.addCategoryName(iCategoryArray[n].getName());
                ++n;
            }
            this.addFeatureReferenceModel(iSite, siteFeatureReferenceModel);
            ++n2;
        }
    }

    private SiteFeatureReferenceModel mirrorFeature(ISite iSite, IFeature iFeature, IFeatureReference[] iFeatureReferenceArray, int n) throws CoreException {
        Object object;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + " ";
            ++n2;
        }
        System.out.println(String.valueOf(string) + "Mirroring feature " + iFeature.getVersionedIdentifier() + " ...");
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = this.getDownloadedFeatureReferenceModels();
        int n3 = 0;
        while (n3 < siteFeatureReferenceModelArray.length) {
            if (siteFeatureReferenceModelArray[n3].getVersionedIdentifier().equals(iFeature.getVersionedIdentifier())) {
                System.out.println(String.valueOf(string) + "Feature " + iFeature.getVersionedIdentifier() + " already exists.  Skipping downloading.");
                return siteFeatureReferenceModelArray[n3];
            }
            ++n3;
        }
        IFeatureContentProvider iFeatureContentProvider = iFeature.getFeatureContentProvider();
        System.out.println(String.valueOf(string) + "Getting plugin entries for " + iFeature.getVersionedIdentifier() + " ...");
        IPluginEntry[] iPluginEntryArray = iFeature.getPluginEntries();
        IPluginEntry[] iPluginEntryArray2 = UpdateManagerUtils.diff(iPluginEntryArray, this.getDownloadedPluginEntries());
        System.out.println(String.valueOf(string) + "Getting non plugin entries for " + iFeature.getVersionedIdentifier() + " ...");
        INonPluginEntry[] iNonPluginEntryArray = iFeature.getRawNonPluginEntries();
        System.out.println(String.valueOf(string) + "Getting included features for " + iFeature.getVersionedIdentifier() + " ...");
        IFeatureReference[] iFeatureReferenceArray2 = iFeature.getRawIncludedFeatureReferences();
        if (iFeatureReferenceArray != null) {
            iFeatureReferenceArray2 = UpdateManagerUtils.optionalChildrenToInstall(iFeatureReferenceArray2, iFeatureReferenceArray);
        }
        System.out.println(String.valueOf(string) + "Downloading feature archives for " + iFeature.getVersionedIdentifier() + " ...");
        iFeatureContentProvider.getFeatureEntryArchiveReferences(null);
        System.out.println(String.valueOf(string) + "Downloading plug-in archives for " + iFeature.getVersionedIdentifier() + " ...");
        int n4 = 0;
        while (n4 < iPluginEntryArray2.length) {
            iFeatureContentProvider.getPluginEntryArchiveReferences(iPluginEntryArray2[n4], null);
            ++n4;
        }
        System.out.println(String.valueOf(string) + "Downloading non plug-in archives for " + iFeature.getVersionedIdentifier() + " ...");
        n4 = 0;
        while (n4 < iNonPluginEntryArray.length) {
            iFeatureContentProvider.getNonPluginEntryArchiveReferences(iNonPluginEntryArray[n4], null);
            ++n4;
        }
        System.out.println(String.valueOf(string) + "Installing child features for " + iFeature.getVersionedIdentifier() + " ...");
        n4 = 0;
        while (n4 < iFeatureReferenceArray2.length) {
            object = iFeatureReferenceArray2[n4].getFeature(null);
            this.mirrorFeature(iSite, (IFeature)object, iFeatureReferenceArray, n + 1);
            ++n4;
        }
        System.out.println(String.valueOf(string) + "Storing plug-in archives for " + iFeature.getVersionedIdentifier() + " ...");
        n4 = 0;
        while (n4 < iPluginEntryArray2.length) {
            object = iFeatureContentProvider.getPluginEntryArchiveReferences(iPluginEntryArray2[n4], null);
            this.storePluginArchive(object[0]);
            this.addDownloadedPluginEntry(iPluginEntryArray2[n4]);
            ++n4;
        }
        System.out.println(String.valueOf(string) + "Storing non plug-in archives for " + iFeature.getVersionedIdentifier() + " ...");
        n4 = 0;
        while (n4 < iNonPluginEntryArray.length) {
            object = iFeatureContentProvider.getNonPluginEntryArchiveReferences(iNonPluginEntryArray[n4], null);
            int n5 = 0;
            while (n5 < ((ContentReference[])object).length) {
                this.storeNonPluginArchive(iFeature.getVersionedIdentifier(), object[n5]);
                ++n5;
            }
            ++n4;
        }
        System.out.println(String.valueOf(string) + "Storing feature archives for " + iFeature.getVersionedIdentifier() + " ...");
        ContentReference[] contentReferenceArray = iFeatureContentProvider.getFeatureEntryArchiveReferences(null);
        this.storeFeatureArchive(contentReferenceArray[0]);
        System.out.println(String.valueOf(string) + "Adding feature " + iFeature.getVersionedIdentifier() + " to model ...");
        object = this.factory.createFeatureReferenceModel();
        ((FeatureReferenceModel)((Object)object)).setSiteModel(this);
        ((FeatureReferenceModel)((Object)object)).setType("org.eclipse.ercp.update.packaged");
        ((FeatureReferenceModel)((Object)object)).setFeatureIdentifier(iFeature.getVersionedIdentifier().getIdentifier());
        ((FeatureReferenceModel)((Object)object)).setFeatureVersion(iFeature.getVersionedIdentifier().getVersion().toString());
        this.addDownloadedFeatureReferenceModel((SiteFeatureReferenceModel)object);
        System.out.println(String.valueOf(string) + "Mirroring feature " + iFeature.getVersionedIdentifier() + " finished.");
        return object;
    }

    public void addFeatureReferenceModel(ISite iSite, SiteFeatureReferenceModel siteFeatureReferenceModel) {
        ISiteFeatureReference[] iSiteFeatureReferenceArray = iSite.getRawFeatureReferences();
        int n = 0;
        while (n < iSiteFeatureReferenceArray.length) {
            ISiteFeatureReference iSiteFeatureReference = iSiteFeatureReferenceArray[n];
            try {
                if (iSiteFeatureReference.getVersionedIdentifier().equals(siteFeatureReferenceModel.getVersionedIdentifier())) {
                    this.addFeatureReferenceModel(siteFeatureReferenceModel);
                }
            }
            catch (CoreException coreException) {
                StandaloneUpdateApplication.exceptionLogged();
                AppPlugin.log(coreException);
            }
            ++n;
        }
        this.save();
        System.out.println("Feature " + siteFeatureReferenceModel.getVersionedIdentifier() + " added to site.xml.");
    }

    public void addFeatureReferenceModel(SiteFeatureReferenceModel siteFeatureReferenceModel) {
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = this.getFeatureReferenceModels();
        int n = 0;
        while (n < siteFeatureReferenceModelArray.length) {
            if (siteFeatureReferenceModelArray[n].getVersionedIdentifier().equals(siteFeatureReferenceModel.getVersionedIdentifier())) {
                super.removeFeatureReferenceModel(siteFeatureReferenceModelArray[n]);
            }
            ++n;
        }
        super.addFeatureReferenceModel(siteFeatureReferenceModel);
    }

    /*
     * Exception decompiling
     */
    private void storeFeatureArchive(ContentReference var1_1) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 119->123)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void storePluginArchive(ContentReference var1_1) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 97->101)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void storeNonPluginArchive(VersionedIdentifier var1_1, ContentReference var2_2) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 148->152)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private void save() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 113->117)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void save(PrintWriter printWriter) {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeSite("", printWriter);
    }

    private void writeSite(String string, PrintWriter printWriter) {
        printWriter.print(String.valueOf(string) + "<site");
        String string2 = String.valueOf(string) + INDENT;
        printWriter.println(">");
        URLEntryModel uRLEntryModel = this.getDescriptionModel();
        if (uRLEntryModel != null) {
            printWriter.println();
            this.writeDescription(string2, printWriter, uRLEntryModel);
            printWriter.println();
        }
        this.writeFeatures(string2, printWriter);
        this.writeCategories(string2, printWriter);
        printWriter.println(String.valueOf(string) + "</site>");
    }

    private void writeFeatures(String string, PrintWriter printWriter) {
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = this.getFeatureReferenceModels();
        int n = 0;
        while (n < siteFeatureReferenceModelArray.length) {
            printWriter.print(string);
            printWriter.print("<feature");
            printWriter.print(" url=\"features/" + siteFeatureReferenceModelArray[n].getFeatureIdentifier() + "_" + siteFeatureReferenceModelArray[n].getFeatureVersion() + ".jar\"");
            printWriter.print(" id=\"" + siteFeatureReferenceModelArray[n].getFeatureIdentifier() + "\"");
            printWriter.print(" version=\"" + siteFeatureReferenceModelArray[n].getFeatureVersion() + "\"");
            printWriter.println(">");
            String[] stringArray = siteFeatureReferenceModelArray[n].getCategoryNames();
            int n2 = 0;
            while (n2 < stringArray.length) {
                printWriter.print(String.valueOf(string) + INDENT);
                printWriter.println("<category name=\"" + stringArray[n2] + "\" />");
                ++n2;
            }
            printWriter.print(string);
            printWriter.println("</feature>");
            printWriter.println();
            ++n;
        }
    }

    private void writeCategories(String string, PrintWriter printWriter) {
        CategoryModel[] categoryModelArray = this.getCategoryModels();
        if (categoryModelArray.length <= 0) {
            return;
        }
        int n = 0;
        while (n < categoryModelArray.length) {
            printWriter.print(string);
            printWriter.print("<category-def");
            printWriter.print(" name=\"" + categoryModelArray[n].getName() + "\" label=\"" + categoryModelArray[n].getLabel() + "\"");
            printWriter.println(">");
            if (categoryModelArray[n].getDescriptionModel() != null) {
                this.writeDescription(String.valueOf(string) + INDENT, printWriter, categoryModelArray[n].getDescriptionModel());
            }
            printWriter.print(string);
            printWriter.println("</category-def>");
            printWriter.println();
            ++n;
        }
    }

    private void writeDescription(String string, PrintWriter printWriter, URLEntryModel uRLEntryModel) {
        String string2 = uRLEntryModel.getURLString();
        String string3 = uRLEntryModel.getAnnotationNonLocalized();
        if (string2 == null && string3 == null && string3.length() <= 0) {
            return;
        }
        printWriter.print(string);
        printWriter.print("<description");
        if (string2 != null) {
            printWriter.print(" url=\"" + string2 + "\"");
        }
        if (string3 == null || string3.length() <= 0) {
            printWriter.println(" />");
        } else {
            printWriter.println(">");
            if (string3 != null) {
                printWriter.println(String.valueOf(string) + INDENT + UpdateManagerUtils.Writer.xmlSafe(string3));
            }
            printWriter.println(String.valueOf(string) + "</description>");
        }
    }

    public void addDownloadedPluginEntry(IPluginEntry iPluginEntry) {
        this.downloadedPluginEntries.add(iPluginEntry);
    }

    private IPluginEntry[] getDownloadedPluginEntries() {
        return this.downloadedPluginEntries.toArray(new IPluginEntry[this.downloadedPluginEntries.size()]);
    }

    public void addDownloadedFeatureReferenceModel(SiteFeatureReferenceModel siteFeatureReferenceModel) {
        this.downloadedFeatureReferenceModels.add(siteFeatureReferenceModel);
    }

    private SiteFeatureReferenceModel[] getDownloadedFeatureReferenceModels() {
        return this.downloadedFeatureReferenceModels.toArray(new SiteFeatureReferenceModel[this.downloadedFeatureReferenceModels.size()]);
    }

    private void updateDescription(ISite iSite) {
        IURLEntry iURLEntry = iSite.getDescription();
        if (iURLEntry != null) {
            URLEntryModel uRLEntryModel = new URLEntryModel();
            URL uRL = iURLEntry.getURL();
            uRLEntryModel.setAnnotation(iURLEntry.getAnnotation());
            uRLEntryModel.setURLString(uRL.toExternalForm());
            this.setDescriptionModel(uRLEntryModel);
        }
    }

    private void updateCategories(ISite iSite) {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = this.getFeatureReferenceModels();
        int n = 0;
        while (n < siteFeatureReferenceModelArray.length) {
            object = siteFeatureReferenceModelArray[n].getCategoryNames();
            int n2 = 0;
            while (n2 < ((Object)object).length) {
                hashSet.add(object[n2]);
                ++n2;
            }
            ++n;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        object = hashSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            ICategory iCategory = iSite.getCategory(string);
            if (iCategory == null) {
                CategoryModel categoryModel = null;
                try {
                    categoryModel = (CategoryModel)((Object)this.getCategory(string));
                }
                catch (NullPointerException nullPointerException) {}
                if (categoryModel == null) continue;
                arrayList.add((Object)categoryModel);
                continue;
            }
            arrayList.add(iCategory);
        }
        this.setCategoryModels(arrayList.toArray(new CategoryModel[arrayList.size()]));
    }

    /*
     * Exception decompiling
     */
    private void generateUpdatePolicy(String var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 156->160)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeUrlMaps(PrintWriter printWriter, String string) {
        SiteFeatureReferenceModel[] siteFeatureReferenceModelArray = this.getFeatureReferenceModels();
        int n = 0;
        while (n < siteFeatureReferenceModelArray.length) {
            printWriter.print("\t");
            printWriter.print("<url-map");
            printWriter.print(" pattern=\"" + siteFeatureReferenceModelArray[n].getFeatureIdentifier() + "\"");
            printWriter.print(" url=\"" + string + "\"");
            printWriter.println(" />");
            ++n;
        }
    }
}

