/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.core.model.ModelObject;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.model.ConfigurationPolicyModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class ConfiguredSiteModel
extends ModelObject {
    private String[] previousPluginPath;
    private SiteModel site;
    private String platformURLString;
    private ConfigurationPolicyModel policy;
    private InstallConfigurationModel installConfiguration;
    private boolean installable = false;

    public SiteModel getSiteModel() {
        return this.site;
    }

    public void setSiteModel(SiteModel siteModel) {
        this.assertIsWriteable();
        this.site = siteModel;
    }

    public ConfigurationPolicyModel getConfigurationPolicyModel() {
        return this.policy;
    }

    public void setConfigurationPolicyModel(ConfigurationPolicyModel configurationPolicyModel) {
        this.assertIsWriteable();
        this.policy = configurationPolicyModel;
        configurationPolicyModel.setConfiguredSiteModel(this);
    }

    public boolean isUpdatable() {
        return this.installable;
    }

    public void setUpdatable(boolean bl) {
        this.assertIsWriteable();
        this.installable = bl;
    }

    public InstallConfigurationModel getInstallConfigurationModel() {
        return this.installConfiguration;
    }

    public void setInstallConfigurationModel(InstallConfigurationModel installConfigurationModel) {
        this.assertIsWriteable();
        this.installConfiguration = installConfigurationModel;
    }

    public String getPlatformURLString() {
        return this.platformURLString;
    }

    public void setPlatformURLString(String string) {
        this.platformURLString = string;
    }

    public String[] getPreviousPluginPath() {
        if (this.previousPluginPath == null) {
            this.previousPluginPath = new String[0];
        }
        return this.previousPluginPath;
    }

    public void setPreviousPluginPath(String[] stringArray) {
        this.previousPluginPath = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.previousPluginPath, 0, stringArray.length);
    }

    protected IStatus createStatus(int n, String string, Exception exception) {
        if (n != 0) {
            n = 4;
        }
        return this.createStatus(n, 0, string.toString(), exception);
    }

    protected IStatus createStatus(int n, int n2, String string, Exception exception) {
        String string2 = AppPlugin.getPlugin().getBundle().getSymbolicName();
        StringBuffer stringBuffer = new StringBuffer("");
        if (string != null) {
            stringBuffer.append(string);
        }
        if (exception != null) {
            stringBuffer.append("\r\n[");
            stringBuffer.append(exception.toString());
            stringBuffer.append("]\r\n");
        }
        return new Status(n, string2, n2, stringBuffer.toString(), (Throwable)exception);
    }

    public boolean isEnabled() {
        return this.getConfigurationPolicyModel().isEnabled();
    }

    public void setEnabled(boolean bl) {
        this.getConfigurationPolicyModel().setEnabled(bl);
    }
}

