/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.configurator.FeatureEntry;
import org.eclipse.update.internal.configurator.PlatformConfiguration;
import org.eclipse.update.internal.configurator.SiteEntry;
import org.eclipse.update.internal.core.Assert;
import org.eclipse.update.internal.core.BaseSiteLocalFactory;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.model.ConfiguredSiteModel;
import org.eclipse.update.internal.model.InstallConfigurationModel;

public class InstallConfigurationParser {
    private PlatformConfiguration platformConfig;
    private URL siteURL;
    private InstallConfigurationModel config;
    private ConfiguredSiteModel configSite;

    public InstallConfigurationParser(IPlatformConfiguration iPlatformConfiguration, InstallConfigurationModel installConfigurationModel, boolean bl) throws IOException, CoreException {
        Assert.isTrue(iPlatformConfiguration instanceof PlatformConfiguration);
        this.platformConfig = (PlatformConfiguration)iPlatformConfiguration;
        this.config = installConfigurationModel;
        if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
            AppPlugin.debug("Start parsing Configuration:" + installConfigurationModel.getURL().toExternalForm());
        }
        if (bl) {
            this.processConfigurationLight(this.platformConfig);
        } else {
            this.processConfig(this.platformConfig);
        }
    }

    private void processSite(SiteEntry siteEntry) throws CoreException, IOException {
        this.siteURL = siteEntry.getURL();
        try {
            this.siteURL = Platform.asLocalURL((URL)this.siteURL);
            if (this.siteURL.getProtocol().equals("file")) {
                this.siteURL = new File(this.siteURL.getFile()).toURL();
            }
        }
        catch (IOException iOException) {}
        ISite iSite = SiteManager.getSite(this.siteURL, null);
        BaseSiteLocalFactory baseSiteLocalFactory = new BaseSiteLocalFactory();
        this.configSite = baseSiteLocalFactory.createConfigurationSiteModel((SiteModel)((Object)iSite), siteEntry.getSitePolicy().getType());
        this.configSite.setPlatformURLString(siteEntry.getURL().toExternalForm());
        this.configSite.setEnabled(siteEntry.isEnabled());
        this.configSite.setUpdatable(siteEntry.isUpdateable());
        this.config.addConfigurationSiteModel(this.configSite);
        this.configSite.setInstallConfigurationModel(this.config);
        FeatureEntry[] featureEntryArray = siteEntry.getFeatureEntries();
        int n = 0;
        while (n < featureEntryArray.length) {
            this.processFeature(featureEntryArray[n]);
            ++n;
        }
    }

    private void processFeature(FeatureEntry featureEntry) throws CoreException, IOException {
        String string = featureEntry.getURL();
        URL uRL = UpdateManagerUtils.getURL(this.siteURL, string, null);
        if (uRL != null) {
            SiteFeatureReference siteFeatureReference = new SiteFeatureReference();
            siteFeatureReference.setSite((ISite)((Object)this.configSite.getSiteModel()));
            siteFeatureReference.setURL(uRL);
            this.configSite.getConfigurationPolicyModel().addConfiguredFeatureReference(siteFeatureReference);
            if (AppPlugin.DEBUG && AppPlugin.DEBUG_SHOW_PARSING) {
                AppPlugin.debug("End Processing DefaultFeature Tag: url:" + uRL.toExternalForm());
            }
        } else {
            AppPlugin.log(Messages.InstallConfigurationParser_FeatureReferenceNoURL, new Exception());
        }
    }

    private void processConfig(PlatformConfiguration platformConfiguration) throws IOException, CoreException {
        this.processConfigurationLight(platformConfiguration);
        SiteEntry[] siteEntryArray = platformConfiguration.getConfiguration().getSites();
        int n = 0;
        while (n < siteEntryArray.length) {
            this.processSite(siteEntryArray[n]);
            ++n;
        }
    }

    private void processConfigurationLight(PlatformConfiguration platformConfiguration) {
        Date date = new Date(platformConfiguration.getChangeStamp());
        this.config.setCreationDate(date);
        this.config.setLabel(date.toString());
        this.config.setCurrent(date.equals(PlatformConfiguration.getCurrent().getConfiguration().getDate()));
    }
}

