/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ercp.update.AppPlugin;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.operations.UpdateUtils;

public class FeatureHierarchyElement {
    private Object root;
    private ArrayList children;
    private IFeatureReference oldFeatureRef;
    private IFeatureReference newFeatureRef;
    private boolean checked;
    private boolean optionalChildren;
    private boolean nativeUpgrade = false;

    public FeatureHierarchyElement(IFeatureReference iFeatureReference, IFeatureReference iFeatureReference2) {
        this.oldFeatureRef = iFeatureReference;
        this.newFeatureRef = iFeatureReference2;
    }

    public void setRoot(Object object) {
        this.root = object;
    }

    public Object getRoot() {
        return this.root;
    }

    public boolean isEditable() {
        if (!this.isOptional()) {
            return false;
        }
        return this.oldFeatureRef == null;
    }

    public boolean isFalseUpdate() {
        if (this.oldFeatureRef != null && this.newFeatureRef != null) {
            try {
                return this.oldFeatureRef.getVersionedIdentifier().equals(this.newFeatureRef.getVersionedIdentifier());
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    public boolean isOptional() {
        return this.newFeatureRef instanceof IIncludedFeatureReference && ((IIncludedFeatureReference)this.newFeatureRef).isOptional();
    }

    public boolean isChecked() {
        return this.checked;
    }

    void setNativeUpgrade(boolean bl) {
        this.nativeUpgrade = bl;
    }

    public boolean isEnabled(IInstallConfiguration iInstallConfiguration) {
        if (this.nativeUpgrade) {
            return true;
        }
        if (this.isOptional() && this.oldFeatureRef != null) {
            try {
                IFeature iFeature = this.oldFeatureRef.getFeature(null);
                IConfiguredSite iConfiguredSite = UpdateUtils.getConfigSite(iFeature, iInstallConfiguration);
                return iConfiguredSite.isConfigured(iFeature);
            }
            catch (CoreException coreException) {}
        }
        return true;
    }

    public IFeature getFeature() {
        try {
            IFeature iFeature = this.newFeatureRef.getFeature(null);
            return iFeature;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public void setChecked(boolean bl) {
        this.checked = bl;
    }

    public String getLabel() {
        try {
            return this.getFeatureLabel(this.newFeatureRef);
        }
        catch (CoreException coreException) {
            Object object;
            if (this.newFeatureRef instanceof IIncludedFeatureReference && (object = ((IIncludedFeatureReference)this.newFeatureRef).getName()) != null) {
                return object;
            }
            try {
                object = this.newFeatureRef.getVersionedIdentifier();
                return ((VersionedIdentifier)object).toString();
            }
            catch (CoreException coreException2) {
                return null;
            }
        }
    }

    private String getFeatureLabel(IFeatureReference iFeatureReference) throws CoreException {
        IFeature iFeature = iFeatureReference.getFeature(null);
        return String.valueOf(iFeature.getLabel()) + " " + iFeature.getVersionedIdentifier().getVersion().toString();
    }

    public FeatureHierarchyElement[] getChildren(boolean bl, boolean bl2, IInstallConfiguration iInstallConfiguration) {
        this.computeChildren(bl, bl2, iInstallConfiguration);
        FeatureHierarchyElement[] featureHierarchyElementArray = new FeatureHierarchyElement[this.children.size()];
        this.children.toArray(featureHierarchyElementArray);
        return featureHierarchyElementArray;
    }

    public FeatureHierarchyElement[] getChildren() {
        if (this.children != null) {
            FeatureHierarchyElement[] featureHierarchyElementArray = new FeatureHierarchyElement[this.children.size()];
            this.children.toArray(featureHierarchyElementArray);
            return featureHierarchyElementArray;
        }
        return new FeatureHierarchyElement[0];
    }

    public void computeChildren(boolean bl, boolean bl2, IInstallConfiguration iInstallConfiguration) {
        if (this.children == null) {
            this.children = new ArrayList();
            try {
                IFeature iFeature = null;
                IFeature iFeature2 = null;
                iFeature2 = this.newFeatureRef.getFeature(null);
                if (this.oldFeatureRef != null) {
                    iFeature = this.oldFeatureRef.getFeature(null);
                }
                this.optionalChildren = FeatureHierarchyElement.computeElements(iFeature, iFeature2, bl, bl2, iInstallConfiguration, this.children);
                int n = 0;
                while (n < this.children.size()) {
                    FeatureHierarchyElement featureHierarchyElement = (FeatureHierarchyElement)this.children.get(n);
                    featureHierarchyElement.setRoot(this.getRoot());
                    ++n;
                }
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean hasOptionalChildren() {
        return this.optionalChildren;
    }

    public void addCheckedOptionalFeatures(boolean bl, boolean bl2, IInstallConfiguration iInstallConfiguration, Set set) {
        if (this.isOptional() && this.isChecked() && (!bl || !this.isFalseUpdate())) {
            set.add(this.newFeatureRef);
        }
        FeatureHierarchyElement[] featureHierarchyElementArray = this.getChildren(bl, bl2, iInstallConfiguration);
        int n = 0;
        while (n < featureHierarchyElementArray.length) {
            featureHierarchyElementArray[n].addCheckedOptionalFeatures(bl, bl2, iInstallConfiguration, set);
            ++n;
        }
    }

    public static boolean computeElements(IFeature iFeature, IFeature iFeature2, boolean bl, boolean bl2, IInstallConfiguration iInstallConfiguration, ArrayList arrayList) {
        Object[] objectArray = null;
        Object[] objectArray2 = FeatureHierarchyElement.getIncludedFeatures(iFeature2);
        boolean bl3 = false;
        try {
            if (iFeature != null) {
                objectArray = FeatureHierarchyElement.getIncludedFeatures(iFeature);
            }
            int n = 0;
            while (n < objectArray2.length) {
                Object object;
                IFeatureReference iFeatureReference = null;
                IFeatureReference iFeatureReference2 = (IFeatureReference)objectArray2[n];
                if (objectArray != null) {
                    object = iFeatureReference2.getVersionedIdentifier().getIdentifier();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        block18: {
                            IFeatureReference iFeatureReference3 = (IFeatureReference)objectArray[n2];
                            try {
                                if (!iFeatureReference3.getVersionedIdentifier().getIdentifier().equals(object)) break block18;
                                iFeatureReference = iFeatureReference3;
                                break;
                            }
                            catch (CoreException coreException) {}
                        }
                        ++n2;
                    }
                } else if (bl2 && !UpdateUtils.isPatch(iFeature2)) {
                    iFeatureReference = FeatureHierarchyElement.findPatchedReference(iFeatureReference2, iInstallConfiguration);
                }
                if (iFeatureReference != null && (iFeatureReference instanceof IIncludedFeatureReference && ((IIncludedFeatureReference)iFeatureReference).isOptional() || bl2)) {
                    try {
                        object = iFeatureReference.getFeature(null);
                        if (object == null) {
                            iFeatureReference = null;
                        }
                    }
                    catch (CoreException coreException) {
                        iFeatureReference = null;
                    }
                }
                if (((FeatureHierarchyElement)(object = new FeatureHierarchyElement(iFeatureReference, iFeatureReference2))).isOptional() && (bl || bl2)) {
                    ((FeatureHierarchyElement)object).setChecked(iFeatureReference != null);
                    if (iFeatureReference == null && FeatureHierarchyElement.hasOlderVersion(iFeatureReference2)) {
                        ((FeatureHierarchyElement)object).setNativeUpgrade(true);
                        ((FeatureHierarchyElement)object).setChecked(true);
                    }
                } else {
                    ((FeatureHierarchyElement)object).setChecked(true);
                }
                arrayList.add(object);
                ((FeatureHierarchyElement)object).computeChildren(bl, bl2, iInstallConfiguration);
                if (((FeatureHierarchyElement)object).isOptional() || ((FeatureHierarchyElement)object).hasOptionalChildren()) {
                    bl3 = true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return bl3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasOlderVersion(IFeatureReference iFeatureReference) {
        try {
            VersionedIdentifier versionedIdentifier = iFeatureReference.getVersionedIdentifier();
            PluginVersionIdentifier pluginVersionIdentifier = versionedIdentifier.getVersion();
            String string = FeatureHierarchyElement.getUpdateVersionsMode();
            IFeature[] iFeatureArray = UpdateUtils.getInstalledFeatures(versionedIdentifier, false);
            int n = 0;
            while (true) {
                if (n >= iFeatureArray.length) {
                    return false;
                }
                IFeature iFeature = iFeatureArray[n];
                PluginVersionIdentifier pluginVersionIdentifier2 = iFeature.getVersionedIdentifier().getVersion();
                if (string.equals("greater")) {
                    return true;
                }
                if (string.equals("equivalent") ? pluginVersionIdentifier.isEquivalentTo(pluginVersionIdentifier2) : string.equals("compatible") && pluginVersionIdentifier.isCompatibleWith(pluginVersionIdentifier2)) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    private static IFeatureReference findPatchedReference(IFeatureReference iFeatureReference, IInstallConfiguration iInstallConfiguration) throws CoreException {
        VersionedIdentifier versionedIdentifier = iFeatureReference.getVersionedIdentifier();
        IConfiguredSite[] iConfiguredSiteArray = iInstallConfiguration.getConfiguredSites();
        int n = 0;
        while (n < iConfiguredSiteArray.length) {
            IConfiguredSite iConfiguredSite = iConfiguredSiteArray[n];
            IFeatureReference[] iFeatureReferenceArray = iConfiguredSite.getConfiguredFeatures();
            int n2 = 0;
            while (n2 < iFeatureReferenceArray.length) {
                IFeatureReference iFeatureReference2 = iFeatureReferenceArray[n2];
                VersionedIdentifier versionedIdentifier2 = iFeatureReference2.getVersionedIdentifier();
                if (versionedIdentifier.getIdentifier().equals(versionedIdentifier2.getIdentifier())) {
                    return iFeatureReference2;
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    public static Object[] getIncludedFeatures(IFeatureReference iFeatureReference) {
        try {
            IFeature iFeature = iFeatureReference.getFeature(null);
            return FeatureHierarchyElement.getIncludedFeatures(iFeature);
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    public static Object[] getIncludedFeatures(IFeature iFeature) {
        try {
            return iFeature.getIncludedFeatureReferences();
        }
        catch (CoreException coreException) {
            return new Object[0];
        }
    }

    private static String getUpdateVersionsMode() {
        Preferences preferences = AppPlugin.getPlugin().getPluginPreferences();
        return preferences.getString("org.eclipse.update.core.updateVersions");
    }
}

