/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.operations;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.internal.operations.FeatureHierarchyElement;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IInstallFeatureOperation;

public class JobRoot {
    private IInstallFeatureOperation job;
    private FeatureHierarchyElement[] elements;

    public JobRoot(IInstallFeatureOperation iInstallFeatureOperation) {
        this.job = iInstallFeatureOperation;
    }

    public IInstallFeatureOperation getJob() {
        return this.job;
    }

    public FeatureHierarchyElement[] getElements() {
        if (this.elements == null) {
            this.computeElements();
        }
        return this.elements;
    }

    public IFeature[] getUnconfiguredOptionalFeatures(IInstallConfiguration iInstallConfiguration, IConfiguredSite iConfiguredSite) {
        ArrayList arrayList = new ArrayList();
        this.getUnconfiguredOptionalFeatures(arrayList, iInstallConfiguration, iConfiguredSite, this.getElements(), UpdateUtils.isPatch(this.job.getFeature()));
        IFeature[] iFeatureArray = new IFeature[arrayList.size()];
        arrayList.toArray(iFeatureArray);
        return iFeatureArray;
    }

    private void getUnconfiguredOptionalFeatures(ArrayList arrayList, IInstallConfiguration iInstallConfiguration, IConfiguredSite iConfiguredSite, FeatureHierarchyElement[] featureHierarchyElementArray, boolean bl) {
        int n = 0;
        while (n < featureHierarchyElementArray.length) {
            FeatureHierarchyElement[] featureHierarchyElementArray2 = featureHierarchyElementArray[n].getChildren(true, bl, iInstallConfiguration);
            this.getUnconfiguredOptionalFeatures(arrayList, iInstallConfiguration, iConfiguredSite, featureHierarchyElementArray2, bl);
            if (!featureHierarchyElementArray[n].isEnabled(iInstallConfiguration)) {
                arrayList.add(featureHierarchyElementArray[n].getFeature());
            }
            ++n;
        }
    }

    private void computeElements() {
        try {
            IFeature iFeature = this.job.getOldFeature();
            IFeature iFeature2 = this.job.getFeature();
            ArrayList arrayList = new ArrayList();
            boolean bl = UpdateUtils.isPatch(iFeature2);
            FeatureHierarchyElement.computeElements(iFeature, iFeature2, iFeature != null, bl, SiteManager.getLocalSite().getCurrentConfiguration(), arrayList);
            this.elements = new FeatureHierarchyElement[arrayList.size()];
            arrayList.toArray(this.elements);
            int n = 0;
            while (n < this.elements.length) {
                this.elements[n].setRoot(this);
                ++n;
            }
        }
        catch (CoreException coreException) {
            UpdateUtils.logException(coreException);
        }
    }
}

