/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ercp.xml.parser;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import javax.xml.parsers.SAXParser;
import org.eclipse.ercp.xml.io.IOSpecificCall;
import org.eclipse.ercp.xml.io.XmlInputStreamReader;
import org.eclipse.ercp.xml.parser.AttributesImpl;
import org.eclipse.ercp.xml.parser.CharDecoder;
import org.eclipse.ercp.xml.parser.EXmlMsg;
import org.eclipse.ercp.xml.parser.NSDeclaration;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class AbstractSAXParserImpl
extends SAXParser
implements Locator {
    Reader reader;
    InputSource source;
    CharDecoder charDecoder = CharDecoder.forXml();
    int lineNumber;
    int columnNumber;
    int currentState;
    char[] writeBuffer;
    int writeBufferIndex;
    int columnIndex;
    char[] refBuffer;
    int refBufferIndex;
    int cdataHeaderIndex;
    static final String CDATA_HEADER = "[CDATA[";
    int doctypeHeaderIndex;
    static final String DOCTYPE_HEADER = "DOCTYPE";
    int openSquareBrackets;
    int openAngleBrackets;
    String elementQName;
    String elementNamespace;
    String elementLocalName;
    String attributeQName;
    String attributeNamespace;
    String attributeLocalName;
    String attributeValue;
    AttributesImpl attributes;
    protected NSDeclaration currentNSDecl;
    int elementsDepth;
    boolean parsingYet;
    int closingValue;
    boolean checkXmlDeclaration;
    boolean fNamespaces = true;
    boolean fNamespacesPrefixes = false;
    protected boolean fStringInterning = this.canDoStringInterning();
    protected boolean fXmlNSUris = false;
    public static int WriteBufferSize = 5120;
    public static final String XmlOrgFeaturesPrefix = "http://xml.org/sax/features/";
    public static final String NamespacesFeature = "namespaces";
    public static final String NamespacePrefixesFeature = "namespace-prefixes";
    public static final String StringInterningFeature = "string-interning";
    public static final String XmlNSUris = "xmlns-uris";
    static final String[] XmlOrgFeatureIDs = new String[]{"namespaces", "namespace-prefixes", "validation", "external-general-entities", "external-parameter-entities", "is-standalone", "lexical-handler/parameter-entities", "resolve-dtd-uris", "string-interning", "use-attributes2", "use-locator2", "use-entity-resolver2", "xmlns-uris"};
    public static final String XmlOrgPropertiesPrefix = "http://xml.org/sax/properties/";
    public static final String LexicalHandlerID = "lexical-handler";
    static final String[] XmlOrgPropertyIDs = new String[]{"declaration-handler", "dom-node", "lexical-handler", "xml-string"};
    public static final int DOC_STATE = 0;
    public static final int PROLOG_STATE = 1;
    public static final int XPI_STATE = 2;
    public static final int MISC_STATE = 3;
    public static final int MISC2_STATE = 4;
    public static final int DT_DECL_STATE = 5;
    public static final int CMT2_STATE = 6;
    public static final int CMT3_STATE = 7;
    public static final int CMT4_STATE = 8;
    public static final int CMT5_STATE = 9;
    public static final int START_ELEMENT_STATE = 10;
    public static final int END_ELEMENT_STATE = 11;
    public static final int END_ELEMENT_NAME_STATE = 12;
    public static final int END_ELEMENT2_STATE = 13;
    public static final int ENDTAG_STATE = 14;
    public static final int ATTLIST_STATE = 15;
    public static final int ATTNAME_STATE = 16;
    public static final int ATTEQUAL_STATE = 17;
    public static final int ATTVALUE_STATE = 18;
    public static final int VALUE_STATE = 19;
    public static final int REF_STATE = 20;
    public static final int REFNAME_STATE = 21;
    public static final int REF2_STATE = 22;
    public static final int REF2NAME_STATE = 23;
    public static final int XPI_TARGET_NAME_STATE = 24;
    public static final int XPI_DATA_STATE = 25;
    public static final int XPI_DATA_VALUE_STATE = 26;
    public static final int XPI_DATA_END_STATE = 27;
    public static final int XPI_XML_END_STATE = 28;
    public static final int XPI_XML_TARGET_STATE = 29;
    public static final int XPI_ATTNAME_STATE = 30;
    public static final int XPI_ATTEQUAL_STATE = 31;
    public static final int XPI_ATTVALUE_STATE = 32;
    public static final int XPI_VALUE_STATE = 33;
    public static final int CDATA_STATE = 34;
    public static final int DOCTYPE_STATE = 35;
    public static final int CDATA_VALUE_STATE = 36;
    public static final int DOCTYPE_VALUE_STATE = 37;
    public static final int CDATA_END_STATE = 38;
    public static final int CDATA_END2_STATE = 39;

    public AbstractSAXParserImpl() {
        this.resetParser();
    }

    public void resetParser() {
        this.currentState = 0;
        this.writeBuffer = new char[WriteBufferSize];
        this.resetWriteBuffer();
        this.refBuffer = new char[WriteBufferSize];
        this.refBufferIndex = 0;
        this.currentNSDecl = new NSDeclaration();
        this.elementsDepth = 0;
        this.parsingYet = false;
        this.lineNumber = 0;
        this.columnNumber = 0;
        this.attributes = null;
    }

    final void resetWriteBufferWith(int n) {
        this.resetWriteBuffer();
        this.writeBuffer[this.writeBufferIndex++] = (char)n;
    }

    final void resetWriteBuffer() {
        this.writeBufferIndex = 0;
        this.columnIndex = -1;
    }

    final void appendToWriteBuffer(int n) {
        this.writeBuffer[this.writeBufferIndex++] = (char)n;
    }

    final void appendAndGrowToWriteBuffer(int n) {
        try {
            this.writeBuffer[this.writeBufferIndex++] = (char)n;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            int n2 = this.writeBuffer.length + WriteBufferSize;
            char[] cArray = new char[n2];
            System.arraycopy(this.writeBuffer, 0, cArray, 0, this.writeBuffer.length);
            this.writeBuffer = cArray;
            this.writeBuffer[this.writeBufferIndex - 1] = (char)n;
        }
    }

    final void resetRefBufferWith(int n) {
        this.refBufferIndex = 0;
        this.refBuffer[this.refBufferIndex++] = (char)n;
    }

    final void appendToRefBuffer(int n) {
        this.refBuffer[this.refBufferIndex++] = (char)n;
    }

    final void appendRefBufferToWriteBuffer() {
        this.appendToWriteBuffer(38);
        System.arraycopy(this.refBuffer, 0, this.writeBuffer, this.writeBufferIndex, this.refBufferIndex);
        this.writeBufferIndex += this.refBufferIndex;
    }

    final void appendRefValueToWriteBuffer() throws SAXException {
        String string = new String(this.refBuffer, 0, this.refBufferIndex);
        String string2 = this.charDecoder.getCharValue(string);
        if (string2 == null) {
            this.warning(EXmlMsg.getDefault().getString(24), "&" + string + ";");
            this.appendRefValueToWriteBuffer();
            this.appendToWriteBuffer(59);
        } else {
            this.appendToWriteBuffer(string2.charAt(0));
        }
    }

    final void resetElementQName() {
        this.elementQName = null;
        this.elementNamespace = null;
        this.elementLocalName = null;
    }

    final void endStartElementName() {
        this.endElementLocalName();
        if (this.fNamespaces) {
            this.pushNamespaceDeclaration();
        }
    }

    final void endElementLocalName() {
        this.elementQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
        if (this.columnIndex != -1) {
            this.elementNamespace = new String(this.writeBuffer, 0, this.columnIndex - 1);
            this.elementLocalName = new String(this.writeBuffer, this.columnIndex, this.writeBufferIndex - this.columnIndex);
        } else {
            this.elementNamespace = null;
            this.elementLocalName = this.elementQName;
        }
        this.resetWriteBuffer();
        this.attributes = null;
    }

    final void endElementNamespace() {
        this.columnIndex = this.writeBufferIndex;
    }

    final void resetAttributeQName() {
        this.attributeQName = null;
        this.attributeNamespace = null;
        this.attributeLocalName = null;
    }

    final void endAttributeLocalName() {
        this.attributeQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
        if (this.columnIndex != -1) {
            this.attributeNamespace = new String(this.writeBuffer, 0, this.columnIndex - 1);
            this.attributeLocalName = new String(this.writeBuffer, this.columnIndex, this.writeBufferIndex - this.columnIndex);
        } else {
            this.attributeNamespace = null;
            this.attributeLocalName = this.attributeQName;
        }
        this.resetWriteBuffer();
    }

    final void endAttributeNamespace() {
        this.columnIndex = this.writeBufferIndex;
    }

    final void resetAttributeValue() {
        this.attributeValue = null;
    }

    final void endAttValue() throws SAXException {
        this.attributeValue = new String(this.writeBuffer, 0, this.writeBufferIndex);
        this.resetWriteBuffer();
        this.addAttribute(this.attributeNamespace, this.attributeLocalName, this.attributeValue);
    }

    protected void addAttribute(String string, String string2, String string3) throws SAXException {
        if (!this.fNamespaces) {
            this.addAttribute(null, string, string2, "CDATA", string3);
        } else {
            String string4;
            if ("xmlns".equals(string2)) {
                string = string2;
                string2 = "";
            }
            String string5 = string4 = this.fXmlNSUris ? this.currentNSDecl.getUriFor(string) : null;
            if ("xmlns".equals(string)) {
                this.startPrefixMapping(string2, string3);
                if (this.fNamespacesPrefixes) {
                    this.addAttribute(string4, string, string2, "CDATA", string3);
                }
            } else {
                this.addAttribute(string4, string, string2, "CDATA", this.attributeValue);
            }
        }
    }

    void addAttribute(String string, String string2, String string3, String string4, String string5) {
        if (this.attributes == null) {
            this.attributes = new AttributesImpl();
        }
        this.attributes.addAttribute(string, string2, string3, string4, string5);
    }

    final int endPITargetName() {
        this.elementQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
        boolean bl = this.isXMLTargetNameWasFound();
        this.resetWriteBuffer();
        this.attributes = null;
        return bl ? 29 : 25;
    }

    final boolean isXMLTargetNameWasFound() {
        return !(this.writeBufferIndex != 3 || this.writeBuffer[0] != 'x' && this.writeBuffer[0] != 'X' || this.writeBuffer[1] != 'm' && this.writeBuffer[1] != 'M' || this.writeBuffer[2] != 'l' && this.writeBuffer[2] != 'L');
    }

    final void endPIAttributeName() {
        this.attributeQName = new String(this.writeBuffer, 0, this.writeBufferIndex);
    }

    final void endPIAttValue() {
        this.attributeValue = new String(this.writeBuffer, 0, this.writeBufferIndex);
        this.addAttribute("", "", this.attributeQName, "CDATA", this.attributeValue);
        this.resetWriteBuffer();
    }

    final void checkXmlDeclaration() throws SAXException {
        String string;
        if (this.elementQName != null && this.attributes != null && (string = this.attributes.getValue("", "encoding")) != null && this.source.getByteStream() != null) {
            try {
                ((XmlInputStreamReader)this.reader).setEncoding(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.warning(EXmlMsg.getDefault().getString(26), string);
            }
        }
    }

    public void parse(String string) throws IOException, SAXException {
        this.parse(new InputSource(string));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parse(InputSource inputSource) throws IOException, SAXException {
        Reader reader = null;
        try {
            if (this.parsingYet) {
                throw new NullPointerException(EXmlMsg.getDefault().getString(3));
            }
            this.parsingYet = true;
            this.resetParser();
            this.reader = null;
            this.source = inputSource;
            if (inputSource.getCharacterStream() != null) {
                this.reader = inputSource.getCharacterStream();
            } else if (inputSource.getByteStream() != null) {
                this.reader = new XmlInputStreamReader(inputSource.getByteStream(), inputSource.getEncoding());
            }
            if (inputSource.getSystemId() != null) {
                this.reader = reader = IOSpecificCall.getDefault().getReaderFromSystemID(inputSource.getSystemId(), inputSource.getEncoding());
            }
            if (this.reader == null) {
                throw new IllegalArgumentException(EXmlMsg.getDefault().getString(52));
            }
            this.doParse();
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.parsingYet = false;
            if (reader == null) throw throwable;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.parsingYet = false;
            if (reader == null) return;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        reader.close();
    }

    void doParse() throws IOException, SAXException {
        this.closingValue = -1;
        this.checkXmlDeclaration = false;
        boolean bl = true;
        this.startDocument();
        while (bl) {
            bl = this.parseNextCharacter(this.reader.read());
        }
    }

    final void newLine() {
        this.columnNumber = 0;
        ++this.lineNumber;
    }

    public boolean parseNextCharacter(int n) throws SAXException {
        ++this.columnNumber;
        switch (this.currentState) {
            case 0: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 60) {
                    this.currentState = 1;
                    return true;
                }
                if (n == -1) {
                    return false;
                }
                this.fatalError(16);
                return false;
            }
            case 1: {
                if (n == 63) {
                    this.checkXmlDeclaration = true;
                    this.currentState = 2;
                    return true;
                }
                if (n == 33) {
                    this.currentState = 5;
                    return true;
                }
                if (this.isNameStartChar(n)) {
                    this.resetWriteBufferWith(n);
                    this.currentState = 10;
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 2: {
                if (this.isNameStartChar(n)) {
                    this.resetWriteBufferWith(n);
                    this.currentState = 24;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 3: {
                if (n == 32 || n == 9 || n == 10) {
                    this.appendAndGrowToWriteBuffer(n);
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    this.appendAndGrowToWriteBuffer(n);
                    return true;
                }
                if (n == 60) {
                    this.fireCharacters();
                    this.resetWriteBuffer();
                    this.currentState = 4;
                    return true;
                }
                if (n == 38) {
                    this.currentState = 22;
                    return true;
                }
                if (n == 62) {
                    this.fatalError(16);
                    return false;
                }
                if (n == -1) {
                    this.endDocument();
                    return false;
                }
                this.appendAndGrowToWriteBuffer(n);
                return true;
            }
            case 4: {
                if (n == 63) {
                    this.checkXmlDeclaration = false;
                    this.currentState = 2;
                    return true;
                }
                if (n == 33) {
                    this.currentState = 5;
                    return true;
                }
                if (n == 47) {
                    this.currentState = 11;
                    return true;
                }
                if (this.isNameStartChar(n)) {
                    this.resetElementQName();
                    this.resetWriteBufferWith(n);
                    this.currentState = 10;
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 5: {
                if (n == 45) {
                    this.currentState = 6;
                    return true;
                }
                if (n == 91) {
                    this.currentState = 34;
                    this.cdataHeaderIndex = 1;
                    return true;
                }
                if (n == 68) {
                    this.currentState = 35;
                    this.doctypeHeaderIndex = 1;
                    return true;
                }
                this.fatalError(17);
                return false;
            }
            case 6: {
                if (n == 45) {
                    this.currentState = 7;
                    return true;
                }
                this.fatalError(17);
                return false;
            }
            case 7: {
                if (n == 45) {
                    this.currentState = 8;
                    return true;
                }
                if (n == -1) {
                    this.fatalError(20);
                } else {
                    if (n == 13) {
                        this.newLine();
                    }
                    return true;
                }
            }
            case 8: {
                if (n == 45) {
                    this.currentState = 9;
                    return true;
                }
                if (n == -1) {
                    this.fatalError(20);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.currentState = 7;
                return true;
            }
            case 9: {
                if (n == 62) {
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 10: {
                if (n == 32 || n == 9 || n == 10) {
                    this.endStartElementName();
                    this.currentState = 15;
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    this.endStartElementName();
                    this.currentState = 15;
                    return true;
                }
                if (n == 62) {
                    this.endStartElementName();
                    this.fireStartElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                if (n == 47) {
                    this.endStartElementName();
                    this.currentState = 14;
                    return true;
                }
                if (n == 58) {
                    this.appendToWriteBuffer(n);
                    this.endElementNamespace();
                    return true;
                }
                if (this.isNameChar(n)) {
                    this.appendToWriteBuffer(n);
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 11: {
                if (this.isNameStartChar(n)) {
                    this.resetWriteBufferWith(n);
                    this.currentState = 12;
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 12: {
                if (n == 32 || n == 9 || n == 10) {
                    this.endElementLocalName();
                    this.currentState = 13;
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    this.endElementLocalName();
                    this.currentState = 13;
                    return true;
                }
                if (n == 58) {
                    this.appendToWriteBuffer(n);
                    this.endElementNamespace();
                    return true;
                }
                if (n == 62) {
                    this.endElementLocalName();
                    this.fireEndElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                if (this.isNameChar(n)) {
                    this.appendToWriteBuffer(n);
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 13: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 62) {
                    this.fireEndElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                this.fatalError(13);
                return false;
            }
            case 14: {
                if (n == 62) {
                    this.fireStartElement();
                    this.fireEndElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 15: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 62) {
                    this.fireStartElement();
                    this.currentState = 3;
                    this.resetWriteBuffer();
                    return true;
                }
                if (n == 47) {
                    this.currentState = 14;
                    return true;
                }
                if (this.isNameStartChar(n)) {
                    this.resetAttributeQName();
                    this.resetWriteBufferWith(n);
                    this.currentState = 16;
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 16: {
                if (n == 32 || n == 9 || n == 10) {
                    this.endAttributeLocalName();
                    this.currentState = 17;
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    this.endAttributeLocalName();
                    this.currentState = 17;
                    return true;
                }
                if (n == 58) {
                    this.appendToWriteBuffer(n);
                    this.endAttributeNamespace();
                    return true;
                }
                if (n == 61) {
                    this.endAttributeLocalName();
                    this.currentState = 18;
                    return true;
                }
                if (this.isNameChar(n)) {
                    this.appendToWriteBuffer(n);
                    return true;
                }
                this.fatalError(15);
                return false;
            }
            case 17: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 61) {
                    this.currentState = 18;
                    return true;
                }
                this.fatalError(19);
                return false;
            }
            case 18: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 34 || n == 39) {
                    this.resetAttributeValue();
                    this.resetWriteBuffer();
                    this.currentState = 19;
                    this.closingValue = n;
                    return true;
                }
                this.fatalError(19);
                return false;
            }
            case 19: {
                if (n == this.closingValue) {
                    this.endAttValue();
                    this.currentState = 15;
                    return true;
                }
                if (n == 38) {
                    this.currentState = 20;
                    return true;
                }
                if (n == 62 || n == 60) {
                    this.fatalError(21);
                    return false;
                }
                if (n == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendToWriteBuffer(n);
                return true;
            }
            case 20: {
                if (n == this.closingValue) {
                    this.appendToWriteBuffer(38);
                    this.endAttValue();
                    this.currentState = 15;
                    return true;
                }
                if (n == 38) {
                    this.appendToWriteBuffer(38);
                    return true;
                }
                if (n == 60 || n == 62) {
                    this.fatalError(21);
                    return false;
                }
                if (this.isNameStartChar(n)) {
                    this.resetRefBufferWith(n);
                    this.currentState = 21;
                    return true;
                }
                if (n == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendToWriteBuffer(38);
                this.appendToWriteBuffer(n);
                this.currentState = 19;
                return true;
            }
            case 21: {
                if (n == this.closingValue) {
                    this.appendRefBufferToWriteBuffer();
                    this.endAttValue();
                    this.currentState = 15;
                    return true;
                }
                if (n == 38) {
                    this.appendRefBufferToWriteBuffer();
                    this.currentState = 20;
                    return true;
                }
                if (n == 59) {
                    this.appendRefValueToWriteBuffer();
                    this.currentState = 19;
                    return true;
                }
                if (n == 60 || n == 62) {
                    this.fatalError(21);
                    return false;
                }
                if (this.isNameChar(n)) {
                    this.appendToRefBuffer(n);
                    return true;
                }
                if (n == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendRefBufferToWriteBuffer();
                this.currentState = 19;
                return true;
            }
            case 22: {
                if (n == 60) {
                    this.appendToWriteBuffer(38);
                    this.currentState = 4;
                    return true;
                }
                if (n == 38) {
                    this.appendToWriteBuffer(38);
                    return true;
                }
                if (n == 62) {
                    this.fatalError(12);
                    return false;
                }
                if (this.isNameChar(n)) {
                    this.resetRefBufferWith(n);
                    this.currentState = 23;
                    return true;
                }
                if (n == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendToWriteBuffer(38);
                this.appendToWriteBuffer(n);
                this.currentState = 3;
                return true;
            }
            case 23: {
                if (n == 60) {
                    this.appendRefBufferToWriteBuffer();
                    this.currentState = 4;
                    return true;
                }
                if (n == 38) {
                    this.appendRefBufferToWriteBuffer();
                    this.currentState = 22;
                    return true;
                }
                if (n == 59) {
                    this.appendRefValueToWriteBuffer();
                    this.currentState = 3;
                    return true;
                }
                if (n == 62) {
                    this.fatalError(12);
                    return false;
                }
                if (this.isNameChar(n)) {
                    this.appendToRefBuffer(n);
                    return true;
                }
                if (n == -1) {
                    this.fatalError(21);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendRefBufferToWriteBuffer();
                this.currentState = 3;
                return true;
            }
            case 24: {
                if (n == 32 || n == 9 || n == 10) {
                    this.currentState = this.endPITargetName();
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    this.currentState = this.endPITargetName();
                    return true;
                }
                if (n == 63) {
                    this.currentState = this.endPITargetName();
                    this.currentState = this.currentState == 29 ? 28 : 27;
                    return true;
                }
                if (this.isNameChar(n)) {
                    this.appendToWriteBuffer(n);
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 25: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 63) {
                    this.currentState = 27;
                    return true;
                }
                if (n == -1) {
                    this.fatalError(18);
                    return false;
                }
                this.resetWriteBufferWith(n);
                this.currentState = 26;
                return true;
            }
            case 26: {
                if (n == -1) {
                    this.fatalError(18);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 63) {
                    this.currentState = 27;
                    return true;
                }
                this.appendToWriteBuffer(n);
                return true;
            }
            case 27: {
                if (n == 62) {
                    this.fireProcessingInstruction();
                    this.resetWriteBuffer();
                    this.currentState = 3;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 28: {
                if (n == 62) {
                    if (this.checkXmlDeclaration) {
                        this.checkXmlDeclaration();
                    }
                    this.resetWriteBuffer();
                    this.currentState = 3;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 29: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 63) {
                    this.currentState = 28;
                    return true;
                }
                if (this.isNameStartChar(n)) {
                    this.resetWriteBufferWith(n);
                    this.currentState = 30;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 30: {
                if (n == 32 || n == 9 || n == 10) {
                    this.endPIAttributeName();
                    this.currentState = 31;
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    this.endPIAttributeName();
                    this.currentState = 31;
                    return true;
                }
                if (n == 61) {
                    this.endPIAttributeName();
                    this.currentState = 32;
                    return true;
                }
                if (this.isNameChar(n)) {
                    this.appendToWriteBuffer(n);
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 31: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 61) {
                    this.currentState = 32;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 32: {
                if (n == 32 || n == 9 || n == 10) {
                    return true;
                }
                if (n == 13) {
                    this.newLine();
                    return true;
                }
                if (n == 34 || n == 39) {
                    this.resetAttributeValue();
                    this.resetWriteBuffer();
                    this.currentState = 33;
                    this.closingValue = n;
                    return true;
                }
                this.fatalError(18);
                return false;
            }
            case 33: {
                if (n == this.closingValue) {
                    this.endPIAttValue();
                    this.currentState = 29;
                    return true;
                }
                if (n == 62 || n == 60) {
                    this.fatalError(21);
                    return false;
                }
                if (n == -1) {
                    this.fatalError(20);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendToWriteBuffer(n);
                return true;
            }
            case 34: {
                if (CDATA_HEADER.charAt(this.cdataHeaderIndex) == n) {
                    ++this.cdataHeaderIndex;
                    if (this.cdataHeaderIndex == CDATA_HEADER.length()) {
                        this.resetWriteBuffer();
                        this.startCDATA();
                        this.currentState = 36;
                        return true;
                    }
                    return true;
                }
                this.fatalError(57);
                return false;
            }
            case 35: {
                if (DOCTYPE_HEADER.charAt(this.doctypeHeaderIndex) == n) {
                    ++this.doctypeHeaderIndex;
                    if (this.doctypeHeaderIndex == DOCTYPE_HEADER.length()) {
                        this.openAngleBrackets = 0;
                        this.openSquareBrackets = 0;
                        this.currentState = 37;
                        return true;
                    }
                    return true;
                }
                this.fatalError(58);
                return false;
            }
            case 36: {
                if (n == 93) {
                    this.currentState = 38;
                    return true;
                }
                if (n == -1) {
                    this.fatalError(57);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(n);
                return true;
            }
            case 38: {
                if (n == 93) {
                    this.currentState = 39;
                    return true;
                }
                if (n == -1) {
                    this.fatalError(57);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                this.appendAndGrowToWriteBuffer(93);
                this.appendAndGrowToWriteBuffer(n);
                this.currentState = 36;
                return true;
            }
            case 39: {
                if (n == 62) {
                    this.fireCharacters();
                    this.resetWriteBuffer();
                    this.endCDATA();
                    this.currentState = 3;
                    return true;
                }
                this.fatalError(57);
                return false;
            }
            case 37: {
                if (n == 62) {
                    if (this.openAngleBrackets > 0) {
                        --this.openAngleBrackets;
                        return true;
                    }
                    if (this.openSquareBrackets == 0) {
                        this.currentState = 3;
                        return true;
                    }
                    this.fatalError(58);
                    return false;
                }
                if (n == 60) {
                    ++this.openAngleBrackets;
                    return true;
                }
                if (n == 91) {
                    ++this.openSquareBrackets;
                    return true;
                }
                if (n == 93) {
                    --this.openSquareBrackets;
                    if (this.openSquareBrackets >= 0) {
                        return true;
                    }
                    this.fatalError(58);
                    return false;
                }
                if (n == -1) {
                    this.fatalError(58);
                    return false;
                }
                if (n == 13) {
                    this.newLine();
                }
                return true;
            }
        }
        this.fatalError(12);
        return false;
    }

    final boolean isNameStartChar(int n) {
        return this.isIn(n, 97, 122) || this.isIn(n, 65, 90) || n == 95 || this.isIn(n, 192, 214) || this.isIn(n, 216, 246) || this.isIn(n, 248, 767) || this.isIn(n, 880, 893) || this.isIn(n, 895, 8191) || this.isIn(n, 8204, 8205) || this.isIn(n, 8304, 8591) || this.isIn(n, 11264, 12271) || this.isIn(n, 12289, 55295) || this.isIn(n, 63744, 64975) || this.isIn(n, 65008, 65533) || this.isIn(n, 65536, 983039);
    }

    final boolean isNameChar(int n) {
        return this.isIn(n, 97, 122) || this.isIn(n, 65, 90) || this.isIn(n, 48, 57) || n == 95 || n == 45 || n == 46 || n == 183 || this.isIn(n, 192, 214) || this.isIn(n, 216, 246) || this.isIn(n, 248, 893) || this.isIn(n, 895, 8191) || this.isIn(n, 8204, 8205) || this.isIn(n, 8255, 8256) || this.isIn(n, 8304, 8591) || this.isIn(n, 11264, 12271) || this.isIn(n, 12289, 55295) || this.isIn(n, 63744, 64975) || this.isIn(n, 65008, 65533) || this.isIn(n, 65536, 983039);
    }

    final boolean isIn(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    public void setCharDecoder(CharDecoder charDecoder) {
        this.charDecoder = charDecoder;
    }

    public CharDecoder getCharDecoder() {
        return this.charDecoder;
    }

    void fatalError(int n) throws SAXException {
        this.fatalError(n, null);
    }

    void fatalError(int n, String string) throws SAXException {
        this.fatalError(EXmlMsg.getDefault().getString(n), string);
    }

    void warning(int n, String string) throws SAXException {
        this.warning(EXmlMsg.getDefault().getString(n), string);
    }

    public String getWriteBufferAsString() {
        return new String(this.writeBuffer, 0, this.writeBufferIndex);
    }

    public String getElementLocalName() {
        return this.elementLocalName;
    }

    public int getCurrentState() {
        return this.currentState;
    }

    protected static String errorMsg(String string, String string2) {
        return string2 != null ? String.valueOf(string) + ": " + string2 : string;
    }

    public boolean isValidating() {
        return false;
    }

    public boolean isNamespaceAware() {
        try {
            return this.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            return false;
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            return false;
        }
    }

    public void setNamespaceAware(boolean bl) {
        try {
            this.setFeature("http://xml.org/sax/features/namespaces", bl);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {}
    }

    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2 = this.checkID(string, XmlOrgFeaturesPrefix, XmlOrgFeatureIDs);
        if (string2 == null) {
            throw new SAXNotRecognizedException(string);
        }
        if (NamespacesFeature.equals(string2)) {
            return this.fNamespaces;
        }
        if (NamespacePrefixesFeature.equals(string2)) {
            return this.fNamespacesPrefixes;
        }
        if (StringInterningFeature.equals(string2)) {
            if (this.canDoStringInterning()) {
                return this.fStringInterning;
            }
            throw new SAXNotSupportedException(string);
        }
        throw new SAXNotSupportedException(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2 = this.checkID(string, XmlOrgFeaturesPrefix, XmlOrgFeatureIDs);
        if (string2 == null) {
            throw new SAXNotRecognizedException(string);
        }
        if (NamespacesFeature.equals(string2)) {
            this.fNamespaces = bl;
            return;
        } else if (NamespacePrefixesFeature.equals(string2)) {
            this.fNamespacesPrefixes = bl;
            return;
        } else if (StringInterningFeature.equals(string2)) {
            if (!this.canDoStringInterning()) throw new SAXNotSupportedException(string);
            this.fStringInterning = bl;
            return;
        } else {
            if (!XmlNSUris.equals(string2)) throw new SAXNotSupportedException(string);
            this.fXmlNSUris = bl;
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2 = this.checkID(string, XmlOrgPropertiesPrefix, XmlOrgPropertyIDs);
        if (string2 != null) {
            return this.getRecognizedXmlOrgProperty(string2);
        }
        throw new SAXNotRecognizedException(string);
    }

    protected Object getRecognizedXmlOrgProperty(String string) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        String string2 = this.checkID(string, XmlOrgPropertiesPrefix, XmlOrgPropertyIDs);
        if (string2 == null) {
            throw new SAXNotRecognizedException(string);
        }
        this.setRecognizedXmlOrgProperty(string2, object);
    }

    protected void setRecognizedXmlOrgProperty(String string, Object object) throws SAXNotSupportedException {
        throw new SAXNotSupportedException(string);
    }

    protected abstract boolean canDoStringInterning();

    String checkID(String string, String string2, String[] stringArray) {
        if (string == null) {
            return null;
        }
        if (!string.startsWith(string2)) {
            return null;
        }
        String string3 = string.substring(string2.length());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (string3.startsWith(stringArray[n2])) {
                return string3;
            }
            ++n2;
        }
        return null;
    }

    final void popNamespaceDeclaration() throws SAXException {
        while (!this.currentNSDecl.isNamed(this.elementNamespace, this.elementLocalName)) {
            this.endPrefixMapping(this.currentNSDecl);
            this.currentNSDecl = this.currentNSDecl.parent;
            if (this.currentNSDecl != null) continue;
            this.fatalError(55, this.elementLocalName);
        }
        this.endPrefixMapping(this.currentNSDecl);
        this.currentNSDecl = this.currentNSDecl.parent;
    }

    final void pushNamespaceDeclaration() {
        this.currentNSDecl = new NSDeclaration(this.elementNamespace, this.elementLocalName, this.currentNSDecl);
    }

    final void fireEndElement() throws SAXException {
        this.endElement(this.elementQName, this.elementNamespace, this.elementLocalName);
        if (this.fNamespaces) {
            this.popNamespaceDeclaration();
        }
        --this.elementsDepth;
    }

    final void fireStartElement() throws SAXException {
        this.startElement(this.elementQName, this.elementNamespace, this.elementLocalName, this.attributes == null ? AttributesImpl.EmptyList : this.attributes);
        ++this.elementsDepth;
    }

    protected abstract void startCDATA() throws SAXException;

    protected abstract void endCDATA() throws SAXException;

    final void fireProcessingInstruction() throws SAXException {
        String string = this.writeBufferIndex != 0 ? new String(this.writeBuffer, 0, this.writeBufferIndex) : null;
        this.processingInstruction(this.elementQName, string);
    }

    final void fireCharacters() throws SAXException {
        if (this.elementsDepth > 0) {
            this.characters(this.writeBuffer, 0, this.writeBufferIndex);
        }
    }

    protected abstract void processingInstruction(String var1, String var2) throws SAXException;

    protected abstract void characters(char[] var1, int var2, int var3) throws SAXException;

    protected abstract void startElement(String var1, String var2, String var3, AttributesImpl var4) throws SAXException;

    protected abstract void endElement(String var1, String var2, String var3) throws SAXException;

    protected abstract void startDocument() throws SAXException;

    protected abstract void endDocument() throws SAXException;

    protected abstract void endPrefixMapping(NSDeclaration var1) throws SAXException;

    protected abstract void startPrefixMapping(String var1, String var2) throws SAXException;

    protected abstract void fatalError(String var1, String var2) throws SAXException;

    protected abstract void warning(String var1, String var2) throws SAXException;

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getPublicId() {
        return this.source.getPublicId();
    }

    public String getSystemId() {
        return this.source.getSystemId();
    }
}

